/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.viewsdisplay;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;
import org.opennms.netmgt.config.viewsdisplay.Section;

@XmlRootElement(name="view")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="viewsdisplay.xsd")
public class View
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement(name="view-name", required=true)
    private String m_viewName;
    @XmlElement(name="section", required=true)
    private List<Section> m_sections = new ArrayList<Section>();

    public String getViewName() {
        return this.m_viewName;
    }

    public void setViewName(String viewName) {
        this.m_viewName = ConfigUtils.assertNotEmpty(viewName, "view-name");
    }

    public List<Section> getSections() {
        return this.m_sections;
    }

    public void setSections(List<Section> sections) {
        if (sections == this.m_sections) {
            return;
        }
        this.m_sections.clear();
        if (sections != null) {
            this.m_sections.addAll(sections);
        }
    }

    public void addSection(Section section) {
        this.m_sections.add(section);
    }

    public boolean removeSection(Section section) {
        return this.m_sections.remove(section);
    }

    public int hashCode() {
        return Objects.hash(this.m_viewName, this.m_sections);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof View) {
            View that = (View)obj;
            return Objects.equals(this.m_viewName, that.m_viewName) && Objects.equals(this.m_sections, that.m_sections);
        }
        return false;
    }
}

