/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.threshd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.threshd.Group;

@XmlRootElement(name="thresholding-config")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="thresholding.xsd")
public class ThresholdingConfig
implements Serializable {
    private static final long serialVersionUID = 2L;
    private List<Group> m_groups = new ArrayList<Group>();
    private final Map<String, Group> m_groupMap = new ConcurrentHashMap<String, Group>();

    @XmlElement(name="group")
    public List<Group> getGroups() {
        return this.m_groups;
    }

    public void setGroups(List<Group> groups) {
        if (groups == this.m_groups) {
            if (this.m_groupMap.isEmpty()) {
                groups.forEach(g -> this.m_groupMap.put(g.getName(), (Group)g));
            }
        } else {
            this.m_groups.clear();
            this.m_groupMap.clear();
            if (groups != null) {
                this.m_groups.addAll(groups);
                groups.forEach(g -> this.m_groupMap.put(g.getName(), (Group)g));
            }
        }
    }

    public Group getGroup(String groupName) {
        Objects.requireNonNull(groupName);
        Group group = this.m_groupMap.get(groupName);
        if (group == null) {
            throw new IllegalArgumentException("Thresholding group " + groupName + " does not exist.");
        }
        return group;
    }

    public void addGroup(Group group) {
        this.m_groups.add(group);
        this.m_groupMap.put(group.getName(), group);
    }

    public boolean removeGroup(Group group) {
        this.m_groupMap.remove(group.getName());
        return this.m_groups.remove(group);
    }

    public int hashCode() {
        return Objects.hash(this.m_groups);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ThresholdingConfig) {
            ThresholdingConfig that = (ThresholdingConfig)obj;
            return Objects.equals(this.m_groups, that.m_groups);
        }
        return false;
    }
}

