/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.service.Service;

@XmlRootElement(name="service-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="service-configuration.xsd")
public class ServiceConfiguration
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement(name="service")
    private List<Service> m_services = new ArrayList<Service>();

    public ServiceConfiguration() {
    }

    public ServiceConfiguration(List<Service> services) {
        this.setServices(services);
    }

    public List<Service> getServices() {
        return this.m_services;
    }

    public void setServices(List<Service> services) {
        if (services == this.m_services) {
            return;
        }
        this.m_services.clear();
        if (services != null) {
            this.m_services.addAll(services);
        }
    }

    public void addService(Service service) {
        this.m_services.add(service);
    }

    public boolean removeService(Service service) {
        return this.m_services.remove(service);
    }

    public int hashCode() {
        return Objects.hash(this.m_services);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ServiceConfiguration) {
            ServiceConfiguration that = (ServiceConfiguration)obj;
            return Objects.equals(this.m_services, that.m_services);
        }
        return false;
    }
}

