/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.statsd.model;

import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.config.statsd.Package;
import org.opennms.netmgt.config.statsd.PackageReportStatus;
import org.opennms.netmgt.config.statsd.Parameter;
import org.opennms.netmgt.config.statsd.StatisticsDaemonConfiguration;
import org.opennms.netmgt.config.statsd.model.PackageReport;
import org.opennms.netmgt.config.statsd.model.Report;
import org.opennms.netmgt.config.statsd.model.StatsdPackage;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ObjectRetrievalFailureException;

public class StatsdConfig {
    private StatisticsDaemonConfiguration m_config;
    private List<Report> m_reports = new ArrayList<Report>();
    private List<StatsdPackage> m_packages = new ArrayList<StatsdPackage>();

    public StatsdConfig(StatisticsDaemonConfiguration config) {
        this.m_config = config;
        for (org.opennms.netmgt.config.statsd.Report report : this.getXmlReports()) {
            Report r = new Report();
            r.setName(report.getName());
            r.setClassName(report.getClassName());
            for (Parameter parameter : this.getParametersForReport(report)) {
                r.addParameter(parameter.getKey(), parameter.getValue());
            }
            this.m_reports.add(r);
        }
        for (Package pkg : this.getXmlPackages()) {
            StatsdPackage p = new StatsdPackage();
            p.setName(pkg.getName());
            if (pkg.getFilter().isPresent() && pkg.getFilter().get().getContent().isPresent()) {
                p.setFilter(pkg.getFilter().get().getContent().get());
            }
            for (org.opennms.netmgt.config.statsd.PackageReport packageReport : this.getPackageReportForPackage(pkg)) {
                PackageReport r = new PackageReport();
                r.setPackage(p);
                try {
                    r.setReport(this.loadReport(packageReport.getName()));
                }
                catch (DataAccessException e) {
                    throw new ObjectRetrievalFailureException("Could not get report named '" + packageReport.getName() + "' for package '" + pkg.getName() + "'", (Object)pkg.getName(), null, (Throwable)e);
                }
                r.setDescription(packageReport.getDescription());
                r.setRetainInterval(Long.parseLong(packageReport.getRetainInterval()));
                r.setSchedule(packageReport.getSchedule());
                r.setEnabled(packageReport.getStatus().equals((Object)PackageReportStatus.on));
                for (Parameter parameter : this.getParametersForPackageReport(packageReport)) {
                    r.addParameter(parameter.getKey(), parameter.getValue());
                }
                p.addReport(r);
            }
            this.m_packages.add(p);
        }
    }

    public List<Report> getReports() {
        return this.m_reports;
    }

    public List<StatsdPackage> getPackages() {
        return this.m_packages;
    }

    private Report loadReport(String name) {
        for (Report report : this.m_reports) {
            if (!name.equals(report.getName())) continue;
            return report;
        }
        throw new ObjectRetrievalFailureException("There is no report definition named '" + name + "'", (Object)name);
    }

    private List<Parameter> getParametersForReport(org.opennms.netmgt.config.statsd.Report report) {
        return report.getParameters();
    }

    private List<org.opennms.netmgt.config.statsd.Report> getXmlReports() {
        return this.m_config.getReports();
    }

    private List<Package> getXmlPackages() {
        return this.m_config.getPackages();
    }

    private List<org.opennms.netmgt.config.statsd.PackageReport> getPackageReportForPackage(Package pkg) {
        return pkg.getPackageReports();
    }

    private List<Parameter> getParametersForPackageReport(org.opennms.netmgt.config.statsd.PackageReport packageReport) {
        return packageReport.getParameters();
    }
}

