/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.statsd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.statsd.Filter;
import org.opennms.netmgt.config.statsd.PackageReport;
import org.xml.sax.ContentHandler;

public class Package
implements Serializable {
    private String _name;
    private Filter _filter;
    private List<PackageReport> _packageReportList = new ArrayList<PackageReport>();

    public void addPackageReport(PackageReport vPackageReport) throws IndexOutOfBoundsException {
        this._packageReportList.add(vPackageReport);
    }

    public void addPackageReport(int index, PackageReport vPackageReport) throws IndexOutOfBoundsException {
        this._packageReportList.add(index, vPackageReport);
    }

    public Enumeration<PackageReport> enumeratePackageReport() {
        return Collections.enumeration(this._packageReportList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Package) {
            Package temp = (Package)obj;
            if (this._name != null) {
                if (temp._name == null) {
                    return false;
                }
                if (!this._name.equals(temp._name)) {
                    return false;
                }
            } else if (temp._name != null) {
                return false;
            }
            if (this._filter != null) {
                if (temp._filter == null) {
                    return false;
                }
                if (!this._filter.equals(temp._filter)) {
                    return false;
                }
            } else if (temp._filter != null) {
                return false;
            }
            if (this._packageReportList != null) {
                if (temp._packageReportList == null) {
                    return false;
                }
                if (!((Object)this._packageReportList).equals(temp._packageReportList)) {
                    return false;
                }
            } else if (temp._packageReportList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Filter getFilter() {
        return this._filter;
    }

    public String getName() {
        return this._name;
    }

    public PackageReport getPackageReport(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._packageReportList.size()) {
            throw new IndexOutOfBoundsException("getPackageReport: Index value '" + index + "' not in range [0.." + (this._packageReportList.size() - 1) + "]");
        }
        return this._packageReportList.get(index);
    }

    public PackageReport[] getPackageReport() {
        PackageReport[] array = new PackageReport[]{};
        return this._packageReportList.toArray(array);
    }

    public List<PackageReport> getPackageReportCollection() {
        return this._packageReportList;
    }

    public int getPackageReportCount() {
        return this._packageReportList.size();
    }

    public int hashCode() {
        int result = 17;
        if (this._name != null) {
            result = 37 * result + this._name.hashCode();
        }
        if (this._filter != null) {
            result = 37 * result + this._filter.hashCode();
        }
        if (this._packageReportList != null) {
            result = 37 * result + ((Object)this._packageReportList).hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<PackageReport> iteratePackageReport() {
        return this._packageReportList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllPackageReport() {
        this._packageReportList.clear();
    }

    public boolean removePackageReport(PackageReport vPackageReport) {
        boolean removed = this._packageReportList.remove(vPackageReport);
        return removed;
    }

    public PackageReport removePackageReportAt(int index) {
        PackageReport obj = this._packageReportList.remove(index);
        return obj;
    }

    public void setFilter(Filter filter) {
        this._filter = filter;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setPackageReport(int index, PackageReport vPackageReport) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._packageReportList.size()) {
            throw new IndexOutOfBoundsException("setPackageReport: Index value '" + index + "' not in range [0.." + (this._packageReportList.size() - 1) + "]");
        }
        this._packageReportList.set(index, vPackageReport);
    }

    public void setPackageReport(PackageReport[] vPackageReportArray) {
        this._packageReportList.clear();
        for (int i = 0; i < vPackageReportArray.length; ++i) {
            this._packageReportList.add(vPackageReportArray[i]);
        }
    }

    public void setPackageReport(List<PackageReport> vPackageReportList) {
        this._packageReportList.clear();
        this._packageReportList.addAll(vPackageReportList);
    }

    public void setPackageReportCollection(List<PackageReport> packageReportList) {
        this._packageReportList = packageReportList;
    }

    public static Package unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Package)Unmarshaller.unmarshal(Package.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

