/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.service;

import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.service.Attribute;
import org.opennms.netmgt.config.service.Invoke;

public class Service
implements Serializable {
    private static final long serialVersionUID = -2554947387909986065L;
    @XmlElement(name="name")
    private String _name;
    @XmlElement(name="class-name")
    private String _className;
    @XmlElement(name="attribute")
    private List<Attribute> _attributeList = new ArrayList<Attribute>(0);
    @XmlElement(name="invoke")
    private List<Invoke> _invokeList = new ArrayList<Invoke>(0);

    public Service() {
    }

    public Service(String name, String className, List<Attribute> attributes, List<Invoke> invokes) {
        this.setName(name);
        this.setClassName(className);
        this.setAttribute(attributes);
        this.setInvoke(invokes);
    }

    public void addAttribute(Attribute vAttribute) throws IndexOutOfBoundsException {
        this._attributeList.add(vAttribute);
    }

    public void addAttribute(int index, Attribute vAttribute) throws IndexOutOfBoundsException {
        this._attributeList.add(index, vAttribute);
    }

    public void addInvoke(Invoke vInvoke) throws IndexOutOfBoundsException {
        this._invokeList.add(vInvoke);
    }

    public void addInvoke(int index, Invoke vInvoke) throws IndexOutOfBoundsException {
        this._invokeList.add(index, vInvoke);
    }

    public Enumeration<Attribute> enumerateAttribute() {
        return Collections.enumeration(this._attributeList);
    }

    public Enumeration<Invoke> enumerateInvoke() {
        return Collections.enumeration(this._invokeList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Service) {
            Service temp = (Service)obj;
            if (this._name != null) {
                if (temp._name == null) {
                    return false;
                }
                if (!this._name.equals(temp._name)) {
                    return false;
                }
            } else if (temp._name != null) {
                return false;
            }
            if (this._className != null) {
                if (temp._className == null) {
                    return false;
                }
                if (!this._className.equals(temp._className)) {
                    return false;
                }
            } else if (temp._className != null) {
                return false;
            }
            if (this._attributeList != null) {
                if (temp._attributeList == null) {
                    return false;
                }
                if (!((Object)this._attributeList).equals(temp._attributeList)) {
                    return false;
                }
            } else if (temp._attributeList != null) {
                return false;
            }
            if (this._invokeList != null) {
                if (temp._invokeList == null) {
                    return false;
                }
                if (!((Object)this._invokeList).equals(temp._invokeList)) {
                    return false;
                }
            } else if (temp._invokeList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Attribute getAttribute(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._attributeList.size()) {
            throw new IndexOutOfBoundsException("getAttribute: Index value '" + index + "' not in range [0.." + (this._attributeList.size() - 1) + "]");
        }
        return this._attributeList.get(index);
    }

    @XmlTransient
    public Attribute[] getAttribute() {
        Attribute[] array = new Attribute[]{};
        return this._attributeList.toArray(array);
    }

    @XmlTransient
    public List<Attribute> getAttributeCollection() {
        return this._attributeList;
    }

    public int getAttributeCount() {
        return this._attributeList.size();
    }

    @XmlTransient
    public String getClassName() {
        return this._className;
    }

    public Invoke getInvoke(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._invokeList.size()) {
            throw new IndexOutOfBoundsException("getInvoke: Index value '" + index + "' not in range [0.." + (this._invokeList.size() - 1) + "]");
        }
        return this._invokeList.get(index);
    }

    @XmlTransient
    public Invoke[] getInvoke() {
        Invoke[] array = new Invoke[]{};
        return this._invokeList.toArray(array);
    }

    @XmlTransient
    public List<Invoke> getInvokeCollection() {
        return this._invokeList;
    }

    public int getInvokeCount() {
        return this._invokeList.size();
    }

    @XmlTransient
    public String getName() {
        return this._name;
    }

    public int hashCode() {
        int result = 17;
        if (this._name != null) {
            result = 37 * result + this._name.hashCode();
        }
        if (this._className != null) {
            result = 37 * result + this._className.hashCode();
        }
        if (this._attributeList != null) {
            result = 37 * result + ((Object)this._attributeList).hashCode();
        }
        if (this._invokeList != null) {
            result = 37 * result + ((Object)this._invokeList).hashCode();
        }
        return result;
    }

    public Iterator<Attribute> iterateAttribute() {
        return this._attributeList.iterator();
    }

    public Iterator<Invoke> iterateInvoke() {
        return this._invokeList.iterator();
    }

    public void marshal(Writer out) {
        JaxbUtils.marshal((Object)this, (Writer)out);
    }

    public void removeAllAttribute() {
        this._attributeList.clear();
    }

    public void removeAllInvoke() {
        this._invokeList.clear();
    }

    public boolean removeAttribute(Attribute vAttribute) {
        return this._attributeList.remove(vAttribute);
    }

    public Attribute removeAttributeAt(int index) {
        return this._attributeList.remove(index);
    }

    public boolean removeInvoke(Invoke vInvoke) {
        return this._invokeList.remove(vInvoke);
    }

    public Invoke removeInvokeAt(int index) {
        return this._invokeList.remove(index);
    }

    public void setAttribute(int index, Attribute vAttribute) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._attributeList.size()) {
            throw new IndexOutOfBoundsException("setAttribute: Index value '" + index + "' not in range [0.." + (this._attributeList.size() - 1) + "]");
        }
        this._attributeList.set(index, vAttribute);
    }

    public void setAttribute(Attribute[] vAttributeArray) {
        this._attributeList.clear();
        for (int i = 0; i < vAttributeArray.length; ++i) {
            this._attributeList.add(vAttributeArray[i]);
        }
    }

    public void setAttribute(List<Attribute> vAttributeList) {
        this._attributeList.clear();
        this._attributeList.addAll(vAttributeList);
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setInvoke(int index, Invoke vInvoke) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._invokeList.size()) {
            throw new IndexOutOfBoundsException("setInvoke: Index value '" + index + "' not in range [0.." + (this._invokeList.size() - 1) + "]");
        }
        this._invokeList.set(index, vInvoke);
    }

    public void setInvoke(Invoke[] vInvokeArray) {
        this._invokeList.clear();
        for (int i = 0; i < vInvokeArray.length; ++i) {
            this._invokeList.add(vInvokeArray[i]);
        }
    }

    public void setInvoke(List<Invoke> vInvokeList) {
        this._invokeList.clear();
        this._invokeList.addAll(vInvokeList);
    }

    public void setName(String name) {
        this._name = name;
    }
}

