/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.mailtransporttest;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.mailtransporttest.JavamailProperty;
import org.opennms.netmgt.config.mailtransporttest.ReadmailHost;
import org.opennms.netmgt.config.mailtransporttest.UserAuth;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="readmail-test")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ReadmailTest
implements Serializable {
    private static final long serialVersionUID = -737845064838033210L;
    private static final JavamailProperty[] EMPTY_LIST_OF_JAVAMAIL_PROPERTIES = new JavamailProperty[0];
    @XmlAttribute(name="debug")
    private Boolean m_debug;
    @XmlAttribute(name="mail-folder")
    private String m_mailFolder;
    @XmlAttribute(name="subject-match")
    private String m_subjectMatch;
    @XmlAttribute(name="attempt-interval")
    private Long m_attemptInterval;
    @XmlAttribute(name="delete-all-mail")
    private Boolean m_deleteAllMail;
    @XmlElement(name="javamail-property")
    private List<JavamailProperty> m_javamailProperties = new ArrayList<JavamailProperty>();
    @XmlElement(name="readmail-host", required=true)
    private ReadmailHost m_readmailHost;
    @XmlElement(name="user-auth", required=true)
    private UserAuth m_userAuth;

    public ReadmailTest() {
        this.setMailFolder("INBOX");
    }

    public void addJavamailProperty(JavamailProperty javamailProperty) throws IndexOutOfBoundsException {
        this.m_javamailProperties.add(javamailProperty);
    }

    public void addJavamailProperty(int index, JavamailProperty javamailProperty) throws IndexOutOfBoundsException {
        this.m_javamailProperties.add(index, javamailProperty);
    }

    public void deleteAttemptInterval() {
        this.m_attemptInterval = null;
    }

    public void deleteDebug() {
        this.m_debug = null;
    }

    public void deleteDeleteAllMail() {
        this.m_deleteAllMail = null;
    }

    public Enumeration<JavamailProperty> enumerateJavamailProperty() {
        return Collections.enumeration(this.m_javamailProperties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ReadmailTest) {
            ReadmailTest temp = (ReadmailTest)obj;
            if (this.m_debug != null) {
                if (temp.m_debug == null) {
                    return false;
                }
                if (!this.m_debug.equals(temp.m_debug)) {
                    return false;
                }
            } else if (temp.m_debug != null) {
                return false;
            }
            if (this.m_mailFolder != null) {
                if (temp.m_mailFolder == null) {
                    return false;
                }
                if (!this.m_mailFolder.equals(temp.m_mailFolder)) {
                    return false;
                }
            } else if (temp.m_mailFolder != null) {
                return false;
            }
            if (this.m_subjectMatch != null) {
                if (temp.m_subjectMatch == null) {
                    return false;
                }
                if (!this.m_subjectMatch.equals(temp.m_subjectMatch)) {
                    return false;
                }
            } else if (temp.m_subjectMatch != null) {
                return false;
            }
            if (this.m_attemptInterval != null) {
                if (temp.m_attemptInterval == null) {
                    return false;
                }
                if (!this.m_attemptInterval.equals(temp.m_attemptInterval)) {
                    return false;
                }
            } else if (temp.m_attemptInterval != null) {
                return false;
            }
            if (this.m_deleteAllMail != null) {
                if (temp.m_deleteAllMail == null) {
                    return false;
                }
                if (!this.m_deleteAllMail.equals(temp.m_deleteAllMail)) {
                    return false;
                }
            } else if (temp.m_deleteAllMail != null) {
                return false;
            }
            if (this.m_javamailProperties != null) {
                if (temp.m_javamailProperties == null) {
                    return false;
                }
                if (!((Object)this.m_javamailProperties).equals(temp.m_javamailProperties)) {
                    return false;
                }
            } else if (temp.m_javamailProperties != null) {
                return false;
            }
            if (this.m_readmailHost != null) {
                if (temp.m_readmailHost == null) {
                    return false;
                }
                if (!this.m_readmailHost.equals(temp.m_readmailHost)) {
                    return false;
                }
            } else if (temp.m_readmailHost != null) {
                return false;
            }
            if (this.m_userAuth != null) {
                if (temp.m_userAuth == null) {
                    return false;
                }
                if (!this.m_userAuth.equals(temp.m_userAuth)) {
                    return false;
                }
            } else if (temp.m_userAuth != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Long getAttemptInterval() {
        return this.m_attemptInterval == null ? 1000L : this.m_attemptInterval;
    }

    public Boolean getDebug() {
        return this.m_debug == null ? true : this.m_debug;
    }

    public Boolean getDeleteAllMail() {
        return this.m_deleteAllMail == null ? false : this.m_deleteAllMail;
    }

    public JavamailProperty getJavamailProperty(int index) throws IndexOutOfBoundsException {
        return this.m_javamailProperties.get(index);
    }

    public JavamailProperty[] getJavamailProperty() {
        return this.m_javamailProperties.toArray(EMPTY_LIST_OF_JAVAMAIL_PROPERTIES);
    }

    public List<JavamailProperty> getJavamailPropertyCollection() {
        return new ArrayList<JavamailProperty>(this.m_javamailProperties);
    }

    public int getJavamailPropertyCount() {
        return this.m_javamailProperties.size();
    }

    public String getMailFolder() {
        return this.m_mailFolder == null ? "INBOX" : this.m_mailFolder;
    }

    public ReadmailHost getReadmailHost() {
        return this.m_readmailHost;
    }

    public String getSubjectMatch() {
        return this.m_subjectMatch;
    }

    public UserAuth getUserAuth() {
        return this.m_userAuth;
    }

    public boolean hasAttemptInterval() {
        return this.m_attemptInterval != null;
    }

    public boolean hasDebug() {
        return this.m_debug != null;
    }

    public boolean hasDeleteAllMail() {
        return this.m_deleteAllMail != null;
    }

    public int hashCode() {
        int result = 17;
        if (this.m_debug != null) {
            result = 37 * result + this.m_debug.hashCode();
        }
        if (this.m_mailFolder != null) {
            result = 37 * result + this.m_mailFolder.hashCode();
        }
        if (this.m_subjectMatch != null) {
            result = 37 * result + this.m_subjectMatch.hashCode();
        }
        if (this.m_attemptInterval != null) {
            result = 37 * result + this.m_attemptInterval.hashCode();
        }
        if (this.m_deleteAllMail != null) {
            result = 37 * result + this.m_deleteAllMail.hashCode();
        }
        if (this.m_javamailProperties != null) {
            result = 37 * result + ((Object)this.m_javamailProperties).hashCode();
        }
        if (this.m_readmailHost != null) {
            result = 37 * result + this.m_readmailHost.hashCode();
        }
        if (this.m_userAuth != null) {
            result = 37 * result + this.m_userAuth.hashCode();
        }
        return result;
    }

    public boolean isDebug() {
        return this.m_debug == null ? true : this.m_debug;
    }

    public boolean isDeleteAllMail() {
        return this.m_deleteAllMail == null ? false : this.m_deleteAllMail;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<JavamailProperty> iterateJavamailProperty() {
        return this.m_javamailProperties.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllJavamailProperty() {
        this.m_javamailProperties.clear();
    }

    public boolean removeJavamailProperty(JavamailProperty javamailProperty) {
        return this.m_javamailProperties.remove(javamailProperty);
    }

    public JavamailProperty removeJavamailPropertyAt(int index) {
        return this.m_javamailProperties.remove(index);
    }

    public void setAttemptInterval(Long attemptInterval) {
        this.m_attemptInterval = attemptInterval;
    }

    public void setDebug(Boolean debug) {
        this.m_debug = debug;
    }

    public void setDeleteAllMail(Boolean deleteAllMail) {
        this.m_deleteAllMail = deleteAllMail;
    }

    public void setJavamailProperty(int index, JavamailProperty javamailProperty) throws IndexOutOfBoundsException {
        this.m_javamailProperties.set(index, javamailProperty);
    }

    public void setJavamailProperty(JavamailProperty[] javamailProperties) {
        this.m_javamailProperties.clear();
        for (JavamailProperty prop : javamailProperties) {
            this.m_javamailProperties.add(prop);
        }
    }

    public void setJavamailProperty(List<JavamailProperty> javamailProperties) {
        if (javamailProperties != this.m_javamailProperties) {
            this.m_javamailProperties.clear();
            this.m_javamailProperties.addAll(javamailProperties);
        }
    }

    public void setJavamailPropertyCollection(List<JavamailProperty> javamailProperties) {
        this.m_javamailProperties = new ArrayList<JavamailProperty>(javamailProperties);
    }

    public void setMailFolder(String mailFolder) {
        this.m_mailFolder = mailFolder;
    }

    public void setReadmailHost(ReadmailHost readmailHost) {
        this.m_readmailHost = readmailHost;
    }

    public void setSubjectMatch(String subjectMatch) {
        this.m_subjectMatch = subjectMatch;
    }

    public void setUserAuth(UserAuth userAuth) {
        this.m_userAuth = userAuth;
    }

    public static ReadmailTest unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (ReadmailTest)Unmarshaller.unmarshal(ReadmailTest.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        new Validator().validate((Object)this);
    }
}

