/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.filter;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.filter.Alias;
import org.opennms.netmgt.config.filter.Constraint;
import org.xml.sax.ContentHandler;

public class Column
implements Serializable {
    private String _name;
    private String _sqlType;
    private String _javaType;
    private String _visible = "true";
    private List<Alias> _aliasList;
    private List<Constraint> _constraintList;

    public Column() {
        this.setVisible("true");
        this._aliasList = new ArrayList<Alias>();
        this._constraintList = new ArrayList<Constraint>();
    }

    public void addAlias(Alias vAlias) throws IndexOutOfBoundsException {
        this._aliasList.add(vAlias);
    }

    public void addAlias(int index, Alias vAlias) throws IndexOutOfBoundsException {
        this._aliasList.add(index, vAlias);
    }

    public void addConstraint(Constraint vConstraint) throws IndexOutOfBoundsException {
        this._constraintList.add(vConstraint);
    }

    public void addConstraint(int index, Constraint vConstraint) throws IndexOutOfBoundsException {
        this._constraintList.add(index, vConstraint);
    }

    public Enumeration<Alias> enumerateAlias() {
        return Collections.enumeration(this._aliasList);
    }

    public Enumeration<Constraint> enumerateConstraint() {
        return Collections.enumeration(this._constraintList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Column) {
            Column temp = (Column)obj;
            if (this._name != null) {
                if (temp._name == null) {
                    return false;
                }
                if (!this._name.equals(temp._name)) {
                    return false;
                }
            } else if (temp._name != null) {
                return false;
            }
            if (this._sqlType != null) {
                if (temp._sqlType == null) {
                    return false;
                }
                if (!this._sqlType.equals(temp._sqlType)) {
                    return false;
                }
            } else if (temp._sqlType != null) {
                return false;
            }
            if (this._javaType != null) {
                if (temp._javaType == null) {
                    return false;
                }
                if (!this._javaType.equals(temp._javaType)) {
                    return false;
                }
            } else if (temp._javaType != null) {
                return false;
            }
            if (this._visible != null) {
                if (temp._visible == null) {
                    return false;
                }
                if (!this._visible.equals(temp._visible)) {
                    return false;
                }
            } else if (temp._visible != null) {
                return false;
            }
            if (this._aliasList != null) {
                if (temp._aliasList == null) {
                    return false;
                }
                if (!((Object)this._aliasList).equals(temp._aliasList)) {
                    return false;
                }
            } else if (temp._aliasList != null) {
                return false;
            }
            if (this._constraintList != null) {
                if (temp._constraintList == null) {
                    return false;
                }
                if (!((Object)this._constraintList).equals(temp._constraintList)) {
                    return false;
                }
            } else if (temp._constraintList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Alias getAlias(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._aliasList.size()) {
            throw new IndexOutOfBoundsException("getAlias: Index value '" + index + "' not in range [0.." + (this._aliasList.size() - 1) + "]");
        }
        return this._aliasList.get(index);
    }

    public Alias[] getAlias() {
        Alias[] array = new Alias[]{};
        return this._aliasList.toArray(array);
    }

    public List<Alias> getAliasCollection() {
        return this._aliasList;
    }

    public int getAliasCount() {
        return this._aliasList.size();
    }

    public Constraint getConstraint(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._constraintList.size()) {
            throw new IndexOutOfBoundsException("getConstraint: Index value '" + index + "' not in range [0.." + (this._constraintList.size() - 1) + "]");
        }
        return this._constraintList.get(index);
    }

    public Constraint[] getConstraint() {
        Constraint[] array = new Constraint[]{};
        return this._constraintList.toArray(array);
    }

    public List<Constraint> getConstraintCollection() {
        return this._constraintList;
    }

    public int getConstraintCount() {
        return this._constraintList.size();
    }

    public String getJavaType() {
        return this._javaType;
    }

    public String getName() {
        return this._name;
    }

    public String getSqlType() {
        return this._sqlType;
    }

    public String getVisible() {
        return this._visible;
    }

    public int hashCode() {
        int result = 17;
        if (this._name != null) {
            result = 37 * result + this._name.hashCode();
        }
        if (this._sqlType != null) {
            result = 37 * result + this._sqlType.hashCode();
        }
        if (this._javaType != null) {
            result = 37 * result + this._javaType.hashCode();
        }
        if (this._visible != null) {
            result = 37 * result + this._visible.hashCode();
        }
        if (this._aliasList != null) {
            result = 37 * result + ((Object)this._aliasList).hashCode();
        }
        if (this._constraintList != null) {
            result = 37 * result + ((Object)this._constraintList).hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Alias> iterateAlias() {
        return this._aliasList.iterator();
    }

    public Iterator<Constraint> iterateConstraint() {
        return this._constraintList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeAlias(Alias vAlias) {
        boolean removed = this._aliasList.remove(vAlias);
        return removed;
    }

    public Alias removeAliasAt(int index) {
        Alias obj = this._aliasList.remove(index);
        return obj;
    }

    public void removeAllAlias() {
        this._aliasList.clear();
    }

    public void removeAllConstraint() {
        this._constraintList.clear();
    }

    public boolean removeConstraint(Constraint vConstraint) {
        boolean removed = this._constraintList.remove(vConstraint);
        return removed;
    }

    public Constraint removeConstraintAt(int index) {
        Constraint obj = this._constraintList.remove(index);
        return obj;
    }

    public void setAlias(int index, Alias vAlias) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._aliasList.size()) {
            throw new IndexOutOfBoundsException("setAlias: Index value '" + index + "' not in range [0.." + (this._aliasList.size() - 1) + "]");
        }
        this._aliasList.set(index, vAlias);
    }

    public void setAlias(Alias[] vAliasArray) {
        this._aliasList.clear();
        for (int i = 0; i < vAliasArray.length; ++i) {
            this._aliasList.add(vAliasArray[i]);
        }
    }

    public void setAlias(List<Alias> vAliasList) {
        this._aliasList.clear();
        this._aliasList.addAll(vAliasList);
    }

    public void setAliasCollection(List<Alias> aliasList) {
        this._aliasList = aliasList;
    }

    public void setConstraint(int index, Constraint vConstraint) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._constraintList.size()) {
            throw new IndexOutOfBoundsException("setConstraint: Index value '" + index + "' not in range [0.." + (this._constraintList.size() - 1) + "]");
        }
        this._constraintList.set(index, vConstraint);
    }

    public void setConstraint(Constraint[] vConstraintArray) {
        this._constraintList.clear();
        for (int i = 0; i < vConstraintArray.length; ++i) {
            this._constraintList.add(vConstraintArray[i]);
        }
    }

    public void setConstraint(List<Constraint> vConstraintList) {
        this._constraintList.clear();
        this._constraintList.addAll(vConstraintList);
    }

    public void setConstraintCollection(List<Constraint> constraintList) {
        this._constraintList = constraintList;
    }

    public void setJavaType(String javaType) {
        this._javaType = javaType;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setSqlType(String sqlType) {
        this._sqlType = sqlType;
    }

    public void setVisible(String visible) {
        this._visible = visible;
    }

    public static Column unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Column)Unmarshaller.unmarshal(Column.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

