/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.datacollection;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.datacollection.Parameter;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="persistenceSelectorStrategy", namespace="http://xmlns.opennms.org/xsd/config/datacollection")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="datacollection-config.xsd")
public class PersistenceSelectorStrategy
implements Serializable {
    private static final long serialVersionUID = 7515948989309298051L;
    private static final Parameter[] EMPTY_PARAMETER_ARRAY = new Parameter[0];
    private String m_clazz;
    private List<Parameter> m_parameters = new ArrayList<Parameter>();

    public PersistenceSelectorStrategy() {
    }

    public PersistenceSelectorStrategy(String clazz) {
        if (clazz != null) {
            this.m_clazz = clazz.intern();
        }
    }

    public void addParameter(Parameter parameter) throws IndexOutOfBoundsException {
        this.m_parameters.add(parameter);
    }

    public void addParameter(int index, Parameter parameter) throws IndexOutOfBoundsException {
        this.m_parameters.add(index, parameter);
    }

    public Enumeration<Parameter> enumerateParameter() {
        return Collections.enumeration(this.m_parameters);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PersistenceSelectorStrategy) {
            PersistenceSelectorStrategy temp = (PersistenceSelectorStrategy)obj;
            if (this.m_clazz != null) {
                if (temp.m_clazz == null) {
                    return false;
                }
                if (!this.m_clazz.equals(temp.m_clazz)) {
                    return false;
                }
            } else if (temp.m_clazz != null) {
                return false;
            }
            if (this.m_parameters != null) {
                if (temp.m_parameters == null) {
                    return false;
                }
                if (!((Object)this.m_parameters).equals(temp.m_parameters)) {
                    return false;
                }
            } else if (temp.m_parameters != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    @XmlAttribute(name="class")
    public String getClazz() {
        return this.m_clazz;
    }

    public Parameter getParameter(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_parameters.size()) {
            throw new IndexOutOfBoundsException("getParameter: Index value '" + index + "' not in range [0.." + (this.m_parameters.size() - 1) + "]");
        }
        return this.m_parameters.get(index);
    }

    @XmlElement(name="parameter")
    public Parameter[] getParameter() {
        return this.m_parameters.toArray(EMPTY_PARAMETER_ARRAY);
    }

    public List<Parameter> getParameterCollection() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.size();
    }

    public int hashCode() {
        int result = 17;
        if (this.m_clazz != null) {
            result = 37 * result + this.m_clazz.hashCode();
        }
        if (this.m_parameters != null) {
            result = 37 * result + ((Object)this.m_parameters).hashCode();
        }
        return result;
    }

    @Deprecated
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Parameter> iterateParameter() {
        return this.m_parameters.iterator();
    }

    @Deprecated
    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    @Deprecated
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllParameter() {
        this.m_parameters.clear();
    }

    public boolean removeParameter(Parameter parameter) {
        return this.m_parameters.remove(parameter);
    }

    public Parameter removeParameterAt(int index) {
        return this.m_parameters.remove(index);
    }

    public void setClazz(String clazz) {
        this.m_clazz = clazz.intern();
    }

    public void setParameter(int index, Parameter parameter) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_parameters.size()) {
            throw new IndexOutOfBoundsException("setParameter: Index value '" + index + "' not in range [0.." + (this.m_parameters.size() - 1) + "]");
        }
        this.m_parameters.set(index, parameter);
    }

    public void setParameter(Parameter[] parameters) {
        this.m_parameters.clear();
        for (int i = 0; i < parameters.length; ++i) {
            this.m_parameters.add(parameters[i]);
        }
    }

    public void setParameter(List<Parameter> parameters) {
        if (this.m_parameters == parameters) {
            return;
        }
        this.m_parameters.clear();
        this.m_parameters.addAll(parameters);
    }

    public void setParameterCollection(List<Parameter> parameters) {
        this.m_parameters = parameters;
    }

    @Deprecated
    public static PersistenceSelectorStrategy unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (PersistenceSelectorStrategy)Unmarshaller.unmarshal(PersistenceSelectorStrategy.class, (Reader)reader);
    }

    @Deprecated
    public void validate() throws ValidationException {
        new Validator().validate((Object)this);
    }
}

