/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.datacollection;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.datacollection.MibObj;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="group", namespace="http://xmlns.opennms.org/xsd/config/datacollection")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(propOrder={"name", "ifType", "mibObj", "includeGroup"})
@ValidateUsing(value="datacollection-config.xsd")
public class Group
implements Serializable {
    private static final long serialVersionUID = 8424897884942605338L;
    private static final MibObj[] EMPTY_MIBOBJ_ARRAY = new MibObj[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private String m_name;
    private String m_ifType;
    private List<MibObj> m_mibObjects = new ArrayList<MibObj>();
    private List<String> m_includeGroups = new ArrayList<String>();

    public Group() {
    }

    public Group(String name) {
        this.m_name = name;
    }

    public void addIncludeGroup(String includeGroup) throws IndexOutOfBoundsException {
        this.m_includeGroups.add(includeGroup);
    }

    public void addIncludeGroup(int index, String includeGroup) throws IndexOutOfBoundsException {
        this.m_includeGroups.add(index, includeGroup.intern());
    }

    public void addMibObj(MibObj mibObj) throws IndexOutOfBoundsException {
        this.m_mibObjects.add(mibObj);
    }

    public void addMibObj(int index, MibObj mibObj) throws IndexOutOfBoundsException {
        this.m_mibObjects.add(index, mibObj);
    }

    public Enumeration<String> enumerateIncludeGroup() {
        return Collections.enumeration(this.m_includeGroups);
    }

    public Enumeration<MibObj> enumerateMibObj() {
        return Collections.enumeration(this.m_mibObjects);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Group) {
            Group temp = (Group)obj;
            if (this.m_name != null) {
                if (temp.m_name == null) {
                    return false;
                }
                if (!this.m_name.equals(temp.m_name)) {
                    return false;
                }
            } else if (temp.m_name != null) {
                return false;
            }
            if (this.m_ifType != null) {
                if (temp.m_ifType == null) {
                    return false;
                }
                if (!this.m_ifType.equals(temp.m_ifType)) {
                    return false;
                }
            } else if (temp.m_ifType != null) {
                return false;
            }
            if (this.m_mibObjects != null) {
                if (temp.m_mibObjects == null) {
                    return false;
                }
                if (!((Object)this.m_mibObjects).equals(temp.m_mibObjects)) {
                    return false;
                }
            } else if (temp.m_mibObjects != null) {
                return false;
            }
            if (this.m_includeGroups != null) {
                if (temp.m_includeGroups == null) {
                    return false;
                }
                if (!((Object)this.m_includeGroups).equals(temp.m_includeGroups)) {
                    return false;
                }
            } else if (temp.m_includeGroups != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    @XmlAttribute(name="ifType", required=true)
    public String getIfType() {
        return this.m_ifType;
    }

    public String getIncludeGroup(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_includeGroups.size()) {
            throw new IndexOutOfBoundsException("getIncludeGroup: Index value '" + index + "' not in range [0.." + (this.m_includeGroups.size() - 1) + "]");
        }
        return this.m_includeGroups.get(index);
    }

    @XmlElement(name="includeGroup")
    public String[] getIncludeGroup() {
        return this.m_includeGroups.toArray(EMPTY_STRING_ARRAY);
    }

    public List<String> getIncludeGroupCollection() {
        return this.m_includeGroups;
    }

    public int getIncludeGroupCount() {
        return this.m_includeGroups.size();
    }

    public MibObj getMibObj(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_mibObjects.size()) {
            throw new IndexOutOfBoundsException("getMibObj: Index value '" + index + "' not in range [0.." + (this.m_mibObjects.size() - 1) + "]");
        }
        return this.m_mibObjects.get(index);
    }

    @XmlElement(name="mibObj")
    public MibObj[] getMibObj() {
        return this.m_mibObjects.toArray(EMPTY_MIBOBJ_ARRAY);
    }

    public List<MibObj> getMibObjCollection() {
        return this.m_mibObjects;
    }

    public int getMibObjCount() {
        return this.m_mibObjects.size();
    }

    @XmlAttribute(name="name", required=true)
    public String getName() {
        return this.m_name;
    }

    public int hashCode() {
        int result = 17;
        if (this.m_name != null) {
            result = 37 * result + this.m_name.hashCode();
        }
        if (this.m_ifType != null) {
            result = 37 * result + this.m_ifType.hashCode();
        }
        if (this.m_mibObjects != null) {
            result = 37 * result + ((Object)this.m_mibObjects).hashCode();
        }
        if (this.m_includeGroups != null) {
            result = 37 * result + ((Object)this.m_includeGroups).hashCode();
        }
        return result;
    }

    @Deprecated
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<String> iterateIncludeGroup() {
        return this.m_includeGroups.iterator();
    }

    public Iterator<MibObj> iterateMibObj() {
        return this.m_mibObjects.iterator();
    }

    @Deprecated
    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    @Deprecated
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllIncludeGroup() {
        this.m_includeGroups.clear();
    }

    public void removeAllMibObj() {
        this.m_mibObjects.clear();
    }

    public boolean removeIncludeGroup(String includeGroup) {
        return this.m_includeGroups.remove(includeGroup);
    }

    public String removeIncludeGroupAt(int index) {
        return this.m_includeGroups.remove(index);
    }

    public boolean removeMibObj(MibObj mibObj) {
        return this.m_mibObjects.remove(mibObj);
    }

    public MibObj removeMibObjAt(int index) {
        return this.m_mibObjects.remove(index);
    }

    public void setIfType(String ifType) {
        this.m_ifType = ifType.intern();
    }

    public void setIncludeGroup(int index, String includeGroup) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_includeGroups.size()) {
            throw new IndexOutOfBoundsException("setIncludeGroup: Index value '" + index + "' not in range [0.." + (this.m_includeGroups.size() - 1) + "]");
        }
        this.m_includeGroups.set(index, includeGroup.intern());
    }

    public void setIncludeGroup(String[] includeGroups) {
        this.m_includeGroups.clear();
        for (int i = 0; i < includeGroups.length; ++i) {
            this.m_includeGroups.add(includeGroups[i].intern());
        }
    }

    public void setIncludeGroup(List<String> includeGroups) {
        if (this.m_includeGroups == includeGroups) {
            return;
        }
        this.m_includeGroups.clear();
        this.m_includeGroups.addAll(includeGroups);
    }

    public void setIncludeGroupCollection(List<String> includeGroups) {
        for (int i = 0; i < includeGroups.size(); ++i) {
            includeGroups.set(i, includeGroups.get(i).intern());
        }
        this.m_includeGroups = includeGroups;
    }

    public void setMibObj(int index, MibObj mibObj) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_mibObjects.size()) {
            throw new IndexOutOfBoundsException("setMibObj: Index value '" + index + "' not in range [0.." + (this.m_mibObjects.size() - 1) + "]");
        }
        this.m_mibObjects.set(index, mibObj);
    }

    public void setMibObj(MibObj[] mibObjs) {
        this.m_mibObjects.clear();
        for (int i = 0; i < mibObjs.length; ++i) {
            this.m_mibObjects.add(mibObjs[i]);
        }
    }

    public void setMibObj(List<MibObj> mibObjs) {
        if (this.m_mibObjects == mibObjs) {
            return;
        }
        this.m_mibObjects.clear();
        this.m_mibObjects.addAll(mibObjs);
    }

    public void setMibObjCollection(List<MibObj> mibObjs) {
        this.m_mibObjects = mibObjs;
    }

    public void setName(String name) {
        this.m_name = name.intern();
    }

    @Deprecated
    public static Group unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Group)Unmarshaller.unmarshal(Group.class, (Reader)reader);
    }

    @Deprecated
    public void validate() throws ValidationException {
        new Validator().validate((Object)this);
    }
}

