/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xml.eventconf;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Global;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="events")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="eventconf.xsd")
@XmlType(propOrder={})
public class Events
implements Serializable {
    private static final long serialVersionUID = -49037181336311348L;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Event[] EMPTY_EVENT_ARRAY = new Event[0];
    @XmlElement(name="global", required=false)
    private Global m_global;
    @XmlElement(name="event", required=true)
    private List<Event> m_events = new ArrayList<Event>();
    @XmlElement(name="event-file", required=false)
    private List<String> m_eventFiles = new ArrayList<String>();

    public void addEvent(Event event) throws IndexOutOfBoundsException {
        this.m_events.add(event);
    }

    public void addEvent(int index, Event event) throws IndexOutOfBoundsException {
        this.m_events.add(index, event);
    }

    public void addEventFile(String eventFile) throws IndexOutOfBoundsException {
        this.m_eventFiles.add(eventFile.intern());
    }

    public void addEventFile(int index, String eventFile) throws IndexOutOfBoundsException {
        this.m_eventFiles.add(index, eventFile.intern());
    }

    public Enumeration<Event> enumerateEvent() {
        return Collections.enumeration(this.m_events);
    }

    public Enumeration<String> enumerateEventFile() {
        return Collections.enumeration(this.m_eventFiles);
    }

    public Event getEvent(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_events.size()) {
            throw new IndexOutOfBoundsException("getEvent: Index value '" + index + "' not in range [0.." + (this.m_events.size() - 1) + "]");
        }
        return this.m_events.get(index);
    }

    public Event[] getEvent() {
        return this.m_events.toArray(EMPTY_EVENT_ARRAY);
    }

    public List<Event> getEventCollection() {
        return this.m_events;
    }

    public int getEventCount() {
        return this.m_events.size();
    }

    public String getEventFile(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_eventFiles.size()) {
            throw new IndexOutOfBoundsException("getEventFile: Index value '" + index + "' not in range [0.." + (this.m_eventFiles.size() - 1) + "]");
        }
        return this.m_eventFiles.get(index);
    }

    public String[] getEventFile() {
        return this.m_eventFiles.toArray(EMPTY_STRING_ARRAY);
    }

    public List<String> getEventFileCollection() {
        return this.m_eventFiles;
    }

    public int getEventFileCount() {
        return this.m_eventFiles.size();
    }

    public Global getGlobal() {
        return this.m_global;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Event> iterateEvent() {
        return this.m_events.iterator();
    }

    public Iterator<String> iterateEventFile() {
        return this.m_eventFiles.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllEvent() {
        this.m_events.clear();
    }

    public void removeAllEventFile() {
        this.m_eventFiles.clear();
    }

    public boolean removeEvent(Event event) {
        return this.m_events.remove(event);
    }

    public Event removeEventAt(int index) {
        return this.m_events.remove(index);
    }

    public boolean removeEventFile(String eventFile) {
        return this.m_eventFiles.remove(eventFile);
    }

    public String removeEventFileAt(int index) {
        return this.m_eventFiles.remove(index);
    }

    public void setEvent(int index, Event event) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_events.size()) {
            throw new IndexOutOfBoundsException("setEvent: Index value '" + index + "' not in range [0.." + (this.m_events.size() - 1) + "]");
        }
        this.m_events.set(index, event);
    }

    public void setEvent(Event[] events) {
        this.m_events.clear();
        for (Event event : events) {
            this.m_events.add(event);
        }
    }

    public void setEvent(List<Event> events) {
        this.m_events.clear();
        this.m_events.addAll(events);
    }

    public void setEventCollection(List<Event> events) {
        this.m_events = events;
    }

    public void setEventFile(int index, String eventFile) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_eventFiles.size()) {
            throw new IndexOutOfBoundsException("setEventFile: Index value '" + index + "' not in range [0.." + (this.m_eventFiles.size() - 1) + "]");
        }
        this.m_eventFiles.set(index, eventFile.intern());
    }

    public void setEventFile(String[] eventFiles) {
        this.m_eventFiles.clear();
        for (String eventFile : eventFiles) {
            this.m_eventFiles.add(eventFile.intern());
        }
    }

    public void setEventFile(List<String> eventFiles) {
        this.m_eventFiles.clear();
        for (String eventFile : eventFiles) {
            this.m_eventFiles.add(eventFile.intern());
        }
    }

    public void setEventFileCollection(List<String> eventFiles) {
        this.setEventFile(eventFiles);
    }

    public void setGlobal(Global global) {
        this.m_global = global;
    }

    public static Events unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Events)Unmarshaller.unmarshal(Events.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        new Validator().validate((Object)this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_eventFiles == null ? 0 : ((Object)this.m_eventFiles).hashCode());
        result = 31 * result + (this.m_events == null ? 0 : ((Object)this.m_events).hashCode());
        result = 31 * result + (this.m_global == null ? 0 : this.m_global.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Events)) {
            return false;
        }
        Events other = (Events)obj;
        if (this.m_eventFiles == null ? other.m_eventFiles != null : !((Object)this.m_eventFiles).equals(other.m_eventFiles)) {
            return false;
        }
        if (this.m_events == null ? other.m_events != null : !((Object)this.m_events).equals(other.m_events)) {
            return false;
        }
        return !(this.m_global == null ? other.m_global != null : !this.m_global.equals(other.m_global));
    }
}

