/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.trapd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.trapd.Snmpv3User;
import org.xml.sax.ContentHandler;

public class TrapdConfiguration
implements Serializable {
    private String _snmpTrapAddress = "*";
    private int _snmpTrapPort;
    private boolean _has_snmpTrapPort;
    private boolean _newSuspectOnTrap;
    private boolean _has_newSuspectOnTrap;
    private List<Snmpv3User> _snmpv3UserList;

    public TrapdConfiguration() {
        this.setSnmpTrapAddress("*");
        this._snmpv3UserList = new ArrayList<Snmpv3User>();
    }

    public void addSnmpv3User(Snmpv3User vSnmpv3User) throws IndexOutOfBoundsException {
        this._snmpv3UserList.add(vSnmpv3User);
    }

    public void addSnmpv3User(int index, Snmpv3User vSnmpv3User) throws IndexOutOfBoundsException {
        this._snmpv3UserList.add(index, vSnmpv3User);
    }

    public void deleteNewSuspectOnTrap() {
        this._has_newSuspectOnTrap = false;
    }

    public void deleteSnmpTrapPort() {
        this._has_snmpTrapPort = false;
    }

    public Enumeration<Snmpv3User> enumerateSnmpv3User() {
        return Collections.enumeration(this._snmpv3UserList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TrapdConfiguration) {
            TrapdConfiguration temp = (TrapdConfiguration)obj;
            if (this._snmpTrapAddress != null) {
                if (temp._snmpTrapAddress == null) {
                    return false;
                }
                if (!this._snmpTrapAddress.equals(temp._snmpTrapAddress)) {
                    return false;
                }
            } else if (temp._snmpTrapAddress != null) {
                return false;
            }
            if (this._snmpTrapPort != temp._snmpTrapPort) {
                return false;
            }
            if (this._has_snmpTrapPort != temp._has_snmpTrapPort) {
                return false;
            }
            if (this._newSuspectOnTrap != temp._newSuspectOnTrap) {
                return false;
            }
            if (this._has_newSuspectOnTrap != temp._has_newSuspectOnTrap) {
                return false;
            }
            if (this._snmpv3UserList != null) {
                if (temp._snmpv3UserList == null) {
                    return false;
                }
                if (!((Object)this._snmpv3UserList).equals(temp._snmpv3UserList)) {
                    return false;
                }
            } else if (temp._snmpv3UserList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean getNewSuspectOnTrap() {
        return this._newSuspectOnTrap;
    }

    public String getSnmpTrapAddress() {
        return this._snmpTrapAddress;
    }

    public int getSnmpTrapPort() {
        return this._snmpTrapPort;
    }

    public Snmpv3User getSnmpv3User(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._snmpv3UserList.size()) {
            throw new IndexOutOfBoundsException("getSnmpv3User: Index value '" + index + "' not in range [0.." + (this._snmpv3UserList.size() - 1) + "]");
        }
        return this._snmpv3UserList.get(index);
    }

    public Snmpv3User[] getSnmpv3User() {
        Snmpv3User[] array = new Snmpv3User[]{};
        return this._snmpv3UserList.toArray(array);
    }

    public List<Snmpv3User> getSnmpv3UserCollection() {
        return this._snmpv3UserList;
    }

    public int getSnmpv3UserCount() {
        return this._snmpv3UserList.size();
    }

    public boolean hasNewSuspectOnTrap() {
        return this._has_newSuspectOnTrap;
    }

    public boolean hasSnmpTrapPort() {
        return this._has_snmpTrapPort;
    }

    public int hashCode() {
        int result = 17;
        if (this._snmpTrapAddress != null) {
            result = 37 * result + this._snmpTrapAddress.hashCode();
        }
        result = 37 * result + this._snmpTrapPort;
        result = 37 * result + (this._newSuspectOnTrap ? 0 : 1);
        if (this._snmpv3UserList != null) {
            result = 37 * result + ((Object)this._snmpv3UserList).hashCode();
        }
        return result;
    }

    public boolean isNewSuspectOnTrap() {
        return this._newSuspectOnTrap;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Snmpv3User> iterateSnmpv3User() {
        return this._snmpv3UserList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllSnmpv3User() {
        this._snmpv3UserList.clear();
    }

    public boolean removeSnmpv3User(Snmpv3User vSnmpv3User) {
        boolean removed = this._snmpv3UserList.remove(vSnmpv3User);
        return removed;
    }

    public Snmpv3User removeSnmpv3UserAt(int index) {
        Snmpv3User obj = this._snmpv3UserList.remove(index);
        return obj;
    }

    public void setNewSuspectOnTrap(boolean newSuspectOnTrap) {
        this._newSuspectOnTrap = newSuspectOnTrap;
        this._has_newSuspectOnTrap = true;
    }

    public void setSnmpTrapAddress(String snmpTrapAddress) {
        this._snmpTrapAddress = snmpTrapAddress;
    }

    public void setSnmpTrapPort(int snmpTrapPort) {
        this._snmpTrapPort = snmpTrapPort;
        this._has_snmpTrapPort = true;
    }

    public void setSnmpv3User(int index, Snmpv3User vSnmpv3User) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._snmpv3UserList.size()) {
            throw new IndexOutOfBoundsException("setSnmpv3User: Index value '" + index + "' not in range [0.." + (this._snmpv3UserList.size() - 1) + "]");
        }
        this._snmpv3UserList.set(index, vSnmpv3User);
    }

    public void setSnmpv3User(Snmpv3User[] vSnmpv3UserArray) {
        this._snmpv3UserList.clear();
        for (int i = 0; i < vSnmpv3UserArray.length; ++i) {
            this._snmpv3UserList.add(vSnmpv3UserArray[i]);
        }
    }

    public void setSnmpv3User(List<Snmpv3User> vSnmpv3UserList) {
        this._snmpv3UserList.clear();
        this._snmpv3UserList.addAll(vSnmpv3UserList);
    }

    public void setSnmpv3UserCollection(List<Snmpv3User> snmpv3UserList) {
        this._snmpv3UserList = snmpv3UserList;
    }

    public static TrapdConfiguration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (TrapdConfiguration)Unmarshaller.unmarshal(TrapdConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

