/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.snmp;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.snmp.Configuration;
import org.opennms.netmgt.config.snmp.Definition;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="snmp-config")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SnmpConfig
extends Configuration
implements Serializable {
    private static final long serialVersionUID = 3139857316489386441L;
    private static final Definition[] EMPTY_DEFINITION = new Definition[0];
    @XmlElement(name="definition")
    private List<Definition> _definitionList = new ArrayList<Definition>();

    public SnmpConfig() {
    }

    public SnmpConfig(Integer port, Integer retry, Integer timeout, String readCommunity, String writeCommunity, String proxyHost, String version, Integer maxVarsPerPdu, Integer maxRepetitions, Integer maxRequestSize, String securityName, Integer securityLevel, String authPassphrase, String authProtocol, String engineId, String contextEngineId, String contextName, String privacyPassphrase, String privacyProtocol, String enterpriseId, List<Definition> definitionList) {
        super(port, retry, timeout, readCommunity, writeCommunity, proxyHost, version, maxVarsPerPdu, maxRepetitions, maxRequestSize, securityName, securityLevel, authPassphrase, authProtocol, engineId, contextEngineId, contextName, privacyPassphrase, privacyProtocol, enterpriseId);
        this.setDefinition(definitionList);
    }

    public void addDefinition(Definition vDefinition) throws IndexOutOfBoundsException {
        this._definitionList.add(vDefinition);
    }

    public void addDefinition(int index, Definition vDefinition) throws IndexOutOfBoundsException {
        this._definitionList.add(index, vDefinition);
    }

    public Enumeration<Definition> enumerateDefinition() {
        return Collections.enumeration(this._definitionList);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Configuration)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        SnmpConfig temp = (SnmpConfig)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.getDefinitionCollection(), temp.getDefinitionCollection()).isEquals();
    }

    public Definition getDefinition(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._definitionList.size()) {
            throw new IndexOutOfBoundsException("getDefinition: Index value '" + index + "' not in range [0.." + (this._definitionList.size() - 1) + "]");
        }
        return this._definitionList.get(index);
    }

    public Definition[] getDefinition() {
        return this._definitionList.toArray(EMPTY_DEFINITION);
    }

    public List<Definition> getDefinitionCollection() {
        return this._definitionList;
    }

    public int getDefinitionCount() {
        return this._definitionList.size();
    }

    @Override
    public int hashCode() {
        int result = 17;
        if (this._definitionList != null) {
            return 629 + ((Object)this._definitionList).hashCode();
        }
        return 17;
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Definition> iterateDefinition() {
        return this._definitionList.iterator();
    }

    @Override
    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    @Override
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllDefinition() {
        this._definitionList.clear();
    }

    public boolean removeDefinition(Definition vDefinition) {
        return this._definitionList.remove(vDefinition);
    }

    public Definition removeDefinitionAt(int index) {
        return this._definitionList.remove(index);
    }

    public void setDefinition(int index, Definition vDefinition) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._definitionList.size()) {
            throw new IndexOutOfBoundsException("setDefinition: Index value '" + index + "' not in range [0.." + (this._definitionList.size() - 1) + "]");
        }
        this._definitionList.set(index, vDefinition);
    }

    public void setDefinition(Definition[] vDefinitionArray) {
        this._definitionList.clear();
        for (int i = 0; i < vDefinitionArray.length; ++i) {
            this._definitionList.add(vDefinitionArray[i]);
        }
    }

    public void setDefinition(List<Definition> vDefinitionList) {
        this._definitionList.clear();
        this._definitionList.addAll(vDefinitionList);
    }

    public void setDefinitionCollection(List<Definition> definitionList) {
        this._definitionList = definitionList;
    }

    public static Configuration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Configuration)Unmarshaller.unmarshal(SnmpConfig.class, (Reader)reader);
    }

    @Override
    public void validate() throws ValidationException {
        new Validator().validate((Object)this);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("definitions", this.getDefinitionCollection()).toString();
    }
}

