/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.datacollection;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.datacollection.SystemDef;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="systems", namespace="http://xmlns.opennms.org/xsd/config/datacollection")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="datacollection-config.xsd")
public class Systems
implements Serializable {
    private static final long serialVersionUID = 1757643773135824946L;
    private static final SystemDef[] EMPTY_SYSTEMDEF_ARRAY = new SystemDef[0];
    private List<SystemDef> m_systemDefs = new ArrayList<SystemDef>();

    public void addSystemDef(SystemDef systemDef) throws IndexOutOfBoundsException {
        this.m_systemDefs.add(systemDef);
    }

    public void addSystemDef(int index, SystemDef systemDef) throws IndexOutOfBoundsException {
        this.m_systemDefs.add(index, systemDef);
    }

    public Enumeration<SystemDef> enumerateSystemDef() {
        return Collections.enumeration(this.m_systemDefs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Systems) {
            Systems temp = (Systems)obj;
            if (this.m_systemDefs != null) {
                if (temp.m_systemDefs == null) {
                    return false;
                }
                if (!((Object)this.m_systemDefs).equals(temp.m_systemDefs)) {
                    return false;
                }
            } else if (temp.m_systemDefs != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public SystemDef getSystemDef(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_systemDefs.size()) {
            throw new IndexOutOfBoundsException("getSystemDef: Index value '" + index + "' not in range [0.." + (this.m_systemDefs.size() - 1) + "]");
        }
        return this.m_systemDefs.get(index);
    }

    @XmlElement(name="systemDef")
    public SystemDef[] getSystemDef() {
        return this.m_systemDefs.toArray(EMPTY_SYSTEMDEF_ARRAY);
    }

    public List<SystemDef> getSystemDefCollection() {
        return this.m_systemDefs;
    }

    public int getSystemDefCount() {
        return this.m_systemDefs.size();
    }

    public int hashCode() {
        int result = 17;
        if (this.m_systemDefs != null) {
            result = 37 * result + ((Object)this.m_systemDefs).hashCode();
        }
        return result;
    }

    @Deprecated
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<SystemDef> iterateSystemDef() {
        return this.m_systemDefs.iterator();
    }

    @Deprecated
    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    @Deprecated
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllSystemDef() {
        this.m_systemDefs.clear();
    }

    public boolean removeSystemDef(SystemDef systemDef) {
        return this.m_systemDefs.remove(systemDef);
    }

    public SystemDef removeSystemDefAt(int index) {
        return this.m_systemDefs.remove(index);
    }

    public void setSystemDef(int index, SystemDef systemDef) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_systemDefs.size()) {
            throw new IndexOutOfBoundsException("setSystemDef: Index value '" + index + "' not in range [0.." + (this.m_systemDefs.size() - 1) + "]");
        }
        this.m_systemDefs.set(index, systemDef);
    }

    public void setSystemDef(SystemDef[] systemDefs) {
        this.m_systemDefs.clear();
        for (int i = 0; i < systemDefs.length; ++i) {
            this.m_systemDefs.add(systemDefs[i]);
        }
    }

    public void setSystemDef(List<SystemDef> systemDefs) {
        this.m_systemDefs.clear();
        this.m_systemDefs.addAll(systemDefs);
    }

    public void setSystemDefCollection(List<SystemDef> systemDefs) {
        this.m_systemDefs = systemDefs;
    }

    @Deprecated
    public static Systems unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Systems)Unmarshaller.unmarshal(Systems.class, (Reader)reader);
    }

    @Deprecated
    public void validate() throws ValidationException {
        new Validator().validate((Object)this);
    }
}

