/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.datacollection;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.core.xml.ValidateUsing;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="ipList", namespace="http://xmlns.opennms.org/xsd/config/datacollection")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="datacollection-config.xsd")
public class IpList
implements Serializable {
    private static final long serialVersionUID = -5925958500985291547L;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private List<String> m_ipAddresses = new ArrayList<String>();
    private List<String> m_ipAddressMasks = new ArrayList<String>();

    public void addIpAddr(String ipAddr) throws IndexOutOfBoundsException {
        this.m_ipAddresses.add(ipAddr.intern());
    }

    public void addIpAddr(int index, String ipAddr) throws IndexOutOfBoundsException {
        this.m_ipAddresses.add(index, ipAddr.intern());
    }

    public void addIpAddrMask(String ipAddrMask) throws IndexOutOfBoundsException {
        this.m_ipAddressMasks.add(ipAddrMask.intern());
    }

    public void addIpAddrMask(int index, String ipAddrMask) throws IndexOutOfBoundsException {
        this.m_ipAddressMasks.add(index, ipAddrMask.intern());
    }

    public Enumeration<String> enumerateIpAddr() {
        return Collections.enumeration(this.m_ipAddresses);
    }

    public Enumeration<String> enumerateIpAddrMask() {
        return Collections.enumeration(this.m_ipAddressMasks);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IpList) {
            IpList temp = (IpList)obj;
            if (this.m_ipAddresses != null) {
                if (temp.m_ipAddresses == null) {
                    return false;
                }
                if (!((Object)this.m_ipAddresses).equals(temp.m_ipAddresses)) {
                    return false;
                }
            } else if (temp.m_ipAddresses != null) {
                return false;
            }
            if (this.m_ipAddressMasks != null) {
                if (temp.m_ipAddressMasks == null) {
                    return false;
                }
                if (!((Object)this.m_ipAddressMasks).equals(temp.m_ipAddressMasks)) {
                    return false;
                }
            } else if (temp.m_ipAddressMasks != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getIpAddr(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_ipAddresses.size()) {
            throw new IndexOutOfBoundsException("getIpAddr: Index value '" + index + "' not in range [0.." + (this.m_ipAddresses.size() - 1) + "]");
        }
        return this.m_ipAddresses.get(index);
    }

    @XmlElement(name="ipAddr")
    public String[] getIpAddr() {
        return this.m_ipAddresses.toArray(EMPTY_STRING_ARRAY);
    }

    public List<String> getIpAddrCollection() {
        return this.m_ipAddresses;
    }

    public int getIpAddrCount() {
        return this.m_ipAddresses.size();
    }

    public String getIpAddrMask(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_ipAddressMasks.size()) {
            throw new IndexOutOfBoundsException("getIpAddrMask: Index value '" + index + "' not in range [0.." + (this.m_ipAddressMasks.size() - 1) + "]");
        }
        return this.m_ipAddressMasks.get(index);
    }

    @XmlElement(name="ipAddrMask")
    public String[] getIpAddrMask() {
        return this.m_ipAddressMasks.toArray(EMPTY_STRING_ARRAY);
    }

    public List<String> getIpAddrMaskCollection() {
        return this.m_ipAddressMasks;
    }

    public int getIpAddrMaskCount() {
        return this.m_ipAddressMasks.size();
    }

    public int hashCode() {
        int result = 17;
        if (this.m_ipAddresses != null) {
            result = 37 * result + ((Object)this.m_ipAddresses).hashCode();
        }
        if (this.m_ipAddressMasks != null) {
            result = 37 * result + ((Object)this.m_ipAddressMasks).hashCode();
        }
        return result;
    }

    @Deprecated
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<String> iterateIpAddr() {
        return this.m_ipAddresses.iterator();
    }

    public Iterator<String> iterateIpAddrMask() {
        return this.m_ipAddressMasks.iterator();
    }

    @Deprecated
    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    @Deprecated
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllIpAddr() {
        this.m_ipAddresses.clear();
    }

    public void removeAllIpAddrMask() {
        this.m_ipAddressMasks.clear();
    }

    public boolean removeIpAddr(String ipAddr) {
        return this.m_ipAddresses.remove(ipAddr);
    }

    public String removeIpAddrAt(int index) {
        return this.m_ipAddresses.remove(index);
    }

    public boolean removeIpAddrMask(String ipAddrMask) {
        return this.m_ipAddressMasks.remove(ipAddrMask);
    }

    public String removeIpAddrMaskAt(int index) {
        return this.m_ipAddressMasks.remove(index);
    }

    public void setIpAddr(int index, String ipAddr) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_ipAddresses.size()) {
            throw new IndexOutOfBoundsException("setIpAddr: Index value '" + index + "' not in range [0.." + (this.m_ipAddresses.size() - 1) + "]");
        }
        this.m_ipAddresses.set(index, ipAddr.intern());
    }

    public void setIpAddr(String[] ipAddrs) {
        this.m_ipAddresses.clear();
        for (int i = 0; i < ipAddrs.length; ++i) {
            this.m_ipAddresses.add(ipAddrs[i].intern());
        }
    }

    public void setIpAddr(List<String> ipAddrs) {
        this.m_ipAddresses.clear();
        for (String ipAddr : ipAddrs) {
            this.m_ipAddresses.add(ipAddr.intern());
        }
    }

    public void setIpAddrCollection(List<String> ipAddrs) {
        this.m_ipAddresses = new ArrayList<String>();
        for (String ipAddr : ipAddrs) {
            this.m_ipAddresses.add(ipAddr.intern());
        }
    }

    public void setIpAddrMask(int index, String ipAddrMask) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_ipAddressMasks.size()) {
            throw new IndexOutOfBoundsException("setIpAddrMask: Index value '" + index + "' not in range [0.." + (this.m_ipAddressMasks.size() - 1) + "]");
        }
        this.m_ipAddressMasks.set(index, ipAddrMask.intern());
    }

    public void setIpAddrMask(String[] ipAddrMasks) {
        this.m_ipAddressMasks.clear();
        for (int i = 0; i < ipAddrMasks.length; ++i) {
            this.m_ipAddressMasks.add(ipAddrMasks[i].intern());
        }
    }

    public void setIpAddrMask(List<String> ipAddrMasks) {
        this.m_ipAddressMasks.clear();
        for (String ipAddrMask : ipAddrMasks) {
            this.m_ipAddressMasks.add(ipAddrMask.intern());
        }
    }

    public void setIpAddrMaskCollection(List<String> ipAddrMasks) {
        this.m_ipAddressMasks = new ArrayList<String>();
        for (String ipAddrMask : ipAddrMasks) {
            this.m_ipAddressMasks.add(ipAddrMask.intern());
        }
    }

    @Deprecated
    public static IpList unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (IpList)Unmarshaller.unmarshal(IpList.class, (Reader)reader);
    }

    @Deprecated
    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

