/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.datacollection;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.core.xml.ValidateUsing;
import org.xml.sax.ContentHandler;

@XmlRootElement(name="include-collection", namespace="http://xmlns.opennms.org/xsd/config/datacollection")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="datacollection-config.xsd")
public class IncludeCollection
implements Serializable {
    private static final long serialVersionUID = -1484624151254635162L;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private String m_systemDef;
    private String m_dataCollectionGroup;
    private List<String> m_excludeFilters = new ArrayList<String>();

    public void addExcludeFilter(String excludeFilter) throws IndexOutOfBoundsException {
        this.m_excludeFilters.add(excludeFilter);
    }

    public void addExcludeFilter(int index, String excludeFilter) throws IndexOutOfBoundsException {
        this.m_excludeFilters.add(index, excludeFilter);
    }

    public Enumeration<String> enumerateExcludeFilter() {
        return Collections.enumeration(this.m_excludeFilters);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IncludeCollection) {
            IncludeCollection temp = (IncludeCollection)obj;
            if (this.m_systemDef != null) {
                if (temp.m_systemDef == null) {
                    return false;
                }
                if (!this.m_systemDef.equals(temp.m_systemDef)) {
                    return false;
                }
            } else if (temp.m_systemDef != null) {
                return false;
            }
            if (this.m_dataCollectionGroup != null) {
                if (temp.m_dataCollectionGroup == null) {
                    return false;
                }
                if (!this.m_dataCollectionGroup.equals(temp.m_dataCollectionGroup)) {
                    return false;
                }
            } else if (temp.m_dataCollectionGroup != null) {
                return false;
            }
            if (this.m_excludeFilters != null) {
                if (temp.m_excludeFilters == null) {
                    return false;
                }
                if (!((Object)this.m_excludeFilters).equals(temp.m_excludeFilters)) {
                    return false;
                }
            } else if (temp.m_excludeFilters != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    @XmlAttribute(name="dataCollectionGroup")
    public String getDataCollectionGroup() {
        return this.m_dataCollectionGroup;
    }

    public String getExcludeFilter(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_excludeFilters.size()) {
            throw new IndexOutOfBoundsException("getExcludeFilter: Index value '" + index + "' not in range [0.." + (this.m_excludeFilters.size() - 1) + "]");
        }
        return this.m_excludeFilters.get(index);
    }

    @XmlElement(name="exclude-filter")
    public String[] getExcludeFilter() {
        return this.m_excludeFilters.toArray(EMPTY_STRING_ARRAY);
    }

    public List<String> getExcludeFilterCollection() {
        return this.m_excludeFilters;
    }

    public int getExcludeFilterCount() {
        return this.m_excludeFilters.size();
    }

    @XmlAttribute(name="systemDef")
    public String getSystemDef() {
        return this.m_systemDef;
    }

    public int hashCode() {
        int result = 17;
        if (this.m_systemDef != null) {
            result = 37 * result + this.m_systemDef.hashCode();
        }
        if (this.m_dataCollectionGroup != null) {
            result = 37 * result + this.m_dataCollectionGroup.hashCode();
        }
        if (this.m_excludeFilters != null) {
            result = 37 * result + ((Object)this.m_excludeFilters).hashCode();
        }
        return result;
    }

    @Deprecated
    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<String> iterateExcludeFilter() {
        return this.m_excludeFilters.iterator();
    }

    @Deprecated
    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    @Deprecated
    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllExcludeFilter() {
        this.m_excludeFilters.clear();
    }

    public boolean removeExcludeFilter(String excludeFilter) {
        return this.m_excludeFilters.remove(excludeFilter);
    }

    public String removeExcludeFilterAt(int index) {
        return this.m_excludeFilters.remove(index);
    }

    public void setDataCollectionGroup(String dataCollectionGroup) {
        this.m_dataCollectionGroup = dataCollectionGroup.intern();
    }

    public void setExcludeFilter(int index, String excludeFilter) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.m_excludeFilters.size()) {
            throw new IndexOutOfBoundsException("setExcludeFilter: Index value '" + index + "' not in range [0.." + (this.m_excludeFilters.size() - 1) + "]");
        }
        this.m_excludeFilters.set(index, excludeFilter.intern());
    }

    public void setExcludeFilter(String[] excludeFilters) {
        this.m_excludeFilters.clear();
        for (int i = 0; i < excludeFilters.length; ++i) {
            this.m_excludeFilters.add(excludeFilters[i].intern());
        }
    }

    public void setExcludeFilter(List<String> excludeFilters) {
        this.m_excludeFilters.clear();
        for (String excludeFilter : excludeFilters) {
            this.m_excludeFilters.add(excludeFilter.intern());
        }
    }

    public void setExcludeFilterCollection(List<String> excludeFilters) {
        this.m_excludeFilters = new ArrayList<String>();
        for (String excludeFilter : excludeFilters) {
            this.m_excludeFilters.add(excludeFilter.intern());
        }
    }

    public void setSystemDef(String systemDef) {
        this.m_systemDef = systemDef.intern();
    }

    @Deprecated
    public static IncludeCollection unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (IncludeCollection)Unmarshaller.unmarshal(IncludeCollection.class, (Reader)reader);
    }

    @Deprecated
    public void validate() throws ValidationException {
        new Validator().validate((Object)this);
    }
}

