/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.ami;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.ami.Range;
import org.xml.sax.ContentHandler;

public class Definition
implements Serializable {
    private int _port;
    private boolean _has_port;
    private boolean _useSsl;
    private boolean _has_useSsl;
    private int _timeout;
    private boolean _has_timeout;
    private int _retry;
    private boolean _has_retry;
    private String _username;
    private String _password;
    private List<Range> _rangeList = new ArrayList<Range>();
    private List<String> _specificList = new ArrayList<String>();
    private List<String> _ipMatchList = new ArrayList<String>();

    public void addIpMatch(String vIpMatch) throws IndexOutOfBoundsException {
        this._ipMatchList.add(vIpMatch);
    }

    public void addIpMatch(int index, String vIpMatch) throws IndexOutOfBoundsException {
        this._ipMatchList.add(index, vIpMatch);
    }

    public void addRange(Range vRange) throws IndexOutOfBoundsException {
        this._rangeList.add(vRange);
    }

    public void addRange(int index, Range vRange) throws IndexOutOfBoundsException {
        this._rangeList.add(index, vRange);
    }

    public void addSpecific(String vSpecific) throws IndexOutOfBoundsException {
        this._specificList.add(vSpecific);
    }

    public void addSpecific(int index, String vSpecific) throws IndexOutOfBoundsException {
        this._specificList.add(index, vSpecific);
    }

    public void deletePort() {
        this._has_port = false;
    }

    public void deleteRetry() {
        this._has_retry = false;
    }

    public void deleteTimeout() {
        this._has_timeout = false;
    }

    public void deleteUseSsl() {
        this._has_useSsl = false;
    }

    public Enumeration<String> enumerateIpMatch() {
        return Collections.enumeration(this._ipMatchList);
    }

    public Enumeration<Range> enumerateRange() {
        return Collections.enumeration(this._rangeList);
    }

    public Enumeration<String> enumerateSpecific() {
        return Collections.enumeration(this._specificList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Definition) {
            Definition temp = (Definition)obj;
            if (this._port != temp._port) {
                return false;
            }
            if (this._has_port != temp._has_port) {
                return false;
            }
            if (this._useSsl != temp._useSsl) {
                return false;
            }
            if (this._has_useSsl != temp._has_useSsl) {
                return false;
            }
            if (this._timeout != temp._timeout) {
                return false;
            }
            if (this._has_timeout != temp._has_timeout) {
                return false;
            }
            if (this._retry != temp._retry) {
                return false;
            }
            if (this._has_retry != temp._has_retry) {
                return false;
            }
            if (this._username != null) {
                if (temp._username == null) {
                    return false;
                }
                if (!this._username.equals(temp._username)) {
                    return false;
                }
            } else if (temp._username != null) {
                return false;
            }
            if (this._password != null) {
                if (temp._password == null) {
                    return false;
                }
                if (!this._password.equals(temp._password)) {
                    return false;
                }
            } else if (temp._password != null) {
                return false;
            }
            if (this._rangeList != null) {
                if (temp._rangeList == null) {
                    return false;
                }
                if (!((Object)this._rangeList).equals(temp._rangeList)) {
                    return false;
                }
            } else if (temp._rangeList != null) {
                return false;
            }
            if (this._specificList != null) {
                if (temp._specificList == null) {
                    return false;
                }
                if (!((Object)this._specificList).equals(temp._specificList)) {
                    return false;
                }
            } else if (temp._specificList != null) {
                return false;
            }
            if (this._ipMatchList != null) {
                if (temp._ipMatchList == null) {
                    return false;
                }
                if (!((Object)this._ipMatchList).equals(temp._ipMatchList)) {
                    return false;
                }
            } else if (temp._ipMatchList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getIpMatch(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ipMatchList.size()) {
            throw new IndexOutOfBoundsException("getIpMatch: Index value '" + index + "' not in range [0.." + (this._ipMatchList.size() - 1) + "]");
        }
        return this._ipMatchList.get(index);
    }

    public String[] getIpMatch() {
        String[] array = new String[]{};
        return this._ipMatchList.toArray(array);
    }

    public List<String> getIpMatchCollection() {
        return this._ipMatchList;
    }

    public int getIpMatchCount() {
        return this._ipMatchList.size();
    }

    public String getPassword() {
        return this._password;
    }

    public int getPort() {
        return this._port;
    }

    public Range getRange(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._rangeList.size()) {
            throw new IndexOutOfBoundsException("getRange: Index value '" + index + "' not in range [0.." + (this._rangeList.size() - 1) + "]");
        }
        return this._rangeList.get(index);
    }

    public Range[] getRange() {
        Range[] array = new Range[]{};
        return this._rangeList.toArray(array);
    }

    public List<Range> getRangeCollection() {
        return this._rangeList;
    }

    public int getRangeCount() {
        return this._rangeList.size();
    }

    public int getRetry() {
        return this._retry;
    }

    public String getSpecific(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._specificList.size()) {
            throw new IndexOutOfBoundsException("getSpecific: Index value '" + index + "' not in range [0.." + (this._specificList.size() - 1) + "]");
        }
        return this._specificList.get(index);
    }

    public String[] getSpecific() {
        String[] array = new String[]{};
        return this._specificList.toArray(array);
    }

    public List<String> getSpecificCollection() {
        return this._specificList;
    }

    public int getSpecificCount() {
        return this._specificList.size();
    }

    public int getTimeout() {
        return this._timeout;
    }

    public boolean getUseSsl() {
        return this._useSsl;
    }

    public String getUsername() {
        return this._username;
    }

    public boolean hasPort() {
        return this._has_port;
    }

    public boolean hasRetry() {
        return this._has_retry;
    }

    public boolean hasTimeout() {
        return this._has_timeout;
    }

    public boolean hasUseSsl() {
        return this._has_useSsl;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this._port;
        result = 37 * result + (this._useSsl ? 0 : 1);
        result = 37 * result + this._timeout;
        result = 37 * result + this._retry;
        if (this._username != null) {
            result = 37 * result + this._username.hashCode();
        }
        if (this._password != null) {
            result = 37 * result + this._password.hashCode();
        }
        if (this._rangeList != null) {
            result = 37 * result + ((Object)this._rangeList).hashCode();
        }
        if (this._specificList != null) {
            result = 37 * result + ((Object)this._specificList).hashCode();
        }
        if (this._ipMatchList != null) {
            result = 37 * result + ((Object)this._ipMatchList).hashCode();
        }
        return result;
    }

    public boolean isUseSsl() {
        return this._useSsl;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<String> iterateIpMatch() {
        return this._ipMatchList.iterator();
    }

    public Iterator<Range> iterateRange() {
        return this._rangeList.iterator();
    }

    public Iterator<String> iterateSpecific() {
        return this._specificList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllIpMatch() {
        this._ipMatchList.clear();
    }

    public void removeAllRange() {
        this._rangeList.clear();
    }

    public void removeAllSpecific() {
        this._specificList.clear();
    }

    public boolean removeIpMatch(String vIpMatch) {
        boolean removed = this._ipMatchList.remove(vIpMatch);
        return removed;
    }

    public String removeIpMatchAt(int index) {
        String obj = this._ipMatchList.remove(index);
        return obj;
    }

    public boolean removeRange(Range vRange) {
        boolean removed = this._rangeList.remove(vRange);
        return removed;
    }

    public Range removeRangeAt(int index) {
        Range obj = this._rangeList.remove(index);
        return obj;
    }

    public boolean removeSpecific(String vSpecific) {
        boolean removed = this._specificList.remove(vSpecific);
        return removed;
    }

    public String removeSpecificAt(int index) {
        String obj = this._specificList.remove(index);
        return obj;
    }

    public void setIpMatch(int index, String vIpMatch) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ipMatchList.size()) {
            throw new IndexOutOfBoundsException("setIpMatch: Index value '" + index + "' not in range [0.." + (this._ipMatchList.size() - 1) + "]");
        }
        this._ipMatchList.set(index, vIpMatch);
    }

    public void setIpMatch(String[] vIpMatchArray) {
        this._ipMatchList.clear();
        for (int i = 0; i < vIpMatchArray.length; ++i) {
            this._ipMatchList.add(vIpMatchArray[i]);
        }
    }

    public void setIpMatch(List<String> vIpMatchList) {
        this._ipMatchList.clear();
        this._ipMatchList.addAll(vIpMatchList);
    }

    public void setIpMatchCollection(List<String> ipMatchList) {
        this._ipMatchList = ipMatchList;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setPort(int port) {
        this._port = port;
        this._has_port = true;
    }

    public void setRange(int index, Range vRange) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._rangeList.size()) {
            throw new IndexOutOfBoundsException("setRange: Index value '" + index + "' not in range [0.." + (this._rangeList.size() - 1) + "]");
        }
        this._rangeList.set(index, vRange);
    }

    public void setRange(Range[] vRangeArray) {
        this._rangeList.clear();
        for (int i = 0; i < vRangeArray.length; ++i) {
            this._rangeList.add(vRangeArray[i]);
        }
    }

    public void setRange(List<Range> vRangeList) {
        this._rangeList.clear();
        this._rangeList.addAll(vRangeList);
    }

    public void setRangeCollection(List<Range> rangeList) {
        this._rangeList = rangeList;
    }

    public void setRetry(int retry) {
        this._retry = retry;
        this._has_retry = true;
    }

    public void setSpecific(int index, String vSpecific) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._specificList.size()) {
            throw new IndexOutOfBoundsException("setSpecific: Index value '" + index + "' not in range [0.." + (this._specificList.size() - 1) + "]");
        }
        this._specificList.set(index, vSpecific);
    }

    public void setSpecific(String[] vSpecificArray) {
        this._specificList.clear();
        for (int i = 0; i < vSpecificArray.length; ++i) {
            this._specificList.add(vSpecificArray[i]);
        }
    }

    public void setSpecific(List<String> vSpecificList) {
        this._specificList.clear();
        this._specificList.addAll(vSpecificList);
    }

    public void setSpecificCollection(List<String> specificList) {
        this._specificList = specificList;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
        this._has_timeout = true;
    }

    public void setUseSsl(boolean useSsl) {
        this._useSsl = useSsl;
        this._has_useSsl = true;
    }

    public void setUsername(String username) {
        this._username = username;
    }

    public static Definition unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Definition)Unmarshaller.unmarshal(Definition.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

