/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.bootstrap;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bootstrap {
    protected static final String BOOT_PROPERTIES_NAME = "bootstrap.properties";
    protected static final String RRD_PROPERTIES_NAME = "rrd-configuration.properties";
    protected static final String LIBRARY_PROPERTIES_NAME = "libraries.properties";
    protected static final String OPENNMS_HOME_PROPERTY = "opennms.home";
    private static FileFilter m_dirFilter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };
    private static FilenameFilter m_jarFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    };

    public static ClassLoader loadClasses(String dirStr, boolean recursive, boolean append) throws MalformedURLException {
        LinkedList<URL> urls = new LinkedList<URL>();
        if (append) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (URL u : ((URLClassLoader)classLoader).getURLs()) {
                urls.add(u);
            }
        }
        StringTokenizer toke = new StringTokenizer(dirStr, File.pathSeparator);
        while (toke.hasMoreTokens()) {
            String token = toke.nextToken();
            Bootstrap.loadClasses(new File(token), recursive, urls);
        }
        return Bootstrap.newClassLoader(urls);
    }

    public static ClassLoader loadClasses(File dir, boolean recursive) throws MalformedURLException {
        LinkedList<URL> urls = new LinkedList<URL>();
        Bootstrap.loadClasses(dir, recursive, urls);
        return Bootstrap.newClassLoader(urls);
    }

    public static ClassLoader newClassLoader(LinkedList<URL> urls) {
        URL[] urlsArray = urls.toArray(new URL[0]);
        return URLClassLoader.newInstance(urlsArray);
    }

    public static void loadClasses(File dir, boolean recursive, LinkedList<URL> urls) throws MalformedURLException {
        File[] children;
        File[] dirlist;
        urls.add(dir.toURI().toURL());
        if (recursive && (dirlist = dir.listFiles(m_dirFilter)) != null) {
            for (File childDir : dirlist) {
                Bootstrap.loadClasses(childDir, recursive, urls);
            }
        }
        if ((children = dir.listFiles(m_jarFilter)) != null) {
            for (File childFile : children) {
                urls.add(childFile.toURI().toURL());
            }
        }
    }

    public static File findOpenNMSHome() {
        ClassLoader l = Thread.currentThread().getContextClassLoader();
        try {
            URL subUrl;
            String classFile = Bootstrap.class.getName().replace('.', '/') + ".class";
            URL url = l.getResource(classFile);
            if (url.getProtocol().equals("jar") && (subUrl = new URL(url.getFile())).getProtocol().equals("file")) {
                String filePath = subUrl.getFile();
                int i = filePath.lastIndexOf(33);
                File file = new File(filePath.substring(0, i));
                return file.getParentFile().getParentFile();
            }
        }
        catch (MalformedURLException e) {
            return null;
        }
        return null;
    }

    protected static void loadProperties(InputStream is) throws IOException {
        Properties p = new Properties();
        p.load(is);
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String propertyName = entry.getKey().toString();
            Object value = entry.getValue();
            if (value == null) continue;
            System.setProperty(propertyName, value.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean loadProperties(File f) throws IOException {
        if (!f.exists()) {
            return false;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            Bootstrap.loadProperties(is);
            boolean bl = true;
            return bl;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    protected static boolean loadDefaultProperties(File opennmsHome) throws IOException {
        boolean propertiesLoaded = true;
        File etc = new File(opennmsHome, "etc");
        File bootstrapFile = new File(etc, BOOT_PROPERTIES_NAME);
        Bootstrap.loadProperties(bootstrapFile);
        File rrdFile = new File(etc, RRD_PROPERTIES_NAME);
        Bootstrap.loadProperties(rrdFile);
        File libraryFile = new File(etc, LIBRARY_PROPERTIES_NAME);
        if (!Bootstrap.loadProperties(libraryFile)) {
            propertiesLoaded = false;
        }
        return propertiesLoaded;
    }

    public static void main(String[] args) throws Exception {
        Bootstrap.loadDefaultProperties();
        String classToExec = System.getProperty("opennms.manager.class", "org.opennms.netmgt.vmmgr.Controller");
        String classToExecMethod = "main";
        String[] classToExecArgs = args;
        Bootstrap.executeClass(classToExec, "main", classToExecArgs, false);
    }

    protected static void executeClass(String classToExec, String classToExecMethod, String[] classToExecArgs, boolean appendClasspath) throws MalformedURLException, ClassNotFoundException, NoSuchMethodException {
        String dir = System.getProperty("opennms.classpath");
        if (dir == null) {
            dir = System.getProperty(OPENNMS_HOME_PROPERTY) + File.separator + "classes" + File.pathSeparator + System.getProperty(OPENNMS_HOME_PROPERTY) + File.separator + "lib" + File.pathSeparator + System.getProperty(OPENNMS_HOME_PROPERTY) + File.separator + "etc";
        }
        if (System.getProperty("org.opennms.protocols.icmp.interfaceJar") != null) {
            dir = dir + File.pathSeparator + System.getProperty("org.opennms.protocols.icmp.interfaceJar");
        }
        if (System.getProperty("org.opennms.rrd.interfaceJar") != null) {
            dir = dir + File.pathSeparator + System.getProperty("org.opennms.rrd.interfaceJar");
        }
        ClassLoader cl = Bootstrap.loadClasses(dir, false, false);
        if (classToExec != null) {
            String className = classToExec;
            Class[] classes = new Class[]{classToExecArgs.getClass()};
            final Object[] methodArgs = new Object[]{classToExecArgs};
            Class<?> c = cl.loadClass(className);
            final Method method = c.getMethod(classToExecMethod, classes);
            Runnable execer = new Runnable(){

                public void run() {
                    try {
                        method.invoke(null, methodArgs);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
            };
            Thread bootstrapper = new Thread(execer, "Main");
            bootstrapper.setContextClassLoader(cl);
            bootstrapper.start();
        }
    }

    protected static void loadDefaultProperties() throws Exception {
        boolean propertiesLoaded = false;
        String opennmsHome = System.getProperty(OPENNMS_HOME_PROPERTY);
        if (opennmsHome != null) {
            propertiesLoaded = Bootstrap.loadDefaultProperties(new File(opennmsHome));
        }
        if (!propertiesLoaded) {
            File parent = Bootstrap.findOpenNMSHome();
            if (parent == null) {
                System.err.println("Could not determine OpenNMS home directory.  Use \"-Dopennms.home=...\" option to Java to specify a specific OpenNMS home directory.  E.g.: \"java -Dopennms.home=... -jar ...\".");
                System.exit(1);
            }
            propertiesLoaded = Bootstrap.loadDefaultProperties(parent);
            System.setProperty(OPENNMS_HOME_PROPERTY, parent.getPath());
        }
        if (!propertiesLoaded) {
            throw new RuntimeException("Unable to load default properties from $OPENNMS_HOME!");
        }
    }
}

