/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.asterisk.agi.scripts;

import org.asteriskjava.fastagi.AgiChannel;
import org.asteriskjava.fastagi.AgiException;
import org.asteriskjava.fastagi.AgiRequest;
import org.opennms.netmgt.asterisk.agi.scripts.BaseOnmsAgiScript;

public class ReadNoticeDetailsAgiScript
extends BaseOnmsAgiScript {
    public void service(AgiRequest req, AgiChannel chan) throws AgiException {
        this.authenticateUser();
        this.sayNode();
        this.sayServiceName();
        this.streamFile("silence/1");
        this.sayIpAddr();
    }

    public void authenticateUser() throws AgiException {
        String actualPin = this.getVariable("OPENNMS_USER_PIN");
        if (actualPin == null || "".equals(actualPin)) {
            this.log().info((Object)"User has no TUI PIN, so proceeding without authentication");
            return;
        }
        String inputPin = null;
        for (int attempts = 0; !String.valueOf(inputPin).equals(String.valueOf(actualPin)) && attempts < 3; ++attempts) {
            if (attempts > 0) {
                this.streamFile("auth-incorrect");
            }
            inputPin = this.getData("enter-password");
        }
        if (String.valueOf(inputPin).equals(String.valueOf(actualPin))) {
            return;
        }
        this.log().warn((Object)("User " + this.getVariable("OPENNMS_USERNAME") + " failed authentication"));
        this.streamFile("auth-incorrect");
        this.streamFile("goodbye");
        this.hangup();
    }

    public void sayNode() throws AgiException {
        String nodeID = null;
        String nodeLabel = null;
        nodeID = this.getVariable("OPENNMS_NODEID");
        nodeLabel = this.getVariable("OPENNMS_NODELABEL");
        if (!"".equals(nodeLabel)) {
            this.log().debug((Object)("Reading node label to user: " + nodeLabel));
            this.streamFileInterruptible("node");
            this.sayAlphaInterruptible(nodeLabel);
        } else if (!"".equals(nodeID)) {
            this.log().debug((Object)("Reading node ID to user: " + nodeID));
            this.streamFileInterruptible("node");
            this.streamFileInterruptible("number");
            this.sayDigitsInterruptible(nodeID);
        } else {
            this.log().debug((Object)"No node label or node ID available");
        }
    }

    public void sayIpAddr() throws AgiException {
        String ipAddr = null;
        ipAddr = this.getVariable("OPENNMS_INTERFACE");
        if (ipAddr != null && !"".equals(ipAddr)) {
            this.log().debug((Object)("Reading IP address to user: " + ipAddr));
            this.streamFile("letters/i");
            this.streamFile("letters/p");
            this.streamFile("address");
            this.sayIpAddressInterruptible(ipAddr);
        }
    }

    public void sayServiceName() throws AgiException {
        String svcName = null;
        svcName = this.getVariable("OPENNMS_SERVICE");
        if (svcName != null && !"".equals(svcName)) {
            this.log().debug((Object)("Reading service name to user: " + svcName));
            this.streamFile("service");
            this.sayAlpha(svcName);
        } else {
            this.log().debug((Object)"No service name available");
        }
    }
}

