/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.drools;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.base.accumulators.AbstractAccumulateFunction;
import org.opennms.netmgt.model.OnmsSeverity;

public class MaxSeverityAccumulateFunction
extends AbstractAccumulateFunction<MaxSeverity> {
    public MaxSeverity createContext() {
        return new MaxSeverity();
    }

    public void init(MaxSeverity context) {
        context.max = null;
    }

    public void accumulate(MaxSeverity context, Object value) {
        if (value instanceof OnmsSeverity) {
            OnmsSeverity severity = (OnmsSeverity)value;
            context.max = context.max == null || context.max.compareTo((Enum)severity) < 0 ? severity : context.max;
        }
    }

    public Object getResult(MaxSeverity context) {
        return context.max;
    }

    public boolean supportsReverse() {
        return false;
    }

    public void reverse(MaxSeverity context, Object value) {
    }

    public Class<?> getResultType() {
        return OnmsSeverity.class;
    }

    public void writeExternal(ObjectOutput out) {
    }

    public void readExternal(ObjectInput in) {
    }

    protected static class MaxSeverity
    implements Externalizable {
        public OnmsSeverity max = null;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.max = (OnmsSeverity)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.max);
        }

        public String toString() {
            return "max";
        }
    }
}

