/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.drools;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.File;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.hibernate.Hibernate;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.alarmd.api.AlarmCallbackStateTracker;
import org.opennms.netmgt.alarmd.api.AlarmLifecycleListener;
import org.opennms.netmgt.alarmd.drools.AlarmAcknowledgementAndFact;
import org.opennms.netmgt.alarmd.drools.AlarmAndFact;
import org.opennms.netmgt.alarmd.drools.AlarmAssociationAndFact;
import org.opennms.netmgt.alarmd.drools.AlarmService;
import org.opennms.netmgt.alarmd.drools.AlarmTicketerService;
import org.opennms.netmgt.alarmd.drools.ManagedDroolsContext;
import org.opennms.netmgt.dao.api.AcknowledgmentDao;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.AlarmAssociation;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAlarm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class DroolsAlarmContext
extends ManagedDroolsContext
implements AlarmLifecycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(DroolsAlarmContext.class);
    private static final String LOCK_TIMEOUT_MS_SYS_PROP = "org.opennms.alarms.drools.lock.timeout.ms";
    protected static final long LOCK_TIMEOUT_MS = SystemProperties.getLong((String)"org.opennms.alarms.drools.lock.timeout.ms", (Long)TimeUnit.SECONDS.toMillis(20L));
    @Autowired
    private AlarmService alarmService;
    @Autowired
    private AcknowledgmentDao acknowledgmentDao;
    @Autowired
    private AlarmTicketerService alarmTicketerService;
    @Autowired
    private TransactionTemplate template;
    @Autowired
    private AlarmDao alarmDao;
    private final AlarmCallbackStateTracker stateTracker = new AlarmCallbackStateTracker();
    private final Map<Integer, AlarmAndFact> alarmsById = new HashMap<Integer, AlarmAndFact>();
    private final Map<Integer, AlarmAcknowledgementAndFact> acknowledgementsByAlarmId = new HashMap<Integer, AlarmAcknowledgementAndFact>();
    private final Map<Integer, Map<Integer, AlarmAssociationAndFact>> alarmAssociationById = new HashMap<Integer, Map<Integer, AlarmAssociationAndFact>>();

    public DroolsAlarmContext() {
        this(DroolsAlarmContext.getDefaultRulesFolder());
    }

    public DroolsAlarmContext(File rulesFolder) {
        super(rulesFolder, "alarmd", "DroolsAlarmContext");
        this.setOnNewKiewSessionCallback(kieSession -> {
            kieSession.setGlobal("alarmService", (Object)this.alarmService);
            kieSession.insert((Object)this.alarmTicketerService);
            this.alarmsById.clear();
            this.acknowledgementsByAlarmId.clear();
            this.alarmAssociationById.clear();
            for (FactHandle fact : kieSession.getFactHandles()) {
                Object objForFact = kieSession.getObject(fact);
                if (objForFact instanceof OnmsAlarm) {
                    OnmsAlarm alarmInSession = (OnmsAlarm)objForFact;
                    this.alarmsById.put(alarmInSession.getId(), new AlarmAndFact(alarmInSession, fact));
                    continue;
                }
                if (objForFact instanceof OnmsAcknowledgment) {
                    OnmsAcknowledgment ackInSession = (OnmsAcknowledgment)objForFact;
                    this.acknowledgementsByAlarmId.put(ackInSession.getRefId(), new AlarmAcknowledgementAndFact(ackInSession, fact));
                    continue;
                }
                if (!(objForFact instanceof AlarmAssociation)) continue;
                AlarmAssociation associationInSession = (AlarmAssociation)objForFact;
                Integer situationId = associationInSession.getSituationAlarm().getId();
                Integer alarmId = associationInSession.getRelatedAlarm().getId();
                Map associationFacts = this.alarmAssociationById.computeIfAbsent(situationId, sid -> new HashMap());
                associationFacts.put(alarmId, new AlarmAssociationAndFact(associationInSession, fact));
            }
        });
    }

    public static File getDefaultRulesFolder() {
        return Paths.get(ConfigFileConstants.getHome(), "etc", "alarmd", "drools-rules.d").toFile();
    }

    @Override
    public void onStart() {
        CountDownLatch latch = new CountDownLatch(1);
        Thread seedThread = new Thread(() -> {
            this.getLock().lock();
            latch.countDown();
            try {
                this.preHandleAlarmSnapshot();
                this.template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        LOG.info("Loading all alarms to seed Drools context.");
                        List allAlarms = DroolsAlarmContext.this.alarmDao.findAll();
                        LOG.info("Done loading {} alarms.", (Object)allAlarms.size());
                        DroolsAlarmContext.this.handleAlarmSnapshot(allAlarms);
                    }
                });
            }
            finally {
                this.postHandleAlarmSnapshot();
                this.getLock().unlock();
            }
        });
        seedThread.setName("DroolAlarmContext-InitialSeed");
        seedThread.start();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for seed thread to acquire session lock. The engine may not have a complete view of the state on startup.");
        }
    }

    public void preHandleAlarmSnapshot() {
        this.getLock().lock();
        try {
            this.stateTracker.startTrackingAlarms();
        }
        finally {
            this.getLock().unlock();
        }
    }

    public void handleAlarmSnapshot(List<OnmsAlarm> alarms) {
        if (!this.isStarted()) {
            LOG.debug("Ignoring alarm snapshot. Drools session is stopped.");
            return;
        }
        this.getLock().lock();
        LOG.debug("Handling snapshot for {} alarms.", (Object)alarms.size());
        Map<Integer, OnmsAlarm> alarmsInDbById = alarms.stream().filter(a -> a.getId() != null).collect(Collectors.toMap(OnmsAlarm::getId, a -> a));
        Set<Integer> alarmIdsInDb = alarmsInDbById.keySet();
        Set<Integer> alarmIdsInWorkingMem = this.alarmsById.keySet();
        Set alarmIdsToAdd = Sets.difference(alarmIdsInDb, alarmIdsInWorkingMem).stream().filter(alarmId -> !this.stateTracker.wasAlarmWithIdDeleted(alarmId.intValue())).collect(Collectors.toSet());
        Set alarmIdsToRemove = Sets.difference(alarmIdsInWorkingMem, alarmIdsInDb).stream().filter(alarmId -> !this.stateTracker.wasAlarmWithIdUpdated(alarmId.intValue())).collect(Collectors.toSet());
        Set alarmIdsToUpdate = Sets.intersection(alarmIdsInWorkingMem, alarmIdsInDb).stream().filter(alarmId -> {
            AlarmAndFact alarmAndFact = this.alarmsById.get(alarmId);
            if (this.stateTracker.wasAlarmWithIdUpdated(alarmId.intValue())) {
                return false;
            }
            OnmsAlarm alarmInMem = alarmAndFact.getAlarm();
            OnmsAlarm alarmInDb = (OnmsAlarm)alarmsInDbById.get(alarmId);
            return DroolsAlarmContext.shouldUpdateAlarmForSnapshot(alarmInMem, alarmInDb);
        }).collect(Collectors.toSet());
        if (LOG.isDebugEnabled()) {
            if (!(alarmIdsToAdd.isEmpty() && alarmIdsToRemove.isEmpty() && alarmIdsToUpdate.isEmpty())) {
                LOG.debug("Adding {} alarms, removing {} alarms and updating {} alarms for snapshot.", new Object[]{alarmIdsToAdd.size(), alarmIdsToRemove.size(), alarmIdsToUpdate.size()});
            } else {
                LOG.debug("No actions to perform for alarm snapshot.");
            }
            if (LOG.isTraceEnabled()) {
                for (Integer alarmIdToUpdate : alarmIdsToUpdate) {
                    LOG.trace("Updating alarm with id={}. Alarm from DB: {} vs Alarm from memory: {}", new Object[]{alarmIdToUpdate, alarmsInDbById.get(alarmIdToUpdate), this.alarmsById.get(alarmIdToUpdate)});
                }
            }
        }
        for (Integer alarmIdToRemove : alarmIdsToRemove) {
            this.handleDeletedAlarmNoLock(alarmIdToRemove, this.alarmsById.get(alarmIdToRemove).getAlarm().getReductionKey());
        }
        this.handleNewOrUpdatedAlarms(Sets.union(alarmIdsToAdd, alarmIdsToUpdate).stream().map(alarmsInDbById::get).collect(Collectors.toSet()));
        LOG.debug("Done handling snapshot.");
    }

    public void postHandleAlarmSnapshot() {
        this.stateTracker.resetStateAndStopTrackingAlarms();
        ReentrantLock lock = this.getLock();
        if (lock.isHeldByCurrentThread()) {
            lock.unlock();
        }
    }

    protected static boolean shouldUpdateAlarmForSnapshot(OnmsAlarm alarmInMem, OnmsAlarm alarmInDb) {
        return !Objects.equals(alarmInMem.getLastEventTime(), alarmInDb.getLastEventTime()) || !Objects.equals(alarmInMem.getAckTime(), alarmInDb.getAckTime());
    }

    public void handleNewOrUpdatedAlarm(OnmsAlarm alarm) {
        if (!this.isStarted()) {
            LOG.debug("Ignoring new/updated alarm. Drools session is stopped.");
            return;
        }
        this.tryWithLock(alarm.getId(), alarm.getReductionKey(), (id, rkey) -> this.handleNewOrUpdatedAlarms(Collections.singleton(alarm)), "Add or update");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryWithLock(int alarmId, String reductionKey, BiConsumer<Integer, String> callback, String action) {
        block6: {
            try {
                if (this.getLock().tryLock(LOCK_TIMEOUT_MS, TimeUnit.MILLISECONDS)) {
                    try {
                        callback.accept(alarmId, reductionKey);
                        break block6;
                    }
                    finally {
                        this.getLock().unlock();
                    }
                }
                LOG.warn("Failed to acquire Drools session lock within {}ms. {} for alarm with id={} and reduction-key={} will not be immediately reflected in the context.", new Object[]{LOCK_TIMEOUT_MS, action, alarmId, reductionKey});
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for Drools session lock. {} for alarm with id={} and reduction-key={} will not be immediately reflected in the context.", new Object[]{action, alarmId, reductionKey});
                Thread.currentThread().interrupt();
            }
        }
    }

    private Map<Integer, OnmsAcknowledgment> fetchAcks(Set<OnmsAlarm> alarms) {
        HashSet acks = new HashSet();
        if (alarms.size() == 1) {
            this.acknowledgmentDao.findLatestAckForRefId(alarms.iterator().next().getId()).ifPresent(acks::add);
        } else {
            Date earliestAlarm = alarms.stream().map(OnmsAlarm::getFirstEventTime).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElseGet(() -> {
                LocalDateTime oneMonthAgoLdt = LocalDateTime.now().minusMonths(1L);
                Date oneMonthAgo = Date.from(oneMonthAgoLdt.atZone(ZoneId.systemDefault()).toInstant());
                LOG.error("Could not find minimum alarm creation time for alarms: {}. Using: {}", (Object)alarms, (Object)oneMonthAgo);
                return oneMonthAgo;
            });
            acks.addAll(this.acknowledgmentDao.findLatestAcks(earliestAlarm));
        }
        Map<Integer, OnmsAcknowledgment> acksById = acks.stream().collect(Collectors.toMap(OnmsAcknowledgment::getRefId, ack -> ack));
        acksById.putAll(alarms.stream().filter(alarm -> !acksById.containsKey(alarm.getId())).collect(Collectors.toMap(OnmsAlarm::getId, alarm -> {
            OnmsAcknowledgment ack = new OnmsAcknowledgment((Acknowledgeable)alarm, "admin", alarm.getFirstEventTime());
            ack.setAckAction(AckAction.UNACKNOWLEDGE);
            ack.setId(Integer.valueOf(0));
            return ack;
        })));
        return acksById;
    }

    private void handleNewOrUpdatedAlarms(Set<OnmsAlarm> alarms) {
        if (alarms.isEmpty()) {
            return;
        }
        Map<Integer, OnmsAcknowledgment> acksByRefId = this.fetchAcks(alarms);
        for (OnmsAlarm alarm : alarms) {
            this.handleNewOrUpdatedAlarmNoLock(alarm);
            this.handleAlarmAcknowledgements(alarm, acksByRefId.get(alarm.getId()));
        }
    }

    private void handleNewOrUpdatedAlarmNoLock(OnmsAlarm alarm) {
        AlarmAndFact alarmAndFact;
        KieSession kieSession = this.getKieSession();
        Hibernate.initialize((Object)alarm.getAssociatedAlarms());
        if (alarm.getLastEvent() != null) {
            Hibernate.initialize((Object)alarm.getLastEvent().getEventParameters());
        }
        if (alarm.getNode() != null) {
            Hibernate.initialize((Object)alarm.getNode().getCategories());
        }
        if ((alarmAndFact = this.alarmsById.get(alarm.getId())) == null) {
            LOG.debug("Inserting alarm into session: {}", (Object)alarm);
            FactHandle fact = this.getKieSession().insert((Object)alarm);
            this.alarmsById.put(alarm.getId(), new AlarmAndFact(alarm, fact));
        } else {
            LOG.trace("Deleting alarm from session (for re-insertion): {}", (Object)alarm);
            kieSession.delete(alarmAndFact.getFact());
            LOG.trace("Re-inserting alarm into session: {}", (Object)alarm);
            FactHandle fact = kieSession.insert((Object)alarm);
            this.alarmsById.put(alarm.getId(), new AlarmAndFact(alarm, fact));
        }
        this.handleRelatedAlarms(alarm);
        this.stateTracker.trackNewOrUpdatedAlarm(alarm.getId().intValue(), alarm.getReductionKey());
    }

    public void handleDeletedAlarm(int alarmId, String reductionKey) {
        if (!this.isStarted()) {
            LOG.debug("Ignoring deleted alarm. Drools session is stopped.");
            return;
        }
        this.tryWithLock(alarmId, reductionKey, (id, rkey) -> this.handleDeletedAlarmNoLock(alarmId, reductionKey), "Delete");
    }

    private void handleRelatedAlarms(OnmsAlarm situation) {
        if (!situation.isSituation()) {
            return;
        }
        Map associationFacts = this.alarmAssociationById.computeIfAbsent(situation.getId(), sid -> new HashMap());
        for (AlarmAssociation association : situation.getAssociatedAlarms()) {
            FactHandle fact2;
            Integer alarmId2 = association.getRelatedAlarm().getId();
            AlarmAssociationAndFact assocationFact = (AlarmAssociationAndFact)associationFacts.get(alarmId2);
            if (assocationFact == null) {
                LOG.debug("Inserting alarm association into session: {}", (Object)association);
                fact2 = this.getKieSession().insert((Object)association);
                associationFacts.put(alarmId2, new AlarmAssociationAndFact(association, fact2));
                continue;
            }
            fact2 = assocationFact.getFact();
            LOG.trace("Updating alarm assocation in session: {}", (Object)assocationFact);
            this.getKieSession().update(fact2, (Object)association);
            associationFacts.put(alarmId2, new AlarmAssociationAndFact(association, fact2));
        }
        Set<Integer> deletedAlarmIds = associationFacts.values().stream().map(fact -> fact.getAlarmAssociation().getRelatedAlarm().getId()).filter(alarmId -> !situation.getRelatedAlarmIds().contains(alarmId)).collect(Collectors.toSet());
        deletedAlarmIds.forEach(alarmId -> {
            AlarmAssociationAndFact associationAndFact = (AlarmAssociationAndFact)associationFacts.remove(alarmId);
            if (associationAndFact != null) {
                LOG.debug("Deleting AlarmAssociationAndFact from session: {}", (Object)associationAndFact.getAlarmAssociation());
                this.getKieSession().delete(associationAndFact.getFact());
            }
        });
    }

    private void handleAlarmAcknowledgements(OnmsAlarm alarm, OnmsAcknowledgment ack) {
        AlarmAcknowledgementAndFact acknowledgmentFact = this.acknowledgementsByAlarmId.get(alarm.getId());
        if (acknowledgmentFact == null) {
            LOG.debug("Inserting first alarm acknowledgement into session: {}", (Object)ack);
            FactHandle fact = this.getKieSession().insert((Object)ack);
            this.acknowledgementsByAlarmId.put(alarm.getId(), new AlarmAcknowledgementAndFact(ack, fact));
        } else {
            FactHandle fact = acknowledgmentFact.getFact();
            LOG.trace("Updating acknowledgment in session: {}", (Object)ack);
            this.getKieSession().update(fact, (Object)ack);
            this.acknowledgementsByAlarmId.put(alarm.getId(), new AlarmAcknowledgementAndFact(ack, fact));
        }
    }

    private void handleDeletedAlarmNoLock(int alarmId, String reductionKey) {
        AlarmAndFact alarmAndFact = this.alarmsById.remove(alarmId);
        if (alarmAndFact != null) {
            LOG.debug("Deleting alarm from session: {}", (Object)alarmAndFact.getAlarm());
            this.getKieSession().delete(alarmAndFact.getFact());
        }
        this.deleteAlarmAcknowledgement(alarmId);
        this.deleteAlarmAssociations(alarmId);
        this.stateTracker.trackDeletedAlarm(alarmId, reductionKey);
    }

    private void deleteAlarmAcknowledgement(int alarmId) {
        AlarmAcknowledgementAndFact acknowledgmentFact = this.acknowledgementsByAlarmId.remove(alarmId);
        if (acknowledgmentFact != null) {
            LOG.debug("Deleting ack from session: {}", (Object)acknowledgmentFact.getAcknowledgement());
            this.getKieSession().delete(acknowledgmentFact.getFact());
        }
    }

    private void deleteAlarmAssociations(int alarmId) {
        Map<Integer, AlarmAssociationAndFact> associationFacts = this.alarmAssociationById.remove(alarmId);
        if (associationFacts == null) {
            return;
        }
        for (Integer association : associationFacts.keySet()) {
            AlarmAssociationAndFact assocationFact = associationFacts.get(association);
            if (assocationFact == null) continue;
            LOG.debug("Deleting association from session: {}", (Object)assocationFact.getAlarmAssociation());
            this.getKieSession().delete(assocationFact.getFact());
        }
    }

    public void setAlarmService(AlarmService alarmService) {
        this.alarmService = alarmService;
    }

    public void setAcknowledgmentDao(AcknowledgmentDao acknowledgmentDao) {
        this.acknowledgmentDao = acknowledgmentDao;
    }

    public void setAlarmTicketerService(AlarmTicketerService alarmTicketerService) {
        this.alarmTicketerService = alarmTicketerService;
    }

    @VisibleForTesting
    OnmsAcknowledgment getAckByAlarmId(Integer id) {
        return this.acknowledgementsByAlarmId.get(id).getAcknowledgement();
    }

    public void setTransactionTemplate(TransactionTemplate template) {
        this.template = template;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.alarmDao = alarmDao;
    }
}

