/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd;

import org.opennms.core.sysprops.SystemProperties;
import org.opennms.netmgt.alarmd.AlarmLifecycleListenerManager;
import org.opennms.netmgt.alarmd.AlarmPersister;
import org.opennms.netmgt.alarmd.NorthbounderManager;
import org.opennms.netmgt.alarmd.drools.DroolsAlarmContext;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.daemon.DaemonTools;
import org.opennms.netmgt.events.api.ThreadAwareEventListener;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@EventListener(name="alarmd", logPrefix="alarmd")
public class Alarmd
extends AbstractServiceDaemon
implements ThreadAwareEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(Alarmd.class);
    public static final String NAME = "alarmd";
    protected static final Integer THREADS = SystemProperties.getInteger((String)"org.opennms.alarmd.threads", (int)4);
    private AlarmPersister m_persister;
    @Autowired
    private AlarmLifecycleListenerManager m_alm;
    @Autowired
    private DroolsAlarmContext m_droolsAlarmContext;
    @Autowired
    private NorthbounderManager m_northbounderManager;

    public Alarmd() {
        super(NAME);
    }

    @EventHandler(uei="*")
    public void onEvent(Event e) {
        if (e.getUei().equals("uei.opennms.org/internal/reloadDaemonConfig")) {
            this.handleReloadEvent(e);
            return;
        }
        this.m_persister.persist(e);
    }

    private synchronized void handleReloadEvent(Event e) {
        this.m_northbounderManager.handleReloadEvent(e);
        DaemonTools.handleReloadEvent((Event)e, (String)NAME, event -> this.onAlarmReload());
    }

    private void onAlarmReload() {
        this.m_droolsAlarmContext.reload();
    }

    public void setPersister(AlarmPersister persister) {
        this.m_persister = persister;
    }

    public AlarmPersister getPersister() {
        return this.m_persister;
    }

    protected synchronized void onInit() {
    }

    public synchronized void onStart() {
        this.m_droolsAlarmContext.start();
    }

    public synchronized void onStop() {
        this.m_northbounderManager.stop();
        this.m_droolsAlarmContext.stop();
    }

    public int getNumThreads() {
        return THREADS;
    }
}

