/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd;

import java.io.Serializable;
import org.hibernate.Hibernate;
import org.opennms.netmgt.alarmd.AlarmPersister;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.UpdateField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.util.Assert;

public class AlarmPersisterImpl
implements AlarmPersister {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmPersisterImpl.class);
    private AlarmDao m_alarmDao;
    private EventDao m_eventDao;
    private EventForwarder m_eventForwarder;
    private TransactionOperations m_transactionOperations;

    @Override
    public OnmsAlarm persist(final Event event) {
        if (!AlarmPersisterImpl.checkEventSanityAndDoWeProcess(event)) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("process: {}; nodeid: {}; ipaddr: {}; serviceid: {}", new Object[]{event.getUei(), event.getNodeid(), event.getInterface(), event.getService()});
        }
        OnmsAlarmAndLifecycleEvent alarmAndEvent = (OnmsAlarmAndLifecycleEvent)this.m_transactionOperations.execute((TransactionCallback)new TransactionCallback<OnmsAlarmAndLifecycleEvent>(){

            public OnmsAlarmAndLifecycleEvent doInTransaction(TransactionStatus arg0) {
                return AlarmPersisterImpl.this.addOrReduceEventAsAlarm(event);
            }
        });
        this.m_eventForwarder.sendNow(alarmAndEvent.getEvent());
        return alarmAndEvent.getAlarm();
    }

    private OnmsAlarmAndLifecycleEvent addOrReduceEventAsAlarm(Event event) {
        OnmsEvent e = (OnmsEvent)this.m_eventDao.get((Serializable)event.getDbid());
        Assert.notNull((Object)e, (String)"Event was deleted before we could retrieve it and create an alarm.");
        String reductionKey = event.getAlarmData().getReductionKey();
        LOG.debug("addOrReduceEventAsAlarm: looking for existing reduction key: {}", (Object)reductionKey);
        OnmsAlarm alarm = this.m_alarmDao.findByReductionKey(reductionKey);
        EventBuilder ebldr = null;
        if (alarm == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("addOrReduceEventAsAlarm: reductionKey:{} not found, instantiating new alarm", (Object)reductionKey);
            }
            alarm = AlarmPersisterImpl.createNewAlarm(e, event);
            this.m_alarmDao.save((Object)alarm);
            this.m_eventDao.saveOrUpdate((Object)e);
            ebldr = new EventBuilder("uei.opennms.org/alarms/alarmCreated", "Alarmd");
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("addOrReduceEventAsAlarm: reductionKey:{} found, reducing event to existing alarm: {}", (Object)reductionKey, (Object)alarm.getIpAddr());
            }
            AlarmPersisterImpl.reduceEvent(e, alarm, event);
            this.m_alarmDao.update((Object)alarm);
            this.m_eventDao.update((Object)e);
            if (event.getAlarmData().isAutoClean().booleanValue()) {
                this.m_eventDao.deletePreviousEventsForAlarm(alarm.getId(), e);
            }
            ebldr = new EventBuilder("uei.opennms.org/alarms/alarmUpdatedWithReducedEvent", "Alarmd");
        }
        if (alarm.getNodeId() != null) {
            alarm.getNode().getForeignSource();
        }
        ebldr.addParam("alarmUei", alarm.getUei());
        ebldr.addParam("alarmId", alarm.getId().intValue());
        Hibernate.initialize((Object)alarm.getEventParameters());
        return new OnmsAlarmAndLifecycleEvent(alarm, ebldr.getEvent());
    }

    private static void reduceEvent(OnmsEvent e, OnmsAlarm alarm, Event event) {
        alarm.setLastEvent(e);
        alarm.setLastEventTime(e.getEventTime());
        alarm.setCounter(Integer.valueOf(alarm.getCounter() + 1));
        if (!event.getAlarmData().hasUpdateFields().booleanValue()) {
            alarm.setLogMsg(e.getEventLogMsg());
        } else {
            for (UpdateField field : event.getAlarmData().getUpdateFieldList()) {
                String fieldName = field.getFieldName();
                if (fieldName.equalsIgnoreCase("LogMsg") && !field.isUpdateOnReduction().booleanValue()) continue;
                alarm.setLogMsg(e.getEventLogMsg());
                if (!field.isUpdateOnReduction().booleanValue()) continue;
                if (fieldName.toLowerCase().startsWith("distpoller")) {
                    alarm.setDistPoller(e.getDistPoller());
                    continue;
                }
                if (fieldName.toLowerCase().startsWith("ipaddr")) {
                    alarm.setIpAddr(e.getIpAddr());
                    continue;
                }
                if (fieldName.toLowerCase().startsWith("mouseover")) {
                    alarm.setMouseOverText(e.getEventMouseOverText());
                    continue;
                }
                if (fieldName.toLowerCase().startsWith("operinstruct")) {
                    alarm.setOperInstruct(e.getEventOperInstruct());
                    continue;
                }
                if (fieldName.equalsIgnoreCase("severity")) {
                    alarm.setSeverity(OnmsSeverity.valueOf((String)e.getSeverityLabel()));
                    continue;
                }
                if (fieldName.toLowerCase().contains("descr")) {
                    alarm.setDescription(e.getEventDescr());
                    alarm.setSeverity(OnmsSeverity.valueOf((String)e.getSeverityLabel()));
                    continue;
                }
                LOG.warn("reduceEvent: The specified field: {}, is not supported.", (Object)fieldName);
            }
        }
        e.setAlarm(alarm);
    }

    private static OnmsAlarm createNewAlarm(OnmsEvent e, Event event) {
        if (e.getServiceType() != null) {
            e.getServiceType().getName();
        }
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setAlarmType(event.getAlarmData().getAlarmType());
        alarm.setClearKey(event.getAlarmData().getClearKey());
        alarm.setCounter(Integer.valueOf(1));
        alarm.setDescription(e.getEventDescr());
        alarm.setDistPoller(e.getDistPoller());
        alarm.setFirstEventTime(e.getEventTime());
        alarm.setIfIndex(e.getIfIndex());
        alarm.setIpAddr(e.getIpAddr());
        alarm.setLastEventTime(e.getEventTime());
        alarm.setLastEvent(e);
        alarm.setLogMsg(e.getEventLogMsg());
        alarm.setMouseOverText(e.getEventMouseOverText());
        alarm.setNode(e.getNode());
        alarm.setOperInstruct(e.getEventOperInstruct());
        alarm.setReductionKey(event.getAlarmData().getReductionKey());
        alarm.setServiceType(e.getServiceType());
        alarm.setSeverity(OnmsSeverity.get((int)e.getEventSeverity()));
        alarm.setSuppressedUntil(e.getEventTime());
        alarm.setSuppressedTime(e.getEventTime());
        alarm.setUei(e.getEventUei());
        e.setAlarm(alarm);
        return alarm;
    }

    private static boolean checkEventSanityAndDoWeProcess(Event event) {
        Assert.notNull((Object)event, (String)"Incoming event was null, aborting");
        if (event.getLogmsg() != null && "donotpersist".equals(event.getLogmsg().getDest())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("checkEventSanity: uei '{}' marked as 'donotpersist'; not processing event.", (Object)event.getUei());
            }
            return false;
        }
        if (event.getAlarmData() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("checkEventSanity: uei '{}' has no alarm data; not processing event.", (Object)event.getUei());
            }
            return false;
        }
        Assert.isTrue((event.getDbid() > 0 ? 1 : 0) != 0, (String)("Incoming event has an illegal dbid (" + event.getDbid() + "), aborting"));
        return true;
    }

    public TransactionOperations getTransactionOperations() {
        return this.m_transactionOperations;
    }

    public void setTransactionOperations(TransactionOperations transactionOperations) {
        this.m_transactionOperations = transactionOperations;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public AlarmDao getAlarmDao() {
        return this.m_alarmDao;
    }

    public void setEventDao(EventDao eventDao) {
        this.m_eventDao = eventDao;
    }

    public EventDao getEventDao() {
        return this.m_eventDao;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    private static class OnmsAlarmAndLifecycleEvent {
        private final OnmsAlarm m_alarm;
        private final Event m_event;

        public OnmsAlarmAndLifecycleEvent(OnmsAlarm alarm, Event event) {
            this.m_alarm = alarm;
            this.m_event = event;
        }

        public OnmsAlarm getAlarm() {
            return this.m_alarm;
        }

        public Event getEvent() {
            return this.m_event;
        }
    }
}

