/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd;

import java.io.Serializable;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.alarmd.AlarmPersister;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.EventDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class AlarmPersisterImpl
implements AlarmPersister {
    private AlarmDao m_alarmDao;
    private EventDao m_eventDao;

    public void persist(Event event) {
        if (!this.checkEventSanityAndDoWeProcess(event)) {
            return;
        }
        this.log().debug((Object)("process: " + event.getUei() + " nodeid: " + event.getNodeid() + " ipaddr: " + event.getInterface() + " serviceid: " + event.getService()));
        this.addOrReduceEventAsAlarm(event);
    }

    @Transactional
    private void addOrReduceEventAsAlarm(Event event) {
        OnmsEvent e = (OnmsEvent)this.m_eventDao.get((Serializable)Integer.valueOf(event.getDbid()));
        Assert.notNull((Object)e, (String)"Event was deleted before we could retrieve it and create an alarm.");
        OnmsAlarm alarm = this.m_alarmDao.findByReductionKey(event.getAlarmData().getReductionKey());
        if (alarm == null) {
            alarm = this.createNewAlarm(e, event);
            this.m_alarmDao.save((Object)alarm);
            this.m_eventDao.saveOrUpdate((Object)e);
        } else {
            this.reduceEvent(e, alarm);
            this.m_alarmDao.update((Object)alarm);
            this.m_eventDao.update((Object)e);
            if (event.getAlarmData().isAutoClean()) {
                this.m_eventDao.deletePreviousEventsForAlarm(alarm.getId(), e);
            }
        }
    }

    private void reduceEvent(OnmsEvent e, OnmsAlarm alarm) {
        alarm.setLastEvent(e);
        alarm.setLastEventTime(e.getEventTime());
        alarm.setLogMsg(e.getEventLogMsg());
        alarm.setCounter(Integer.valueOf(alarm.getCounter() + 1));
        e.setAlarm(alarm);
    }

    private OnmsAlarm createNewAlarm(OnmsEvent e, Event event) {
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setAlarmType(Integer.valueOf(event.getAlarmData().getAlarmType()));
        alarm.setClearKey(event.getAlarmData().getClearKey());
        alarm.setClearUei(event.getAlarmData().getClearUei());
        alarm.setCounter(Integer.valueOf(1));
        alarm.setDescription(e.getEventDescr());
        alarm.setDistPoller(e.getDistPoller());
        alarm.setEventParms(e.getEventParms());
        alarm.setFirstEventTime(e.getEventTime());
        alarm.setIfIndex(e.getIfIndex());
        alarm.setIpAddr(e.getIpAddr());
        alarm.setLastEventTime(e.getEventTime());
        alarm.setLastEvent(e);
        alarm.setLogMsg(e.getEventLogMsg());
        alarm.setMouseOverText(e.getEventMouseOverText());
        alarm.setNode(e.getNode());
        alarm.setOperInstruct(e.getEventOperInstruct());
        alarm.setReductionKey(event.getAlarmData().getReductionKey());
        alarm.setServiceType(e.getServiceType());
        alarm.setSeverity(OnmsSeverity.get((int)e.getEventSeverity()));
        alarm.setSeverityId(e.getEventSeverity());
        alarm.setSuppressedUntil(e.getEventTime());
        alarm.setSuppressedTime(e.getEventTime());
        alarm.setUei(e.getEventUei());
        e.setAlarm(alarm);
        return alarm;
    }

    private boolean checkEventSanityAndDoWeProcess(Event event) {
        Assert.notNull((Object)event, (String)"event argument must not be null");
        Assert.notNull((Object)event.getLogmsg(), (String)"event does not have a logmsg");
        Assert.notNull((Object)event.getLogmsg().getDest(), (String)"event logmsg does not have a destination");
        if ("donotpersist".equals(event.getLogmsg().getDest())) {
            this.log().debug((Object)("checkEventSanity: uei '" + event.getUei() + "' marked as 'donotpersist'; not processing event."));
            return false;
        }
        if (event.getAlarmData() == null) {
            this.log().debug((Object)("checkEventSanity: uei '" + event.getUei() + "' has no alarm data'; not processing event."));
            return false;
        }
        return true;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public AlarmDao getAlarmDao() {
        return this.m_alarmDao;
    }

    public void setEventDao(EventDao eventDao) {
        this.m_eventDao = eventDao;
    }

    public EventDao getEventDao() {
        return this.m_eventDao;
    }
}

