/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd;

import java.util.List;
import java.util.Map;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.alarmd.AlarmPersister;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.Northbounder;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.springframework.beans.factory.DisposableBean;

@EventListener(name="Alarmd")
public class Alarmd
implements SpringServiceDaemon,
DisposableBean {
    public static final String NAME = "Alarmd";
    private EventForwarder m_eventForwarder;
    private List<Northbounder> m_northboundInterfaces;
    private AlarmPersister m_persister;

    @EventHandler(uei="*")
    public void onEvent(Event e) {
        if (e.getUei().equals("uei.opennms.org/internal/reloadDaemonConfig")) {
            return;
        }
        OnmsAlarm alarm = this.m_persister.persist(e);
        if (alarm != null) {
            NorthboundAlarm a = new NorthboundAlarm(alarm);
            for (Northbounder nbi : this.m_northboundInterfaces) {
                nbi.onAlarm(a);
            }
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    private void handleReloadEvent(Event e) {
        LogUtils.infof((Object)this, (String)"Received reload configuration event: %s", (Object[])new Object[]{e});
        List parmCollection = e.getParmCollection();
        for (Parm parm : parmCollection) {
            String parmName = parm.getParmName();
            if (!"daemonName".equals(parmName)) continue;
            if (parm.getValue() == null || parm.getValue().getContent() == null) {
                LogUtils.warnf((Object)this, (String)"The daemonName parameter has no value, ignoring.", (Object[])new Object[0]);
                return;
            }
            List<Northbounder> nbis = this.getNorthboundInterfaces();
            for (Northbounder nbi : nbis) {
                if (!parm.getValue().getContent().contains(nbi.getName())) continue;
                LogUtils.debugf((Object)this, (String)"Handling reload event for NBI: %s", (Object[])new Object[]{nbi.getName()});
                LogUtils.debugf((Object)this, (String)"Reloading NBI configuration not yet implemented.", (Object[])new Object[]{nbi.getName()});
                return;
            }
        }
    }

    public void setPersister(AlarmPersister persister) {
        this.m_persister = persister;
    }

    public AlarmPersister getPersister() {
        return this.m_persister;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getNorthboundInterfaces() != null) {
            for (Northbounder nb : this.getNorthboundInterfaces()) {
                nb.start();
            }
        }
    }

    public void destroy() throws Exception {
    }

    public String getName() {
        return NAME;
    }

    public void start() throws Exception {
    }

    public void onNorthbounderRegistered(Northbounder northbounder, Map<String, String> properties) {
        northbounder.start();
    }

    public void onNorthbounderUnregistered(Northbounder northbounder, Map<String, String> properties) {
        northbounder.stop();
    }

    public List<Northbounder> getNorthboundInterfaces() {
        return this.m_northboundInterfaces;
    }

    public void setNorthboundInterfaces(List<Northbounder> northboundInterfaces) {
        this.m_northboundInterfaces = northboundInterfaces;
    }
}

