/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd;

import java.io.Serializable;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.alarmd.AlarmPersister;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.EventDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.util.Assert;

public class AlarmPersisterImpl
implements AlarmPersister {
    private AlarmDao m_alarmDao;
    private EventDao m_eventDao;

    @Override
    public OnmsAlarm persist(Event event) {
        if (!AlarmPersisterImpl.checkEventSanityAndDoWeProcess(event)) {
            return null;
        }
        AlarmPersisterImpl.log().debug("process: " + event.getUei() + " nodeid: " + event.getNodeid() + " ipaddr: " + event.getInterface() + " serviceid: " + event.getService());
        return this.addOrReduceEventAsAlarm(event);
    }

    private OnmsAlarm addOrReduceEventAsAlarm(Event event) {
        Assert.notNull((Object)event, (String)"Incoming event was null, aborting");
        Assert.isTrue((event.getDbid() > 0 ? 1 : 0) != 0, (String)("Incoming event has an illegal dbid (" + event.getDbid() + "), aborting"));
        OnmsEvent e = (OnmsEvent)this.m_eventDao.get((Serializable)event.getDbid());
        Assert.notNull((Object)e, (String)"Event was deleted before we could retrieve it and create an alarm.");
        String reductionKey = event.getAlarmData().getReductionKey();
        AlarmPersisterImpl.log().debug("addOrReduceEventAsAlarm: looking for existing reduction key: " + reductionKey);
        OnmsAlarm alarm = this.m_alarmDao.findByReductionKey(reductionKey);
        if (alarm == null) {
            AlarmPersisterImpl.log().debug("addOrReduceEventAsAlarm: reductionKey:" + reductionKey + " not found, instantiating new alarm");
            alarm = AlarmPersisterImpl.createNewAlarm(e, event);
            this.m_alarmDao.save((Object)alarm);
            this.m_eventDao.saveOrUpdate((Object)e);
        } else {
            AlarmPersisterImpl.log().debug("addOrReduceEventAsAlarm: reductionKey:" + reductionKey + " found, reducing event to existing alarm: " + alarm.getIpAddr());
            AlarmPersisterImpl.reduceEvent(e, alarm);
            this.m_alarmDao.update((Object)alarm);
            this.m_eventDao.update((Object)e);
            if (event.getAlarmData().isAutoClean().booleanValue()) {
                this.m_eventDao.deletePreviousEventsForAlarm(alarm.getId(), e);
            }
        }
        return alarm;
    }

    private static void reduceEvent(OnmsEvent e, OnmsAlarm alarm) {
        alarm.setLastEvent(e);
        alarm.setLastEventTime(e.getEventTime());
        alarm.setLogMsg(e.getEventLogMsg());
        alarm.setEventParms(e.getEventParms());
        alarm.setCounter(Integer.valueOf(alarm.getCounter() + 1));
        e.setAlarm(alarm);
    }

    private static OnmsAlarm createNewAlarm(OnmsEvent e, Event event) {
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setAlarmType(event.getAlarmData().getAlarmType());
        alarm.setClearKey(event.getAlarmData().getClearKey());
        alarm.setCounter(Integer.valueOf(1));
        alarm.setDescription(e.getEventDescr());
        alarm.setDistPoller(e.getDistPoller());
        alarm.setEventParms(e.getEventParms());
        alarm.setFirstEventTime(e.getEventTime());
        alarm.setIfIndex(e.getIfIndex());
        alarm.setIpAddr(e.getIpAddr());
        alarm.setLastEventTime(e.getEventTime());
        alarm.setLastEvent(e);
        alarm.setLogMsg(e.getEventLogMsg());
        alarm.setMouseOverText(e.getEventMouseOverText());
        alarm.setNode(e.getNode());
        alarm.setOperInstruct(e.getEventOperInstruct());
        alarm.setReductionKey(event.getAlarmData().getReductionKey());
        alarm.setServiceType(e.getServiceType());
        alarm.setSeverity(OnmsSeverity.get((int)e.getEventSeverity()));
        alarm.setSuppressedUntil(e.getEventTime());
        alarm.setSuppressedTime(e.getEventTime());
        alarm.setUei(e.getEventUei());
        e.setAlarm(alarm);
        return alarm;
    }

    private static boolean checkEventSanityAndDoWeProcess(Event event) {
        Assert.notNull((Object)event, (String)"event argument must not be null");
        if (event.getLogmsg() != null && event.getLogmsg().getDest() != null && "donotpersist".equals(event.getLogmsg().getDest())) {
            AlarmPersisterImpl.log().debug("checkEventSanity: uei '" + event.getUei() + "' marked as 'donotpersist'; not processing event.");
            return false;
        }
        if (event.getAlarmData() == null) {
            AlarmPersisterImpl.log().debug("checkEventSanity: uei '" + event.getUei() + "' has no alarm data; not processing event.");
            return false;
        }
        return true;
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(AlarmPersisterImpl.class);
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public AlarmDao getAlarmDao() {
        return this.m_alarmDao;
    }

    public void setEventDao(EventDao eventDao) {
        this.m_eventDao = eventDao;
    }

    public EventDao getEventDao() {
        return this.m_eventDao;
    }
}

