/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.snmptrap;

import java.util.HashMap;
import java.util.Map;
import org.opennms.core.soa.Registration;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.Northbounder;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapNorthbounder;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapNorthbounderConfigDao;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapSink;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class SnmpTrapNorthbounderManager
implements InitializingBean,
Northbounder,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpTrapNorthbounderManager.class);
    @Autowired
    private ServiceRegistry m_serviceRegistry;
    @Autowired
    private SnmpTrapNorthbounderConfigDao m_configDao;
    private Map<String, Registration> m_registrations = new HashMap<String, Registration>();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)((Object)this.m_configDao));
        Assert.notNull((Object)this.m_serviceRegistry);
        SnmpPeerFactory.init();
        this.m_registrations.put(this.getName(), this.m_serviceRegistry.register((Object)this, new Class[]{Northbounder.class}));
        this.registerNorthnounders();
    }

    private void registerNorthnounders() throws Exception {
        if (!this.m_configDao.getConfig().isEnabled().booleanValue()) {
            LOG.warn("The SNMP Trap NBI is globally disabled, the destinations won't be registered which means all the alarms will be rejected.");
            return;
        }
        for (SnmpTrapSink sink : this.m_configDao.getConfig().getSnmpTrapSinks()) {
            LOG.info("Registering SNMP Trap northbound configuration for sink {}.", (Object)sink.getName());
            SnmpTrapNorthbounder nbi = new SnmpTrapNorthbounder(this.m_configDao, sink.getName());
            nbi.afterPropertiesSet();
            this.m_registrations.put(nbi.getName(), this.m_serviceRegistry.register((Object)nbi, new Class[]{Northbounder.class}));
        }
    }

    public void destroy() throws Exception {
        this.m_registrations.values().forEach(Registration::unregister);
    }

    public void start() throws NorthbounderException {
    }

    public boolean isReady() {
        return false;
    }

    public void onAlarm(NorthboundAlarm alarm) throws NorthbounderException {
    }

    public void stop() throws NorthbounderException {
    }

    public String getName() {
        return "SnmpTrapNBI";
    }

    public void reloadConfig() throws NorthbounderException {
        LOG.info("Reloading SNMP Traps northbound configuration.");
        try {
            this.m_configDao.reload();
            this.m_registrations.forEach((k, v) -> {
                if (k != this.getName()) {
                    v.unregister();
                }
            });
            this.registerNorthnounders();
        }
        catch (Exception e) {
            throw new NorthbounderException("Can't reload the SNMP trap northbound configuration", (Throwable)e);
        }
    }
}

