/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.jms;

import java.util.List;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Session;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.api.support.AbstractNorthbounder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class JmsNorthbounder
extends AbstractNorthbounder
implements InitializingBean {
    @Autowired
    private JmsTemplate m_template;
    @Autowired
    private ConnectionFactory m_connectionFactory;
    private Queue m_queue;

    protected JmsNorthbounder() {
        super("JmsNorthbounder");
    }

    public boolean accepts(NorthboundAlarm alarm) {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)((Object)this));
    }

    public void forwardAlarms(List<NorthboundAlarm> alarms) throws NorthbounderException {
        for (final NorthboundAlarm alarm : alarms) {
            this.m_template.convertAndSend((Object)alarm);
        }
        for (final NorthboundAlarm alarm : alarms) {
            this.m_template.send((Destination)this.m_queue, new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    return session.createTextMessage(JmsNorthbounder.this.convertAlarmToXml(alarm));
                }
            });
        }
    }

    protected String convertAlarmToXml(NorthboundAlarm alarm) {
        return "This is a test alarm.";
    }

    public void onPreStart() throws NorthbounderException {
        this.m_template = new JmsTemplate(this.m_connectionFactory);
    }
}

