/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.opennms.core.utils.EmptyKeyRelaxedTrustProvider;
import org.opennms.core.utils.HttpResponseRange;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.api.support.AbstractNorthbounder;
import org.opennms.netmgt.alarmd.northbounder.http.HttpNorthbounderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpNorthbounder
extends AbstractNorthbounder {
    private static final Logger LOG = LoggerFactory.getLogger(HttpNorthbounder.class);
    private HttpNorthbounderConfig m_config;

    protected HttpNorthbounder() {
        super("HttpNorthbounder");
    }

    public boolean accepts(NorthboundAlarm alarm) {
        return this.m_config.getAcceptableUeis() == null || this.m_config.getAcceptableUeis().contains(alarm.getUei());
    }

    public void forwardAlarms(List<NorthboundAlarm> alarms) throws NorthbounderException {
        int code;
        HttpResponseRange range;
        LOG.info("Forwarding {} alarms", (Object)alarms.size());
        int connectionTimeout = 3000;
        int socketTimeout = 3000;
        Integer retryCount = 3;
        HttpVersion httpVersion = HttpNorthbounder.determineHttpVersion(this.m_config.getHttpVersion());
        String policy = "compatibility";
        URI uri = this.m_config.getURI();
        DefaultHttpClient client = new DefaultHttpClient(this.buildParams(httpVersion, connectionTimeout, socketTimeout, policy, this.m_config.getVirtualHost()));
        client.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(retryCount.intValue(), false));
        if ("https".equals(uri.getScheme())) {
            SchemeRegistry registry = client.getConnectionManager().getSchemeRegistry();
            Scheme https = registry.getScheme("https");
            SSLSocketFactory factory = null;
            try {
                factory = new SSLSocketFactory(SSLContext.getInstance("EmptyKeyRelaxedTrust"), SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            }
            catch (Throwable e) {
                throw new NorthbounderException(e);
            }
            Scheme lenient = new Scheme(https.getName(), https.getDefaultPort(), (SchemeSocketFactory)factory);
            registry.register(lenient);
        }
        HttpGet method = null;
        if (HttpNorthbounderConfig.HttpMethod.POST == this.m_config.getMethod()) {
            UrlEncodedFormEntity entity;
            HttpPost postMethod = new HttpPost(uri);
            ArrayList<BasicNameValuePair> postParms = new ArrayList<BasicNameValuePair>();
            BasicNameValuePair p = new BasicNameValuePair("foo", "bar");
            postParms.add(p);
            try {
                entity = new UrlEncodedFormEntity(postParms, "UTF-8");
                postMethod.setEntity((HttpEntity)entity);
            }
            catch (UnsupportedEncodingException e) {
                throw new NorthbounderException((Throwable)e);
            }
            entity = null;
            try {
                entity = new StringEntity("XML HERE");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            postMethod.setEntity((HttpEntity)entity);
            method = postMethod;
        } else if (HttpNorthbounderConfig.HttpMethod.GET == this.m_config.getMethod()) {
            method = new HttpGet(uri);
        }
        method.getParams().setParameter("http.useragent", (Object)this.m_config.getUserAgent());
        CloseableHttpResponse response = null;
        try {
            response = client.execute((HttpUriRequest)method);
        }
        catch (ClientProtocolException e) {
            throw new NorthbounderException((Throwable)e);
        }
        catch (IOException e) {
            throw new NorthbounderException((Throwable)e);
        }
        if (response != null && !(range = new HttpResponseRange("200-399")).contains(code = response.getStatusLine().getStatusCode())) {
            LOG.debug("response code out of range for uri:{}.  Expected {} but received {}", new Object[]{uri, range, code});
            throw new NorthbounderException("response code out of range for uri:" + uri + ".  Expected " + range + " but received " + code);
        }
        LOG.debug(response != null ? response.getStatusLine().getReasonPhrase() : "Response was null");
    }

    private static HttpVersion determineHttpVersion(String version) {
        HttpVersion httpVersion = null;
        httpVersion = "1.0".equals(version) ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1;
        return httpVersion;
    }

    private HttpParams buildParams(HttpVersion protocolVersion, int connectionTimeout, int socketTimeout, String policy, String vHost) {
        BasicHttpParams parms = new BasicHttpParams();
        parms.setParameter("http.protocol.version", (Object)protocolVersion);
        parms.setIntParameter("http.connection.timeout", connectionTimeout);
        parms.setIntParameter("http.socket.timeout", socketTimeout);
        parms.setParameter("http.protocol.cookie-policy", (Object)policy);
        parms.setParameter("http.virtual-host", (Object)new HttpHost(vHost, 8080));
        return parms;
    }

    public HttpNorthbounderConfig getConfig() {
        return this.m_config;
    }

    public void setConfig(HttpNorthbounderConfig config) {
        this.m_config = config;
    }

    static {
        Security.addProvider((Provider)new EmptyKeyRelaxedTrustProvider());
    }
}

