/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.email;

import java.util.HashMap;
import java.util.Map;
import org.opennms.core.soa.Registration;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.Northbounder;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.northbounder.email.EmailDestination;
import org.opennms.netmgt.alarmd.northbounder.email.EmailNorthbounder;
import org.opennms.netmgt.alarmd.northbounder.email.EmailNorthbounderConfigDao;
import org.opennms.netmgt.dao.api.JavaMailConfigurationDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class EmailNorthbounderManager
implements InitializingBean,
Northbounder,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(EmailNorthbounderManager.class);
    @Autowired
    private ServiceRegistry m_serviceRegistry;
    @Autowired
    private EmailNorthbounderConfigDao m_configDao;
    @Autowired
    private JavaMailConfigurationDao m_javaMailDao;
    private Map<String, Registration> m_registrations = new HashMap<String, Registration>();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)((Object)this.m_configDao));
        Assert.notNull((Object)this.m_serviceRegistry);
        this.m_registrations.put(this.getName(), this.m_serviceRegistry.register((Object)this, new Class[]{Northbounder.class}));
        this.registerNorthnounders();
    }

    private void registerNorthnounders() throws Exception {
        if (!this.m_configDao.getConfig().isEnabled().booleanValue()) {
            LOG.warn("The Email NBI is globally disabled, the destinations won't be registered which means all the alarms will be rejected.");
            return;
        }
        for (EmailDestination destination : this.m_configDao.getConfig().getEmailDestinations()) {
            LOG.info("Registering Email northbound configuration for destination {}.", (Object)destination.getName());
            EmailNorthbounder nbi = new EmailNorthbounder(this.m_configDao, this.m_javaMailDao, destination.getName());
            nbi.afterPropertiesSet();
            this.m_registrations.put(nbi.getName(), this.m_serviceRegistry.register((Object)nbi, new Class[]{Northbounder.class}));
        }
    }

    public void destroy() throws Exception {
        this.m_registrations.values().forEach(r -> r.unregister());
    }

    public void start() throws NorthbounderException {
    }

    public void onAlarm(NorthboundAlarm alarm) throws NorthbounderException {
    }

    public void stop() throws NorthbounderException {
    }

    public String getName() {
        return "EmailNBI";
    }

    public void reloadConfig() {
        LOG.info("Reloading Email northbound configuration.");
        try {
            this.m_configDao.reload();
            this.m_javaMailDao.reloadConfiguration();
            this.m_registrations.forEach((k, v) -> {
                if (k != this.getName()) {
                    v.unregister();
                }
            });
            this.registerNorthnounders();
        }
        catch (Exception e) {
            LOG.error("Can't reload the SNMP trap northbound configuration", (Throwable)e);
        }
    }
}

