/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.email;

import java.util.List;
import java.util.Map;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.javamail.JavaMailerException;
import org.opennms.javamail.JavaSendMailer;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.api.support.AbstractNorthbounder;
import org.opennms.netmgt.alarmd.northbounder.email.EmailDestination;
import org.opennms.netmgt.alarmd.northbounder.email.EmailFilter;
import org.opennms.netmgt.alarmd.northbounder.email.EmailNorthbounderConfig;
import org.opennms.netmgt.alarmd.northbounder.email.EmailNorthbounderConfigDao;
import org.opennms.netmgt.config.javamail.SendmailConfig;
import org.opennms.netmgt.config.javamail.SendmailMessage;
import org.opennms.netmgt.dao.api.JavaMailConfigurationDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class EmailNorthbounder
extends AbstractNorthbounder
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(EmailNorthbounder.class);
    protected static final String NBI_NAME = "EmailNBI";
    private EmailNorthbounderConfigDao m_configDao;
    private EmailDestination m_destination;
    private SendmailConfig m_sendmail;
    private String m_emailFrom;
    private String m_emailTo;
    private String m_emailSubjectFormat;
    private String m_emailBodyFormat;
    private boolean initialized = false;

    public EmailNorthbounder(EmailNorthbounderConfigDao configDao, JavaMailConfigurationDao javaMailDao, String destinationName) {
        super("EmailNBI:" + destinationName);
        this.m_configDao = configDao;
        this.m_destination = configDao.getConfig().getEmailDestination(destinationName);
        try {
            SendmailConfig sendmail = javaMailDao.getSendMailConfig(destinationName);
            if (sendmail != null) {
                String sendmailText = JaxbUtils.marshal((Object)sendmail);
                this.m_sendmail = (SendmailConfig)JaxbUtils.unmarshal(SendmailConfig.class, (String)sendmailText);
            }
        }
        catch (Exception e) {
            LOG.error("Can't create a copy of the SendmailConfig object named {}.", (Object)destinationName, (Object)e);
        }
        if (this.m_sendmail != null && this.m_sendmail.getSendmailMessage() != null) {
            this.m_emailSubjectFormat = this.m_sendmail.getSendmailMessage().getSubject();
            this.m_emailBodyFormat = this.m_sendmail.getSendmailMessage().getBody();
            this.m_emailFrom = this.m_sendmail.getSendmailMessage().getFrom();
            this.m_emailTo = this.m_sendmail.getSendmailMessage().getTo();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.m_destination == null || this.m_sendmail == null) {
            LOG.error("Emai Northbounder {} is currently disabled because it has not been initialized correctly or there is a problem with the configuration.", (Object)this.getName());
            this.initialized = false;
            return;
        }
        this.setNaglesDelay(this.getConfig().getNaglesDelay().intValue());
        this.setMaxBatchSize(this.getConfig().getBatchSize());
        this.setMaxPreservedAlarms(this.getConfig().getQueueSize());
        this.initialized = true;
    }

    public boolean accepts(NorthboundAlarm alarm) {
        if (!this.initialized) {
            LOG.warn("Email Northbounder {} has not been properly initialized, rejecting alarm {}.", (Object)this.getName(), (Object)alarm.getUei());
            return false;
        }
        if (!this.getConfig().isEnabled().booleanValue()) {
            LOG.warn("Email Northbounder {} is currently disabled, rejecting alarm {}.", (Object)this.getName(), (Object)alarm.getUei());
            return false;
        }
        LOG.debug("Validating UEI of alarm: {}", (Object)alarm.getUei());
        if (this.getConfig().getUeis() == null || this.getConfig().getUeis().contains(alarm.getUei())) {
            LOG.debug("UEI: {}, accepted.", (Object)alarm.getUei());
            boolean passed = this.m_destination.accepts(alarm);
            LOG.debug("Filters: {}, passed ? {}.", (Object)alarm.getUei(), (Object)passed);
            return passed;
        }
        LOG.debug("UEI: {}, rejected.", (Object)alarm.getUei());
        return false;
    }

    public void forwardAlarms(List<NorthboundAlarm> alarms) throws NorthbounderException {
        if (alarms == null) {
            String errorMsg = "No alarms in alarms list for syslog forwarding.";
            NorthbounderException e = new NorthbounderException(errorMsg);
            LOG.error(errorMsg, (Throwable)e);
            throw e;
        }
        LOG.info("Forwarding {} alarms to destination {}", (Object)alarms.size(), (Object)this.m_destination.getName());
        for (NorthboundAlarm alarm : alarms) {
            try {
                JavaSendMailer mailer = new JavaSendMailer(this.getSendmailConfig(alarm), false);
                mailer.send();
            }
            catch (JavaMailerException e) {
                LOG.error("Can't send email for {}", (Object)alarm, (Object)e);
            }
        }
    }

    protected SendmailConfig getSendmailConfig(NorthboundAlarm alarm) {
        SendmailMessage message = new SendmailMessage();
        message.setFrom(this.m_emailFrom);
        message.setTo(this.m_emailTo);
        message.setSubject(this.m_emailSubjectFormat);
        message.setBody(this.m_emailBodyFormat);
        for (EmailFilter filter : this.m_destination.getFilters()) {
            if (!filter.accepts(alarm)) continue;
            filter.update(message);
        }
        LOG.debug("getSendmailConfig: from = {}", (Object)message.getFrom());
        LOG.debug("getSendmailConfig: to = {}", (Object)message.getTo());
        Map mapping = this.createMapping(alarm);
        String subject = PropertiesUtils.substitute((String)message.getSubject(), (Map[])new Map[]{mapping});
        LOG.debug("getSendmailConfig: subject = {}", (Object)subject);
        message.setSubject(subject);
        String body = PropertiesUtils.substitute((String)message.getBody(), (Map[])new Map[]{mapping});
        LOG.debug("getSendmailConfig: body = {}", (Object)body);
        message.setBody(body);
        this.m_sendmail.setSendmailMessage(message);
        return this.m_sendmail;
    }

    protected EmailNorthbounderConfig getConfig() {
        return this.m_configDao.getConfig();
    }
}

