/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.bsf;

import java.util.List;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.api.support.AbstractNorthbounder;
import org.opennms.netmgt.alarmd.northbounder.bsf.BSFEngineHandler;
import org.opennms.netmgt.alarmd.northbounder.bsf.BSFNorthbounderConfig;
import org.opennms.netmgt.alarmd.northbounder.bsf.BSFNorthbounderConfigDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class BSFNorthbounder
extends AbstractNorthbounder
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(BSFNorthbounder.class);
    protected static final String NBI_NAME = "BSFNBI";
    private BSFNorthbounderConfigDao m_configDao;
    private BSFEngineHandler m_engine;
    private BSFManager m_manager = new BSFManager();
    private boolean initialized = false;

    public BSFNorthbounder(BSFNorthbounderConfigDao configDao, String engineName) {
        super("BSFNBI-" + engineName);
        this.m_configDao = configDao;
        this.m_engine = configDao.getConfig().getEngine(engineName);
    }

    public void afterPropertiesSet() throws Exception {
        this.setNaglesDelay(this.getConfig().getNaglesDelay().intValue());
        this.setMaxBatchSize(this.getConfig().getBatchSize());
        this.setMaxPreservedAlarms(this.getConfig().getQueueSize());
        if (this.m_engine == null) {
            LOG.error("BSF Northbounder {} is currently disabled because it has not been initialized correctly or there is a problem with the configuration.", (Object)this.getName());
            this.initialized = false;
            return;
        }
        this.initializeBSFEngine();
        this.initialized = true;
    }

    protected void onStop() {
        if (this.m_engine.getOnStop() != null) {
            LOG.debug("running stop script for BSF engine {}", (Object)this.getName());
            try {
                this.m_manager.exec(this.m_engine.getLanguage(), "", 0, 0, (Object)this.m_engine.getOnStop());
            }
            catch (BSFException e) {
                throw new NorthbounderException("Cannot execute stop script", (Throwable)e);
            }
        }
    }

    private void initializeBSFEngine() throws Exception {
        if (!BSFManager.isLanguageRegistered((String)this.m_engine.getLanguage())) {
            LOG.debug("registering BSF language {} using {}", (Object)this.m_engine.getLanguage(), (Object)this.m_engine.getClassName());
            BSFManager.registerScriptingEngine((String)this.m_engine.getLanguage(), (String)this.m_engine.getClassName(), (String[])this.m_engine.getExtensions().split(","));
        }
        this.m_manager.registerBean("log", (Object)LOG);
        if (this.m_engine.getOnStart() != null) {
            LOG.debug("running start script for BSF engine {}", (Object)this.getName());
            try {
                this.m_manager.exec(this.m_engine.getLanguage(), "", 0, 0, (Object)this.m_engine.getOnStart());
            }
            catch (BSFException e) {
                throw new NorthbounderException("Cannot execute start script", (Throwable)e);
            }
        }
    }

    public boolean accepts(NorthboundAlarm alarm) {
        if (!this.initialized) {
            LOG.warn("BSF Northbounder {} has not been properly initialized, rejecting alarm {}.", (Object)this.getName(), (Object)alarm.getUei());
            return false;
        }
        if (!this.getConfig().isEnabled().booleanValue()) {
            LOG.warn("BSF Northbounder {} is currently disabled, rejecting alarm {}.", (Object)this.getName(), (Object)alarm.getUei());
            return false;
        }
        LOG.debug("Validating UEI of alarm: {}", (Object)alarm.getUei());
        if (this.getConfig().getUeis() == null || this.getConfig().getUeis().contains(alarm.getUei())) {
            LOG.debug("UEI: {}, accepted.", (Object)alarm.getUei());
            boolean passed = this.m_engine.accepts(alarm);
            LOG.debug("Filters: {}, passed ? {}.", (Object)alarm.getUei(), (Object)passed);
            return passed;
        }
        LOG.debug("UEI: {}, rejected.", (Object)alarm.getUei());
        return false;
    }

    public void forwardAlarms(List<NorthboundAlarm> alarms) throws NorthbounderException {
        if (alarms == null) {
            String errorMsg = "No alarms in alarms list for BSF forwarding.";
            NorthbounderException e = new NorthbounderException(errorMsg);
            LOG.error(errorMsg, (Throwable)e);
            throw e;
        }
        LOG.info("Forwarding {} alarms to engine {}", (Object)alarms.size(), (Object)this.m_engine.getName());
        alarms.forEach(a -> this.process((NorthboundAlarm)a));
    }

    protected BSFNorthbounderConfig getConfig() {
        return this.m_configDao.getConfig();
    }

    private void process(NorthboundAlarm alarm) throws NorthbounderException {
        this.m_manager.registerBean("alarm", (Object)alarm);
        try {
            LOG.debug("processing alarm {} with engine {}", (Object)alarm, (Object)this.getName());
            this.m_manager.exec(this.m_engine.getLanguage(), "", 0, 0, (Object)this.m_engine.getOnAlarm());
        }
        catch (BSFException e) {
            throw new NorthbounderException("Cannot execute script", (Throwable)e);
        }
        finally {
            this.m_manager.unregisterBean("alarm");
        }
    }
}

