/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.integrations.R;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.RowSortedTable;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.opennms.netmgt.integrations.R.HybridTemplateLoader;
import org.opennms.netmgt.integrations.R.RScriptException;
import org.opennms.netmgt.integrations.R.RScriptInput;
import org.opennms.netmgt.integrations.R.RScriptOutput;

public class RScriptExecutor {
    public static final String RSCRIPT_BINARY = System.getProperty("rscript.binary", "Rscript");
    public static final long SCRIPT_TIMEOUT_MS = 60000L;
    private Configuration m_freemarkerConfiguration;

    public RScriptExecutor() {
        this.setupFreemarker();
    }

    private void setupFreemarker() {
        this.m_freemarkerConfiguration = new Configuration(Configuration.VERSION_2_3_21);
        this.m_freemarkerConfiguration.setTemplateLoader((TemplateLoader)new HybridTemplateLoader());
        this.m_freemarkerConfiguration.setDefaultEncoding("UTF-8");
        this.m_freemarkerConfiguration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
    }

    public RScriptOutput exec(String script, RScriptInput input) throws RScriptException {
        StringBuilder inputTableAsCsv;
        File scriptOnDisk;
        Template template;
        Preconditions.checkNotNull((Object)script, (Object)"script argument");
        Preconditions.checkNotNull((Object)input, (Object)"input argument");
        try {
            template = this.m_freemarkerConfiguration.getTemplate(script);
        }
        catch (IOException e) {
            throw new RScriptException("Failed to read the script.", e);
        }
        try {
            scriptOnDisk = File.createTempFile("Rcsript", "R");
            scriptOnDisk.deleteOnExit();
        }
        catch (IOException e) {
            throw new RScriptException("Failed to create a temporary file.", e);
        }
        try (FileOutputStream fos = new FileOutputStream(scriptOnDisk);
             OutputStreamWriter out = new OutputStreamWriter(fos);){
            template.process(input.getArguments(), (Writer)out);
        }
        catch (TemplateException | IOException e) {
            throw new RScriptException("Failed to process the template.", e);
        }
        try {
            inputTableAsCsv = RScriptExecutor.toCsv(input.getTable());
        }
        catch (IOException e) {
            throw new RScriptException("Failed to convert the input table to CSV.", e);
        }
        CommandLine cmdLine = new CommandLine(RSCRIPT_BINARY);
        cmdLine.addArgument(scriptOnDisk.getAbsolutePath());
        DefaultExecutor executor = new DefaultExecutor();
        CharSequenceInputStream stdin = new CharSequenceInputStream((CharSequence)inputTableAsCsv, Charset.forName("UTF-8"));
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)stdout, (OutputStream)stderr, (InputStream)stdin));
        executor.setExitValue(0);
        ExecuteWatchdog watchdog = new ExecuteWatchdog(60000L);
        executor.setWatchdog(watchdog);
        try {
            executor.execute(cmdLine);
        }
        catch (IOException e) {
            throw new RScriptException("An error occured while executing Rscript, or the requested script.", inputTableAsCsv.toString(), stderr.toString(), stdout.toString(), e);
        }
        try {
            ImmutableTable<Integer, String, Double> table = RScriptExecutor.fromCsv(stdout.toString());
            return new RScriptOutput(table);
        }
        catch (Throwable t) {
            throw new RScriptException("Failed to parse the script's output.", inputTableAsCsv.toString(), stderr.toString(), stdout.toString(), t);
        }
    }

    protected static ImmutableTable<Integer, String, Double> fromCsv(String csv) throws IOException {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        try (StringReader reader = new StringReader(csv);
             CSVParser parser = new CSVParser((Reader)reader, CSVFormat.RFC4180.withHeader(new String[0]));){
            int rowIndex = 0;
            Map headerMap = parser.getHeaderMap();
            for (CSVRecord record : parser) {
                for (String key : headerMap.keySet()) {
                    Double value;
                    try {
                        value = Double.valueOf(record.get(key));
                    }
                    catch (NumberFormatException e) {
                        value = Double.NaN;
                    }
                    builder.put((Object)rowIndex, (Object)key, (Object)value);
                }
                ++rowIndex;
            }
        }
        return builder.build();
    }

    protected static StringBuilder toCsv(RowSortedTable<Integer, String, Double> table) throws IOException {
        String[] columnNames = table.columnKeySet().toArray(new String[0]);
        StringBuilder sb = new StringBuilder();
        CSVPrinter printer = CSVFormat.RFC4180.withHeader(columnNames).print((Appendable)sb);
        Iterator iterator = table.rowKeySet().iterator();
        while (iterator.hasNext()) {
            int rowIndex = (Integer)iterator.next();
            for (String columnName : columnNames) {
                Double value = (Double)table.get((Object)rowIndex, (Object)columnName);
                if (value == null) {
                    value = Double.NaN;
                }
                printer.print((Object)value);
            }
            printer.println();
        }
        return sb;
    }
}

