/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.ocs.inventory.client.request.logic;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.codec.binary.Base64;
import org.opennms.ocs.inventory.client.request.logic.GeneralClientLogic;
import org.opennms.ocs.inventory.client.response.Computers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetComputersLogic
extends GeneralClientLogic {
    private static Logger LOGGER = LoggerFactory.getLogger(GetComputersLogic.class);
    private static final String ASKINGFOR_INVENTORY = "INVENTORY";
    private static final String WEB_SERVICE_METHOD_GET_COMPUTER = "get_computers_V1";

    @Override
    public void init(String host, String login, String password) throws SOAPException {
        super.init(host, login, password, null, new ArrayList<String>());
        this.initRequestParameter();
    }

    @Override
    public void init(String host, String login, String password, String checksum, List<String> tags) throws SOAPException {
        super.init(host, login, password, checksum, tags);
        this.initRequestParameter();
    }

    @Override
    public void init(String host, String login, String password, String checksum) throws SOAPException {
        super.init(host, login, password, checksum, new ArrayList<String>());
        this.initRequestParameter();
    }

    private void initRequestParameter() {
        this.m_askingfor = ASKINGFOR_INVENTORY;
        this.m_web_service_method = WEB_SERVICE_METHOD_GET_COMPUTER;
    }

    public Computers getComputers() throws SOAPException, Exception {
        Computers computers = new Computers();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Computers.class});
        Unmarshaller jaxbMarshaller = jaxbContext.createUnmarshaller();
        Integer offset = 0;
        Boolean isEverythingRequested = false;
        while (!isEverythingRequested.booleanValue()) {
            String content;
            LOGGER.info("Prepare call web service from OCS server with offset " + offset);
            SOAPMessage soapResponse = this.soapConnection.call(this.createSOAPRequest(offset), (Object)m_url);
            LOGGER.info("Web service are already called from OCS server, parse response");
            SOAPBody spBody = soapResponse.getSOAPBody();
            SOAPElement soapElement = (SOAPElement)spBody.getChildElements().next();
            for (int i = 1; i < soapElement.getChildNodes().getLength() - 1; ++i) {
                content = soapElement.getChildNodes().item(i).getTextContent();
                if (Base64.isBase64((String)content)) {
                    content = new String(Base64.decodeBase64((byte[])content.getBytes()));
                }
                soapElement.getChildNodes().item(i).setTextContent(content + "\n");
            }
            content = soapElement.getTextContent();
            ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());
            Computers computersFromThisRequest = (Computers)jaxbMarshaller.unmarshal((InputStream)is);
            if (computersFromThisRequest.getComputers().isEmpty()) {
                isEverythingRequested = true;
            }
            computers.getComputers().addAll(computersFromThisRequest.getComputers());
            Integer n = offset;
            Integer n2 = offset = Integer.valueOf(offset + 1);
        }
        LOGGER.info("OCS Inventory Client provided " + computers.getComputers().size() + " computers.");
        return computers;
    }
}

