/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.mock.snmp;

import java.lang.reflect.Method;
import java.net.InetAddress;
import org.opennms.mock.snmp.JUnitSnmpAgent;
import org.opennms.mock.snmp.MockSnmpAgent;
import org.opennms.mock.snmp.MockSnmpAgentAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class JUnitSnmpAgentExecutionListener
extends AbstractTestExecutionListener {
    private static final String MOCK_SNMP_AGENT = MockSnmpAgent.class.getName();

    public void beforeTestMethod(TestContext testContext) throws Exception {
        JUnitSnmpAgent config = this.findAgentAnnotation(testContext);
        if (config == null) {
            return;
        }
        String host = config.host();
        if (host == null || "".equals(host)) {
            host = InetAddress.getLocalHost().getHostAddress();
        }
        DefaultResourceLoader loader = new DefaultResourceLoader();
        Resource resource = loader.getResource(config.resource());
        MockSnmpAgent agent = MockSnmpAgent.createAgentAndRun(resource, host + "/" + config.port());
        System.err.println("Set up agent " + agent);
        testContext.setAttribute(MOCK_SNMP_AGENT, (Object)agent);
        if (testContext.getTestInstance() instanceof MockSnmpAgentAware) {
            System.err.println("injecting agent into MockSnmpAgentAware test: " + testContext.getTestInstance());
            ((MockSnmpAgentAware)testContext.getTestInstance()).setMockSnmpAgent(agent);
        }
    }

    private JUnitSnmpAgent findAgentAnnotation(TestContext testContext) {
        Method testMethod = testContext.getTestMethod();
        JUnitSnmpAgent config = testMethod.getAnnotation(JUnitSnmpAgent.class);
        if (config != null) {
            return config;
        }
        Class testClass = testContext.getTestClass();
        return testClass.getAnnotation(JUnitSnmpAgent.class);
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        MockSnmpAgent agent = (MockSnmpAgent)testContext.getAttribute(MOCK_SNMP_AGENT);
        if (agent != null) {
            System.err.println("Shutting down agent " + agent);
            agent.shutDownAndWait();
        }
    }
}

