/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.mock.snmp;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opennms.mock.snmp.MockSnmpMOLoader;
import org.opennms.mock.snmp.PropsMockSnmpMOLoaderImpl;
import org.opennms.mock.snmp.Updatable;
import org.snmp4j.agent.DefaultMOScope;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesBackedManagedObject
implements ManagedObject,
MockSnmpMOLoader,
Updatable,
MOAccess {
    private TreeMap<OID, Object> m_vars = null;
    private MOScope m_scope = null;

    public PropertiesBackedManagedObject(Resource moFile) {
        Properties props = PropsMockSnmpMOLoaderImpl.loadProperties(moFile);
        this.m_vars = new TreeMap();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String key = (String)e.getKey();
            Object value = e.getValue();
            this.m_vars.put(new OID(key), value);
        }
        this.m_scope = new DefaultMOScope(this.m_vars.firstKey(), true, this.m_vars.lastKey(), true);
    }

    public void cleanup(SubRequest request) {
        throw new UnsupportedOperationException("this object read only");
    }

    public void commit(SubRequest request) {
        throw new UnsupportedOperationException("this object read only");
    }

    public OID find(MOScope range) {
        SortedMap<OID, Object> tail;
        if (!this.m_scope.isOverlapping(range)) {
            return null;
        }
        OID first = range.getLowerBound();
        if (range.isLowerIncluded()) {
            first = first.successor();
        }
        if ((tail = this.m_vars.tailMap(first)).isEmpty()) {
            return null;
        }
        return tail.firstKey();
    }

    public OID findNextOid(OID given) {
        OID next = given.successor();
        SortedMap<OID, Object> tail = this.m_vars.tailMap(next);
        if (tail.isEmpty()) {
            return null;
        }
        return tail.firstKey();
    }

    private Variable findValueForOID(OID oid) {
        Object val = this.m_vars.get(oid);
        if (val == null) {
            return null;
        }
        if (val instanceof Variable) {
            return (Variable)val;
        }
        return PropsMockSnmpMOLoaderImpl.getVariableFromValueString(oid.toString(), (String)val);
    }

    public void get(SubRequest request) {
        this.getVariable(request, request.getVariableBinding().getOid());
    }

    private void getVariable(SubRequest request, OID oid) {
        Variable value = this.findValueForOID(oid);
        VariableBinding vb = request.getVariableBinding();
        vb.setOid(oid);
        vb.setVariable((Variable)(value == null ? Null.noSuchObject : value));
        request.completed();
    }

    public MOScope getScope() {
        return this.m_scope;
    }

    public boolean next(SubRequest request) {
        OID nextOid = this.findNextOid(request.getVariableBinding().getOid());
        if (nextOid == null) {
            return false;
        }
        this.getVariable(request, nextOid);
        return true;
    }

    public void prepare(SubRequest request) {
        throw new UnsupportedOperationException("this object read only");
    }

    public void undo(SubRequest request) {
        throw new UnsupportedOperationException("this object read only");
    }

    @Override
    public void updateValue(OID oid, Variable value) {
        this.m_vars.put(oid, value);
    }

    @Override
    public List<ManagedObject> loadMOs() {
        return Collections.singletonList(this);
    }

    public boolean isAccessibleForCreate() {
        return false;
    }

    public boolean isAccessibleForNotify() {
        return false;
    }

    public boolean isAccessibleForRead() {
        return true;
    }

    public boolean isAccessibleForWrite() {
        return false;
    }
}

