/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.mock.snmp;

import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.util.Iterator;
import java.util.List;
import org.opennms.mock.snmp.MockSnmpMOLoader;
import org.opennms.mock.snmp.PropertiesBackedManagedObject;
import org.opennms.mock.snmp.Updatable;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.BaseAgent;
import org.snmp4j.agent.CommandProcessor;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.TransportDomains;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.log.Log4jLogFactory;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.WorkerPool;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockSnmpAgent
extends BaseAgent
implements Runnable {
    private static final String PROPERTY_SLEEP_ON_CREATE = "mockSnmpAgent.sleepOnCreate";
    private String m_address;
    private Resource m_moFile;
    private boolean m_running;
    private boolean m_stopped;
    private List<ManagedObject> m_moList;
    private MockSnmpMOLoader m_moLoader;

    public MockSnmpAgent(File bootFile, File confFile, Resource moFile, String bindAddress) {
        super(bootFile, confFile, new CommandProcessor(new OctetString(MPv3.createLocalEngineID((OctetString)new OctetString("MOCKAGENT")))));
        this.m_address = bindAddress;
        this.m_moFile = moFile;
        this.agent.setWorkerPool((WorkerPool)ThreadPool.create((String)"RequestPool", (int)4));
    }

    public static MockSnmpAgent createAgentAndRun(Resource moFile, String bindAddress) throws InterruptedException {
        try {
            if (moFile.getInputStream() == null) {
                throw new IllegalArgumentException("could not get InputStream mock object resource; does it exist?  Resource: " + moFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Got IOException while checking for existence of mock object file: " + e, e);
        }
        MockSnmpAgent agent = new MockSnmpAgent(new File("/dev/null"), new File("/dev/null"), moFile, bindAddress);
        Thread thread = new Thread(agent);
        thread.start();
        try {
            while (!agent.isRunning() && thread.isAlive()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            agent.shutDownAndWait();
            throw e;
        }
        if (!thread.isAlive()) {
            agent.m_running = false;
            agent.m_stopped = true;
            throw new IllegalStateException("agent failed to start--check logs");
        }
        if (System.getProperty(PROPERTY_SLEEP_ON_CREATE) != null) {
            long sleep = Long.parseLong(System.getProperty(PROPERTY_SLEEP_ON_CREATE));
            Thread.sleep(sleep);
        }
        return agent;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: MockSnmpAgent props-file listen-addr\n\nWhere props-file is relative to CLASSPATH\nand listen-addr is of the form 10.11.12.13/1161 to listen on port 1161");
            System.exit(1);
        }
        ClassPathResource moFile = new ClassPathResource(args[0]);
        String bindAddress = args[1];
        try {
            MockSnmpAgent.createAgentAndRun((Resource)moFile, bindAddress);
        }
        catch (InterruptedException e) {
            System.exit(0);
        }
    }

    public void shutDownAndWait() throws InterruptedException {
        if (!this.isRunning()) {
            return;
        }
        this.shutDown();
        while (!this.isStopped()) {
            Thread.sleep(10L);
        }
    }

    @Override
    public void run() {
        try {
            this.init();
            this.loadConfig(2);
            this.addShutdownHook();
            this.finishInit();
            super.run();
            this.m_running = true;
        }
        catch (BindException be) {
            be.printStackTrace();
            System.err.println("You probably specified an invalid address or a port < 1024 and are not running as root");
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        while (this.m_running) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        try {
            for (TransportMapping transportMapping : this.transportMappings) {
                transportMapping.close();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.m_stopped = true;
    }

    public void shutDown() {
        this.m_running = false;
        this.m_stopped = false;
    }

    public boolean isRunning() {
        return this.m_running;
    }

    public boolean isStopped() {
        return this.m_stopped;
    }

    protected void addCommunities(SnmpCommunityMIB communityMIB) {
        Variable[] com2sec = new Variable[]{new OctetString("public"), new OctetString("public"), this.getAgent().getContextEngineID(), new OctetString(), new OctetString(), new Integer32(3), new Integer32(1)};
        MOTableRow row = communityMIB.getSnmpCommunityEntry().createRow(new OctetString("public2public").toSubIndex(true), com2sec);
        communityMIB.getSnmpCommunityEntry().addRow(row);
    }

    protected void addViews(VacmMIB vacm) {
        vacm.addGroup(1, new OctetString("public"), new OctetString("v1v2group"), 3);
        vacm.addGroup(2, new OctetString("public"), new OctetString("v1v2group"), 3);
        vacm.addGroup(3, new OctetString("SHADES"), new OctetString("v3group"), 3);
        vacm.addGroup(3, new OctetString("TEST"), new OctetString("v3test"), 3);
        vacm.addGroup(3, new OctetString("opennmsUser"), new OctetString("v3group"), 3);
        vacm.addGroup(3, new OctetString("SHA"), new OctetString("v3restricted"), 3);
        vacm.addAccess(new OctetString("v1v2group"), new OctetString(), 0, 1, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacm.addAccess(new OctetString("v3group"), new OctetString(), 3, 3, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacm.addAccess(new OctetString("v3restricted"), new OctetString(), 3, 2, 1, new OctetString("restrictedReadView"), new OctetString("restrictedWriteView"), new OctetString("restrictedNotifyView"), 3);
        vacm.addAccess(new OctetString("v3test"), new OctetString(), 3, 3, 1, new OctetString("testReadView"), new OctetString("testWriteView"), new OctetString("testNotifyView"), 3);
        vacm.addViewTreeFamily(new OctetString("fullReadView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("fullWriteView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("fullNotifyView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedReadView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedWriteView"), new OID("1.3.6.1.2.1"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedNotifyView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testReadView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testReadView"), new OID("1.3.6.1.2.1.1"), new OctetString(), 2, 3);
        vacm.addViewTreeFamily(new OctetString("testWriteView"), new OID("1.3.6.1.2.1"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testNotifyView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
    }

    protected void addNotificationTargets(SnmpTargetMIB targetMIB, SnmpNotificationMIB notificationMIB) {
        targetMIB.addDefaultTDomains();
        targetMIB.addTargetAddress(new OctetString("notification"), TransportDomains.transportDomainUdpIpv4, new OctetString(new UdpAddress("127.0.0.1/162").getValue()), 200, 1, new OctetString("notify"), new OctetString("v2c"), 4);
        targetMIB.addTargetParams(new OctetString("v2c"), 1, 2, new OctetString("public"), 1, 4);
        notificationMIB.addNotifyEntry(new OctetString("default"), new OctetString("notify"), 1, 4);
    }

    protected void addUsmUser(USM usm) {
        UsmUser user = new UsmUser(new OctetString("SHADES"), AuthSHA.ID, new OctetString("SHADESAuthPassword"), PrivDES.ID, new OctetString("SHADESPrivPassword"));
        usm.addUser(user.getSecurityName(), usm.getLocalEngineID(), user);
        user = new UsmUser(new OctetString("TEST"), AuthSHA.ID, new OctetString("maplesyrup"), PrivDES.ID, new OctetString("maplesyrup"));
        usm.addUser(user.getSecurityName(), usm.getLocalEngineID(), user);
        user = new UsmUser(new OctetString("opennmsUser"), AuthMD5.ID, new OctetString("0p3nNMSv3"), PrivDES.ID, new OctetString("0p3nNMSv3"));
        usm.addUser(user.getSecurityName(), usm.getLocalEngineID(), user);
        user = new UsmUser(new OctetString("SHA"), AuthSHA.ID, new OctetString("SHAAuthPassword"), null, null);
        usm.addUser(user.getSecurityName(), usm.getLocalEngineID(), user);
    }

    protected void initTransportMappings() throws IOException {
        this.transportMappings = new TransportMapping[1];
        this.transportMappings[0] = new DefaultUdpTransportMapping(new UdpAddress(this.m_address));
    }

    protected void registerSnmpMIBs() {
        this.registerManagedObjects();
    }

    protected void unregisterSnmpMIBs() {
    }

    protected void registerManagedObjects() {
        this.m_moList = this.createMockMOs();
        Iterator<ManagedObject> moListIter = this.m_moList.iterator();
        while (moListIter.hasNext()) {
            try {
                this.server.register(moListIter.next(), null);
            }
            catch (DuplicateRegistrationException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void unregisterManagedObjects() {
    }

    protected List<ManagedObject> createMockMOs() {
        this.m_moLoader = new PropertiesBackedManagedObject(this.m_moFile);
        return this.m_moLoader.loadMOs();
    }

    private ManagedObject findMOForOid(OID oid) {
        for (ManagedObject mo : this.m_moList) {
            if (!mo.getScope().covers(oid)) continue;
            return mo;
        }
        return null;
    }

    public void updateValue(OID oid, Variable value) {
        ManagedObject mo = this.findMOForOid(oid);
        this.assertNotNull("Unable to find oid in mib for mockAgent: " + oid, mo);
        if (mo instanceof Updatable) {
            ((Updatable)mo).updateValue(oid, value);
        }
    }

    private void assertNotNull(String string, Object o) {
        if (o == null) {
            throw new IllegalStateException(string);
        }
    }

    public void updateValue(String oid, Variable value) {
        this.updateValue(new OID(oid), value);
    }

    public void updateIntValue(String oid, int val) {
        this.updateValue(oid, (Variable)new Integer32(val));
    }

    public void updateStringValue(String oid, String val) {
        this.updateValue(oid, (Variable)new OctetString(val));
    }

    public void updateCounter32Value(String oid, int val) {
        this.updateValue(oid, (Variable)new Counter32((long)val));
    }

    public void updateCounter64Value(String oid, long val) {
        this.updateValue(oid, (Variable)new Counter64(val));
    }

    static {
        LogFactory.setLogFactory((LogFactory)new Log4jLogFactory());
    }
}

