/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import junit.framework.TestCase;
import org.xbill.DNS.Type;

public class TypeTest
extends TestCase {
    public void test_string() {
        TypeTest.assertEquals("CNAME", Type.string(5));
        TypeTest.assertTrue(Type.string(256).startsWith("TYPE"));
        try {
            Type.string(-1);
            TypeTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_value() {
        TypeTest.assertEquals(253, Type.value("MAILB"));
        TypeTest.assertEquals(300, Type.value("TYPE300"));
        TypeTest.assertEquals(-1, Type.value("THIS IS DEFINITELY UNKNOWN"));
        TypeTest.assertEquals(-1, Type.value(""));
    }

    public void test_value_2arg() {
        TypeTest.assertEquals(301, Type.value("301", true));
    }

    public void test_isRR() {
        TypeTest.assertTrue(Type.isRR(5));
        TypeTest.assertFalse(Type.isRR(251));
    }
}

