/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.xbill.DNS.Name;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;

public class TokenizerTest
extends TestCase {
    private Tokenizer m_t;

    protected void setUp() {
        this.m_t = null;
    }

    private void assertEquals(byte[] exp, byte[] act) {
        TokenizerTest.assertTrue(Arrays.equals(exp, act));
    }

    public void test_get() throws IOException {
        this.m_t = new Tokenizer(new BufferedInputStream(new ByteArrayInputStream("AnIdentifier \"a quoted \\\" string\"\r\n; this is \"my\"\t(comment)\nanotherIdentifier (\ramultilineIdentifier\n)".getBytes())));
        Tokenizer.Token tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(3, tt.type);
        TokenizerTest.assertTrue(tt.isString());
        TokenizerTest.assertFalse(tt.isEOL());
        TokenizerTest.assertEquals("AnIdentifier", tt.value);
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(2, tt.type);
        TokenizerTest.assertFalse(tt.isString());
        TokenizerTest.assertFalse(tt.isEOL());
        TokenizerTest.assertNull(tt.value);
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(4, tt.type);
        TokenizerTest.assertTrue(tt.isString());
        TokenizerTest.assertFalse(tt.isEOL());
        TokenizerTest.assertEquals("a quoted \\\" string", tt.value);
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(1, tt.type);
        TokenizerTest.assertFalse(tt.isString());
        TokenizerTest.assertTrue(tt.isEOL());
        TokenizerTest.assertNull(tt.value);
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(5, tt.type);
        TokenizerTest.assertFalse(tt.isString());
        TokenizerTest.assertFalse(tt.isEOL());
        TokenizerTest.assertEquals(" this is \"my\"\t(comment)", tt.value);
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(1, tt.type);
        TokenizerTest.assertFalse(tt.isString());
        TokenizerTest.assertTrue(tt.isEOL());
        TokenizerTest.assertNull(tt.value);
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(3, tt.type);
        TokenizerTest.assertTrue(tt.isString());
        TokenizerTest.assertFalse(tt.isEOL());
        TokenizerTest.assertEquals("anotherIdentifier", tt.value);
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(2, tt.type);
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(3, tt.type);
        TokenizerTest.assertTrue(tt.isString());
        TokenizerTest.assertFalse(tt.isEOL());
        TokenizerTest.assertEquals("amultilineIdentifier", tt.value);
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(2, tt.type);
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(0, tt.type);
        TokenizerTest.assertFalse(tt.isString());
        TokenizerTest.assertTrue(tt.isEOL());
        TokenizerTest.assertNull(tt.value);
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(0, tt.type);
        TokenizerTest.assertFalse(tt.isString());
        TokenizerTest.assertTrue(tt.isEOL());
        TokenizerTest.assertNull(tt.value);
        this.m_t = new Tokenizer("onlyOneIdentifier");
        tt = this.m_t.get();
        TokenizerTest.assertEquals(3, tt.type);
        TokenizerTest.assertEquals("onlyOneIdentifier", tt.value);
        this.m_t = new Tokenizer("identifier ;");
        tt = this.m_t.get();
        TokenizerTest.assertEquals("identifier", tt.value);
        tt = this.m_t.get();
        TokenizerTest.assertEquals(0, tt.type);
        this.m_t = new Tokenizer("identifier \nidentifier2; junk comment");
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(3, tt.type);
        TokenizerTest.assertEquals("identifier", tt.value);
        this.m_t.unget();
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(3, tt.type);
        TokenizerTest.assertEquals("identifier", tt.value);
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(2, tt.type);
        this.m_t.unget();
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(2, tt.type);
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(1, tt.type);
        this.m_t.unget();
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(1, tt.type);
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(3, tt.type);
        TokenizerTest.assertEquals("identifier2", tt.value);
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(5, tt.type);
        TokenizerTest.assertEquals(" junk comment", tt.value);
        this.m_t.unget();
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(5, tt.type);
        TokenizerTest.assertEquals(" junk comment", tt.value);
        tt = this.m_t.get(true, true);
        TokenizerTest.assertEquals(0, tt.type);
        this.m_t = new Tokenizer("identifier ( junk ; comment\n )");
        tt = this.m_t.get();
        TokenizerTest.assertEquals(3, tt.type);
        TokenizerTest.assertEquals(3, this.m_t.get().type);
        TokenizerTest.assertEquals(0, this.m_t.get().type);
    }

    public void test_get_invalid() throws IOException {
        this.m_t = new Tokenizer("(this ;");
        this.m_t.get();
        try {
            this.m_t.get();
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        this.m_t = new Tokenizer("\"bad");
        try {
            this.m_t.get();
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        this.m_t = new Tokenizer(")");
        try {
            this.m_t.get();
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        this.m_t = new Tokenizer("\\");
        try {
            this.m_t.get();
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        this.m_t = new Tokenizer("\"\n");
        try {
            this.m_t.get();
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_File_input() throws IOException {
        File tmp = File.createTempFile("dnsjava", "tmp");
        try {
            FileWriter fw = new FileWriter(tmp);
            fw.write("file\ninput; test");
            fw.close();
            this.m_t = new Tokenizer(tmp);
            Tokenizer.Token tt = this.m_t.get();
            TokenizerTest.assertEquals(3, tt.type);
            TokenizerTest.assertEquals("file", tt.value);
            tt = this.m_t.get();
            TokenizerTest.assertEquals(1, tt.type);
            tt = this.m_t.get();
            TokenizerTest.assertEquals(3, tt.type);
            TokenizerTest.assertEquals("input", tt.value);
            tt = this.m_t.get(false, true);
            TokenizerTest.assertEquals(5, tt.type);
            TokenizerTest.assertEquals(" test", tt.value);
            this.m_t.close();
        }
        finally {
            tmp.delete();
        }
    }

    public void test_unwanted_comment() throws IOException {
        this.m_t = new Tokenizer("; this whole thing is a comment\n");
        Tokenizer.Token tt = this.m_t.get();
        TokenizerTest.assertEquals(1, tt.type);
    }

    public void test_unwanted_ungotten_whitespace() throws IOException {
        this.m_t = new Tokenizer(" ");
        Tokenizer.Token tt = this.m_t.get(true, true);
        this.m_t.unget();
        tt = this.m_t.get();
        TokenizerTest.assertEquals(0, tt.type);
    }

    public void test_unwanted_ungotten_comment() throws IOException {
        this.m_t = new Tokenizer("; this whole thing is a comment");
        Tokenizer.Token tt = this.m_t.get(true, true);
        this.m_t.unget();
        tt = this.m_t.get();
        TokenizerTest.assertEquals(0, tt.type);
    }

    public void test_empty_string() throws IOException {
        this.m_t = new Tokenizer("");
        Tokenizer.Token tt = this.m_t.get();
        TokenizerTest.assertEquals(0, tt.type);
        this.m_t = new Tokenizer(" ");
        tt = this.m_t.get();
        TokenizerTest.assertEquals(0, tt.type);
    }

    public void test_multiple_ungets() throws IOException {
        this.m_t = new Tokenizer("a simple one");
        Tokenizer.Token tt = this.m_t.get();
        this.m_t.unget();
        try {
            this.m_t.unget();
            TokenizerTest.fail("IllegalStateException not thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void test_getString() throws IOException {
        this.m_t = new Tokenizer("just_an_identifier");
        String out = this.m_t.getString();
        TokenizerTest.assertEquals("just_an_identifier", out);
        this.m_t = new Tokenizer("\"just a string\"");
        out = this.m_t.getString();
        TokenizerTest.assertEquals("just a string", out);
        this.m_t = new Tokenizer("; just a comment");
        try {
            out = this.m_t.getString();
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }

    public void test_getIdentifier() throws IOException {
        this.m_t = new Tokenizer("just_an_identifier");
        String out = this.m_t.getIdentifier();
        TokenizerTest.assertEquals("just_an_identifier", out);
        this.m_t = new Tokenizer("\"just a string\"");
        try {
            this.m_t.getIdentifier();
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }

    public void test_getLong() throws IOException {
        this.m_t = new Tokenizer("2147483648");
        long out = this.m_t.getLong();
        TokenizerTest.assertEquals(0x80000000L, out);
        this.m_t = new Tokenizer("-10");
        try {
            this.m_t.getLong();
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        this.m_t = new Tokenizer("19_identifier");
        try {
            this.m_t.getLong();
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }

    public void test_getUInt32() throws IOException {
        this.m_t = new Tokenizer("2882400018");
        long out = this.m_t.getUInt32();
        TokenizerTest.assertEquals(2882400018L, out);
        this.m_t = new Tokenizer("4294967296");
        try {
            this.m_t.getUInt32();
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        this.m_t = new Tokenizer("-12345");
        try {
            this.m_t.getUInt32();
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }

    public void test_getUInt16() throws IOException {
        this.m_t = new Tokenizer("43981");
        int out = this.m_t.getUInt16();
        TokenizerTest.assertEquals(43981L, (long)out);
        this.m_t = new Tokenizer("65536");
        try {
            this.m_t.getUInt16();
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        this.m_t = new Tokenizer("-125");
        try {
            this.m_t.getUInt16();
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }

    public void test_getUInt8() throws IOException {
        this.m_t = new Tokenizer("205");
        int out = this.m_t.getUInt8();
        TokenizerTest.assertEquals(205L, (long)out);
        this.m_t = new Tokenizer("256");
        try {
            this.m_t.getUInt8();
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        this.m_t = new Tokenizer("-12");
        try {
            this.m_t.getUInt8();
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }

    public void test_getTTL() throws IOException {
        this.m_t = new Tokenizer("59S");
        TokenizerTest.assertEquals(59L, this.m_t.getTTL());
        this.m_t = new Tokenizer("2147483647");
        TokenizerTest.assertEquals(Integer.MAX_VALUE, this.m_t.getTTL());
        this.m_t = new Tokenizer("2147483648");
        TokenizerTest.assertEquals(Integer.MAX_VALUE, this.m_t.getTTL());
        this.m_t = new Tokenizer("Junk");
        try {
            this.m_t.getTTL();
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }

    public void test_getTTLLike() throws IOException {
        this.m_t = new Tokenizer("59S");
        TokenizerTest.assertEquals(59L, this.m_t.getTTLLike());
        this.m_t = new Tokenizer("2147483647");
        TokenizerTest.assertEquals(Integer.MAX_VALUE, this.m_t.getTTLLike());
        this.m_t = new Tokenizer("2147483648");
        TokenizerTest.assertEquals(0x80000000L, this.m_t.getTTLLike());
        this.m_t = new Tokenizer("Junk");
        try {
            this.m_t.getTTLLike();
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }

    public void test_getName() throws IOException, TextParseException {
        Name root = Name.fromString(".");
        this.m_t = new Tokenizer("junk");
        Name exp = Name.fromString("junk.");
        Name out = this.m_t.getName(root);
        TokenizerTest.assertEquals(exp, out);
        Name rel = Name.fromString("you.dig");
        this.m_t = new Tokenizer("junk");
        try {
            this.m_t.getName(rel);
            TokenizerTest.fail("RelativeNameException not thrown");
        }
        catch (RelativeNameException e) {
            // empty catch block
        }
        this.m_t = new Tokenizer("");
        try {
            this.m_t.getName(root);
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
    }

    public void test_getEOL() throws IOException {
        this.m_t = new Tokenizer("id");
        this.m_t.getIdentifier();
        try {
            this.m_t.getEOL();
        }
        catch (TextParseException e) {
            TokenizerTest.fail(e.getMessage());
        }
        this.m_t = new Tokenizer("\n");
        try {
            this.m_t.getEOL();
            this.m_t.getEOL();
        }
        catch (TextParseException e) {
            TokenizerTest.fail(e.getMessage());
        }
        this.m_t = new Tokenizer("id");
        try {
            this.m_t.getEOL();
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }

    public void test_getBase64() throws IOException {
        byte[] exp = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        this.m_t = new Tokenizer("AQIDBAUGBwgJ");
        byte[] out = this.m_t.getBase64();
        this.assertEquals(exp, out);
        this.m_t = new Tokenizer("AQIDB AUGB   wgJ");
        out = this.m_t.getBase64();
        this.assertEquals(exp, out);
        this.m_t = new Tokenizer("AQIDBAUGBwgJ\nAB23DK");
        out = this.m_t.getBase64();
        this.assertEquals(exp, out);
        this.m_t = new Tokenizer("\n");
        TokenizerTest.assertNull(this.m_t.getBase64());
        this.m_t = new Tokenizer("\n");
        try {
            this.m_t.getBase64(true);
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        this.m_t = new Tokenizer("not_base64");
        try {
            this.m_t.getBase64(false);
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        this.m_t = new Tokenizer("not_base64");
        try {
            this.m_t.getBase64(true);
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }

    public void test_getHex() throws IOException {
        byte[] exp = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        this.m_t = new Tokenizer("0102030405060708090A0B0C0D0E0F");
        byte[] out = this.m_t.getHex();
        this.assertEquals(exp, out);
        this.m_t = new Tokenizer("0102030 405 060708090A0B0C      0D0E0F");
        out = this.m_t.getHex();
        this.assertEquals(exp, out);
        this.m_t = new Tokenizer("0102030405060708090A0B0C0D0E0F\n01AB3FE");
        out = this.m_t.getHex();
        this.assertEquals(exp, out);
        this.m_t = new Tokenizer("\n");
        TokenizerTest.assertNull(this.m_t.getHex());
        this.m_t = new Tokenizer("\n");
        try {
            this.m_t.getHex(true);
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        this.m_t = new Tokenizer("not_hex");
        try {
            this.m_t.getHex(false);
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        this.m_t = new Tokenizer("not_hex");
        try {
            this.m_t.getHex(true);
            TokenizerTest.fail("TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }
}

