/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import junit.framework.TestCase;
import org.xbill.DNS.Serial;

public class SerialTest
extends TestCase {
    public void test_compare_NegativeArg1() {
        long arg1 = -1L;
        long arg2 = 1L;
        try {
            Serial.compare(arg1, arg2);
            SerialTest.fail("compare accepted negative argument 1");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void test_compare_OOBArg1() {
        long arg1 = 0x100000000L;
        long arg2 = 1L;
        try {
            Serial.compare(arg1, arg2);
            SerialTest.fail("compare accepted out-of-bounds argument 1");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void test_compare_NegativeArg2() {
        long arg1 = 1L;
        long arg2 = -1L;
        try {
            Serial.compare(arg1, arg2);
            SerialTest.fail("compare accepted negative argument 2");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void test_compare_OOBArg2() {
        long arg1 = 1L;
        long arg2 = 0x100000000L;
        try {
            Serial.compare(arg1, arg2);
            SerialTest.fail("compare accepted out-of-bounds argument 1");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void test_compare_Arg1Greater() {
        long arg1 = 10L;
        long arg2 = 9L;
        int ret = Serial.compare(arg1, arg2);
        SerialTest.assertTrue(ret > 0);
    }

    public void test_compare_Arg2Greater() {
        long arg1 = 9L;
        long arg2 = 10L;
        int ret = Serial.compare(arg1, arg2);
        SerialTest.assertTrue(ret < 0);
    }

    public void test_compare_ArgsEqual() {
        long arg1 = 10L;
        long arg2 = 10L;
        int ret = Serial.compare(arg1, arg2);
        SerialTest.assertEquals(ret, 0);
    }

    public void test_compare_boundary() {
        long arg1 = 0xFFFFFFFFL;
        long arg2 = 0L;
        int ret = Serial.compare(arg1, arg2);
        SerialTest.assertEquals(-1, ret);
        ret = Serial.compare(arg2, arg1);
        SerialTest.assertEquals(1, ret);
    }

    public void test_increment_NegativeArg() {
        long arg = -1L;
        try {
            Serial.increment(arg);
            SerialTest.fail("increment accepted negative argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_increment_OOBArg() {
        long arg = 0x100000000L;
        try {
            Serial.increment(arg);
            SerialTest.fail("increment accepted out-of-bounds argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_increment_reset() {
        long arg = 0xFFFFFFFFL;
        long ret = Serial.increment(arg);
        SerialTest.assertEquals(0L, ret);
    }

    public void test_increment_normal() {
        long arg = 10L;
        long ret = Serial.increment(arg);
        SerialTest.assertEquals(arg + 1L, ret);
    }
}

