/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;

public class SOARecordTest {
    private static final Random m_random = new Random();

    private static long randomU16() {
        return m_random.nextLong() >>> 48;
    }

    private static long randomU32() {
        return m_random.nextLong() >>> 32;
    }

    public static Test suite() {
        TestSuite s = new TestSuite();
        s.addTestSuite(Test_init.class);
        s.addTestSuite(Test_rrFromWire.class);
        s.addTestSuite(Test_rdataFromString.class);
        s.addTestSuite(Test_rrToString.class);
        s.addTestSuite(Test_rrToWire.class);
        return s;
    }

    public static class Test_rrToWire
    extends TestCase {
        private Name m_an;
        private Name m_host;
        private Name m_admin;
        private long m_ttl;
        private long m_serial;
        private long m_refresh;
        private long m_retry;
        private long m_expire;
        private long m_minimum;

        protected void setUp() throws TextParseException {
            this.m_an = Name.fromString("My.Abs.Name.");
            this.m_ttl = 5032L;
            this.m_host = Name.fromString("M.h.N.");
            this.m_admin = Name.fromString("M.a.n.");
            this.m_serial = 2882400018L;
            this.m_refresh = 3454997044L;
            this.m_retry = 4010947670L;
            this.m_expire = 305419896L;
            this.m_minimum = 878082202L;
        }

        public void test_canonical() {
            byte[] exp = new byte[]{1, 109, 1, 104, 1, 110, 0, 1, 109, 1, 97, 1, 110, 0, -85, -51, -17, 18, -51, -17, 18, 52, -17, 18, 52, 86, 18, 52, 86, 120, 52, 86, 120, -102};
            SOARecord ar = new SOARecord(this.m_an, 1, this.m_ttl, this.m_host, this.m_admin, this.m_serial, this.m_refresh, this.m_retry, this.m_expire, this.m_minimum);
            DNSOutput o = new DNSOutput();
            ar.rrToWire(o, null, true);
            Test_rrToWire.assertTrue(Arrays.equals(exp, o.toByteArray()));
        }

        public void test_case_sensitive() {
            byte[] exp = new byte[]{1, 77, 1, 104, 1, 78, 0, 1, 77, 1, 97, 1, 110, 0, -85, -51, -17, 18, -51, -17, 18, 52, -17, 18, 52, 86, 18, 52, 86, 120, 52, 86, 120, -102};
            SOARecord ar = new SOARecord(this.m_an, 1, this.m_ttl, this.m_host, this.m_admin, this.m_serial, this.m_refresh, this.m_retry, this.m_expire, this.m_minimum);
            DNSOutput o = new DNSOutput();
            ar.rrToWire(o, null, false);
            Test_rrToWire.assertTrue(Arrays.equals(exp, o.toByteArray()));
        }
    }

    public static class Test_rrToString
    extends TestCase {
        private Name m_an;
        private Name m_host;
        private Name m_admin;
        private long m_ttl;
        private long m_serial;
        private long m_refresh;
        private long m_retry;
        private long m_expire;
        private long m_minimum;

        protected void setUp() throws TextParseException {
            this.m_an = Name.fromString("My.absolute.name.");
            this.m_ttl = 5032L;
            this.m_host = Name.fromString("M.h.N.");
            this.m_admin = Name.fromString("M.a.n.");
            this.m_serial = 2882400018L;
            this.m_refresh = 3454997044L;
            this.m_retry = 4010947670L;
            this.m_expire = 305419896L;
            this.m_minimum = 878082202L;
        }

        public void test_singleLine() {
            SOARecord ar = new SOARecord(this.m_an, 1, this.m_ttl, this.m_host, this.m_admin, this.m_serial, this.m_refresh, this.m_retry, this.m_expire, this.m_minimum);
            String exp = this.m_host + " " + this.m_admin + " " + this.m_serial + " " + this.m_refresh + " " + this.m_retry + " " + this.m_expire + " " + this.m_minimum;
            String out = ar.rrToString();
            Test_rrToString.assertEquals(exp, out);
        }

        public void test_multiLine() {
            SOARecord ar = new SOARecord(this.m_an, 1, this.m_ttl, this.m_host, this.m_admin, this.m_serial, this.m_refresh, this.m_retry, this.m_expire, this.m_minimum);
            String re = "^.*\\(\\n\\s*" + this.m_serial + "\\s*;\\s*serial\\n" + "\\s*" + this.m_refresh + "\\s*;\\s*refresh\\n" + "\\s*" + this.m_retry + "\\s*;\\s*retry\\n" + "\\s*" + this.m_expire + "\\s*;\\s*expire\\n" + "\\s*" + this.m_minimum + "\\s*\\)\\s*;\\s*minimum$";
            Options.set("multiline");
            String out = ar.rrToString();
            Options.unset("multiline");
            Test_rrToString.assertTrue(out.matches(re));
        }
    }

    public static class Test_rdataFromString
    extends TestCase {
        private Name m_host;
        private Name m_admin;
        private Name m_origin;
        private long m_serial;
        private long m_refresh;
        private long m_retry;
        private long m_expire;
        private long m_minimum;

        protected void setUp() throws TextParseException, UnknownHostException {
            this.m_origin = Name.fromString("O.");
            this.m_host = Name.fromString("M.h", this.m_origin);
            this.m_admin = Name.fromString("M.a.n.");
            this.m_serial = 2882400018L;
            this.m_refresh = 3454997044L;
            this.m_retry = 4010947670L;
            this.m_expire = 305419896L;
            this.m_minimum = 878082202L;
        }

        public void test_valid() throws IOException {
            Tokenizer t = new Tokenizer("M.h " + this.m_admin + " " + this.m_serial + " " + this.m_refresh + " " + this.m_retry + " " + this.m_expire + " " + this.m_minimum);
            SOARecord ar = new SOARecord();
            ar.rdataFromString(t, this.m_origin);
            Test_rdataFromString.assertEquals(this.m_host, ar.getHost());
            Test_rdataFromString.assertEquals(this.m_admin, ar.getAdmin());
            Test_rdataFromString.assertEquals(this.m_serial, ar.getSerial());
            Test_rdataFromString.assertEquals(this.m_refresh, ar.getRefresh());
            Test_rdataFromString.assertEquals(this.m_retry, ar.getRetry());
            Test_rdataFromString.assertEquals(this.m_expire, ar.getExpire());
            Test_rdataFromString.assertEquals(this.m_minimum, ar.getMinimum());
        }

        public void test_relative_name() throws IOException {
            Tokenizer t = new Tokenizer("M.h " + this.m_admin + " " + this.m_serial + " " + this.m_refresh + " " + this.m_retry + " " + this.m_expire + " " + this.m_minimum);
            SOARecord ar = new SOARecord();
            try {
                ar.rdataFromString(t, null);
                Test_rdataFromString.fail("RelativeNameException not thrown");
            }
            catch (RelativeNameException relativeNameException) {
                // empty catch block
            }
        }
    }

    public static class Test_rrFromWire
    extends TestCase {
        private Name m_host;
        private Name m_admin;
        private long m_serial;
        private long m_refresh;
        private long m_retry;
        private long m_expire;
        private long m_minimum;

        protected void setUp() throws TextParseException, UnknownHostException {
            this.m_host = Name.fromString("M.h.N.");
            this.m_admin = Name.fromString("M.a.n.");
            this.m_serial = 2882400018L;
            this.m_refresh = 3454997044L;
            this.m_retry = 4010947670L;
            this.m_expire = 305419896L;
            this.m_minimum = 878082202L;
        }

        public void test() throws IOException {
            byte[] raw = new byte[]{1, 109, 1, 104, 1, 110, 0, 1, 109, 1, 97, 1, 110, 0, -85, -51, -17, 18, -51, -17, 18, 52, -17, 18, 52, 86, 18, 52, 86, 120, 52, 86, 120, -102};
            DNSInput di = new DNSInput(raw);
            SOARecord ar = new SOARecord();
            ar.rrFromWire(di);
            Test_rrFromWire.assertEquals(this.m_host, ar.getHost());
            Test_rrFromWire.assertEquals(this.m_admin, ar.getAdmin());
            Test_rrFromWire.assertEquals(this.m_serial, ar.getSerial());
            Test_rrFromWire.assertEquals(this.m_refresh, ar.getRefresh());
            Test_rrFromWire.assertEquals(this.m_retry, ar.getRetry());
            Test_rrFromWire.assertEquals(this.m_expire, ar.getExpire());
            Test_rrFromWire.assertEquals(this.m_minimum, ar.getMinimum());
        }
    }

    public static class Test_init
    extends TestCase {
        private Name m_an;
        private Name m_rn;
        private Name m_host;
        private Name m_admin;
        private long m_ttl;
        private long m_serial;
        private long m_refresh;
        private long m_retry;
        private long m_expire;
        private long m_minimum;

        protected void setUp() throws TextParseException, UnknownHostException {
            this.m_an = Name.fromString("My.Absolute.Name.");
            this.m_rn = Name.fromString("My.Relative.Name");
            this.m_host = Name.fromString("My.Host.Name.");
            this.m_admin = Name.fromString("My.Administrative.Name.");
            this.m_ttl = SOARecordTest.randomU16();
            this.m_serial = SOARecordTest.randomU32();
            this.m_refresh = SOARecordTest.randomU32();
            this.m_retry = SOARecordTest.randomU32();
            this.m_expire = SOARecordTest.randomU32();
            this.m_minimum = SOARecordTest.randomU32();
        }

        public void test_0arg() throws UnknownHostException {
            SOARecord ar = new SOARecord();
            Test_init.assertNull(ar.getName());
            Test_init.assertEquals(0, ar.getType());
            Test_init.assertEquals(0, ar.getDClass());
            Test_init.assertEquals(0L, ar.getTTL());
            Test_init.assertNull(ar.getHost());
            Test_init.assertNull(ar.getAdmin());
            Test_init.assertEquals(0L, ar.getSerial());
            Test_init.assertEquals(0L, ar.getRefresh());
            Test_init.assertEquals(0L, ar.getRetry());
            Test_init.assertEquals(0L, ar.getExpire());
            Test_init.assertEquals(0L, ar.getMinimum());
        }

        public void test_getObject() {
            SOARecord ar = new SOARecord();
            Record r = ar.getObject();
            Test_init.assertTrue(r instanceof SOARecord);
        }

        public void test_10arg() {
            SOARecord ar = new SOARecord(this.m_an, 1, this.m_ttl, this.m_host, this.m_admin, this.m_serial, this.m_refresh, this.m_retry, this.m_expire, this.m_minimum);
            Test_init.assertEquals(this.m_an, ar.getName());
            Test_init.assertEquals(6, ar.getType());
            Test_init.assertEquals(1, ar.getDClass());
            Test_init.assertEquals(this.m_ttl, ar.getTTL());
            Test_init.assertEquals(this.m_host, ar.getHost());
            Test_init.assertEquals(this.m_admin, ar.getAdmin());
            Test_init.assertEquals(this.m_serial, ar.getSerial());
            Test_init.assertEquals(this.m_refresh, ar.getRefresh());
            Test_init.assertEquals(this.m_retry, ar.getRetry());
            Test_init.assertEquals(this.m_expire, ar.getExpire());
            Test_init.assertEquals(this.m_minimum, ar.getMinimum());
        }

        public void test_10arg_relative_name() {
            try {
                new SOARecord(this.m_rn, 1, this.m_ttl, this.m_host, this.m_admin, this.m_serial, this.m_refresh, this.m_retry, this.m_expire, this.m_minimum);
                Test_init.fail("RelativeNameException not thrown");
            }
            catch (RelativeNameException relativeNameException) {
                // empty catch block
            }
        }

        public void test_10arg_relative_host() {
            try {
                new SOARecord(this.m_an, 1, this.m_ttl, this.m_rn, this.m_admin, this.m_serial, this.m_refresh, this.m_retry, this.m_expire, this.m_minimum);
                Test_init.fail("RelativeNameException not thrown");
            }
            catch (RelativeNameException relativeNameException) {
                // empty catch block
            }
        }

        public void test_10arg_relative_admin() {
            try {
                new SOARecord(this.m_an, 1, this.m_ttl, this.m_host, this.m_rn, this.m_serial, this.m_refresh, this.m_retry, this.m_expire, this.m_minimum);
                Test_init.fail("RelativeNameException not thrown");
            }
            catch (RelativeNameException relativeNameException) {
                // empty catch block
            }
        }

        public void test_10arg_negative_serial() {
            try {
                new SOARecord(this.m_an, 1, this.m_ttl, this.m_host, this.m_admin, -1L, this.m_refresh, this.m_retry, this.m_expire, this.m_minimum);
                Test_init.fail("IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_10arg_toobig_serial() {
            try {
                new SOARecord(this.m_an, 1, this.m_ttl, this.m_host, this.m_admin, 0x100000000L, this.m_refresh, this.m_retry, this.m_expire, this.m_minimum);
                Test_init.fail("IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_10arg_negative_refresh() {
            try {
                new SOARecord(this.m_an, 1, this.m_ttl, this.m_host, this.m_admin, this.m_serial, -1L, this.m_retry, this.m_expire, this.m_minimum);
                Test_init.fail("IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_10arg_toobig_refresh() {
            try {
                new SOARecord(this.m_an, 1, this.m_ttl, this.m_host, this.m_admin, this.m_serial, 0x100000000L, this.m_retry, this.m_expire, this.m_minimum);
                Test_init.fail("IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_10arg_negative_retry() {
            try {
                new SOARecord(this.m_an, 1, this.m_ttl, this.m_host, this.m_admin, this.m_serial, this.m_refresh, -1L, this.m_expire, this.m_minimum);
                Test_init.fail("IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_10arg_toobig_retry() {
            try {
                new SOARecord(this.m_an, 1, this.m_ttl, this.m_host, this.m_admin, this.m_serial, this.m_refresh, 0x100000000L, this.m_expire, this.m_minimum);
                Test_init.fail("IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_10arg_negative_expire() {
            try {
                new SOARecord(this.m_an, 1, this.m_ttl, this.m_host, this.m_admin, this.m_serial, this.m_refresh, this.m_retry, -1L, this.m_minimum);
                Test_init.fail("IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_10arg_toobig_expire() {
            try {
                new SOARecord(this.m_an, 1, this.m_ttl, this.m_host, this.m_admin, this.m_serial, this.m_refresh, this.m_retry, 0x100000000L, this.m_minimum);
                Test_init.fail("IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_10arg_negative_minimun() {
            try {
                new SOARecord(this.m_an, 1, this.m_ttl, this.m_host, this.m_admin, this.m_serial, this.m_refresh, this.m_retry, this.m_expire, -1L);
                Test_init.fail("IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void test_10arg_toobig_minimum() {
            try {
                new SOARecord(this.m_an, 1, this.m_ttl, this.m_host, this.m_admin, this.m_serial, this.m_refresh, this.m_retry, this.m_expire, 0x100000000L);
                Test_init.fail("IllegalArgumentException not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

