/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;

public class MessageTest {
    public static Test suite() {
        TestSuite s = new TestSuite();
        s.addTestSuite(Test_init.class);
        return s;
    }

    public static class Test_init
    extends TestCase {
        public void test_0arg() {
            Message m = new Message();
            Test_init.assertTrue(Arrays.equals(new Record[0], m.getSectionArray(0)));
            Test_init.assertTrue(Arrays.equals(new Record[0], m.getSectionArray(1)));
            Test_init.assertTrue(Arrays.equals(new Record[0], m.getSectionArray(2)));
            Test_init.assertTrue(Arrays.equals(new Record[0], m.getSectionArray(3)));
            try {
                m.getSectionArray(4);
                Test_init.fail("IndexOutOfBoundsException not thrown");
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            Header h = m.getHeader();
            Test_init.assertEquals(0, h.getCount(0));
            Test_init.assertEquals(0, h.getCount(1));
            Test_init.assertEquals(0, h.getCount(2));
            Test_init.assertEquals(0, h.getCount(3));
        }

        public void test_1arg() {
            Message m = new Message(10);
            Test_init.assertEquals(new Header(10).toString(), m.getHeader().toString());
            Test_init.assertTrue(Arrays.equals(new Record[0], m.getSectionArray(0)));
            Test_init.assertTrue(Arrays.equals(new Record[0], m.getSectionArray(1)));
            Test_init.assertTrue(Arrays.equals(new Record[0], m.getSectionArray(2)));
            Test_init.assertTrue(Arrays.equals(new Record[0], m.getSectionArray(3)));
            try {
                m.getSectionArray(4);
                Test_init.fail("IndexOutOfBoundsException not thrown");
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            Header h = m.getHeader();
            Test_init.assertEquals(0, h.getCount(0));
            Test_init.assertEquals(0, h.getCount(1));
            Test_init.assertEquals(0, h.getCount(2));
            Test_init.assertEquals(0, h.getCount(3));
        }

        public void test_newQuery() throws TextParseException, UnknownHostException {
            Name n = Name.fromString("The.Name.");
            ARecord ar = new ARecord(n, 1, 1L, InetAddress.getByName("192.168.101.110"));
            Message m = Message.newQuery(ar);
            Test_init.assertTrue(Arrays.equals(new Record[]{ar}, m.getSectionArray(0)));
            Test_init.assertTrue(Arrays.equals(new Record[0], m.getSectionArray(1)));
            Test_init.assertTrue(Arrays.equals(new Record[0], m.getSectionArray(2)));
            Test_init.assertTrue(Arrays.equals(new Record[0], m.getSectionArray(3)));
            Header h = m.getHeader();
            Test_init.assertEquals(1, h.getCount(0));
            Test_init.assertEquals(0, h.getCount(1));
            Test_init.assertEquals(0, h.getCount(2));
            Test_init.assertEquals(0, h.getCount(3));
            Test_init.assertEquals(0, h.getOpcode());
            Test_init.assertEquals(true, h.getFlag(7));
        }
    }
}

