/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;

public class AAAARecordTest
extends TestCase {
    Name m_an;
    Name m_rn;
    InetAddress m_addr;
    String m_addr_string;
    byte[] m_addr_bytes;
    long m_ttl;

    protected void setUp() throws TextParseException, UnknownHostException {
        this.m_an = Name.fromString("My.Absolute.Name.");
        this.m_rn = Name.fromString("My.Relative.Name");
        this.m_addr_string = "2001:db8:85a3:8d3:1319:8a2e:370:7334";
        this.m_addr = InetAddress.getByName(this.m_addr_string);
        this.m_addr_bytes = this.m_addr.getAddress();
        this.m_ttl = 79225L;
    }

    public void test_ctor_0arg() throws UnknownHostException {
        AAAARecord ar = new AAAARecord();
        AAAARecordTest.assertNull(ar.getName());
        AAAARecordTest.assertEquals(0, ar.getType());
        AAAARecordTest.assertEquals(0, ar.getDClass());
        AAAARecordTest.assertEquals(0L, ar.getTTL());
        AAAARecordTest.assertNull(ar.getAddress());
    }

    public void test_getObject() {
        AAAARecord ar = new AAAARecord();
        Record r = ar.getObject();
        AAAARecordTest.assertTrue(r instanceof AAAARecord);
    }

    public void test_ctor_4arg() {
        AAAARecord ar = new AAAARecord(this.m_an, 1, this.m_ttl, this.m_addr);
        AAAARecordTest.assertEquals(this.m_an, ar.getName());
        AAAARecordTest.assertEquals(28, ar.getType());
        AAAARecordTest.assertEquals(1, ar.getDClass());
        AAAARecordTest.assertEquals(this.m_ttl, ar.getTTL());
        AAAARecordTest.assertEquals(this.m_addr, ar.getAddress());
        try {
            new AAAARecord(this.m_rn, 1, this.m_ttl, this.m_addr);
            AAAARecordTest.fail("RelativeNameException not thrown");
        }
        catch (RelativeNameException e) {
            // empty catch block
        }
        try {
            new AAAARecord(this.m_an, 1, this.m_ttl, InetAddress.getByName("192.168.0.1"));
            AAAARecordTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (UnknownHostException e) {
            AAAARecordTest.fail(e.getMessage());
        }
    }

    public void test_rrFromWire() throws IOException {
        DNSInput di = new DNSInput(this.m_addr_bytes);
        AAAARecord ar = new AAAARecord();
        ar.rrFromWire(di);
        AAAARecordTest.assertEquals(this.m_addr, ar.getAddress());
    }

    public void test_rdataFromString() throws IOException {
        Tokenizer t = new Tokenizer(this.m_addr_string);
        AAAARecord ar = new AAAARecord();
        ar.rdataFromString(t, null);
        AAAARecordTest.assertEquals(this.m_addr, ar.getAddress());
        t = new Tokenizer("193.160.232.1");
        ar = new AAAARecord();
        try {
            ar.rdataFromString(t, null);
            AAAARecordTest.fail("TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }

    public void test_rrToString() {
        AAAARecord ar = new AAAARecord(this.m_an, 1, this.m_ttl, this.m_addr);
        AAAARecordTest.assertEquals(this.m_addr_string, ar.rrToString());
    }

    public void test_rrToWire() {
        AAAARecord ar = new AAAARecord(this.m_an, 1, this.m_ttl, this.m_addr);
        DNSOutput dout = new DNSOutput();
        ar.rrToWire(dout, null, true);
        AAAARecordTest.assertTrue(Arrays.equals(this.m_addr_bytes, dout.toByteArray()));
        dout = new DNSOutput();
        ar.rrToWire(dout, null, false);
        AAAARecordTest.assertTrue(Arrays.equals(this.m_addr_bytes, dout.toByteArray()));
    }
}

