/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.embedded;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.derby.impl.io.VFMemoryStorageFactory;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.springframework.jdbc.datasource.embedded.ConnectionProperties;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseConfigurer;
import org.springframework.jdbc.datasource.embedded.OutputStreamFactory;

final class DerbyEmbeddedDatabaseConfigurer
implements EmbeddedDatabaseConfigurer {
    private static final Log logger = LogFactory.getLog(DerbyEmbeddedDatabaseConfigurer.class);
    private static final String URL_TEMPLATE = "jdbc:derby:memory:%s;%s";
    private static final String SHUTDOWN_CODE = "08006";
    private static final boolean IS_AT_LEAST_DOT_SIX = new EmbeddedDriver().getMinorVersion() >= 6;
    private static final String SHUTDOWN_COMMAND = String.format("%s=true", IS_AT_LEAST_DOT_SIX ? "drop" : "shutdown");
    private static DerbyEmbeddedDatabaseConfigurer INSTANCE;

    public static synchronized DerbyEmbeddedDatabaseConfigurer getInstance() throws ClassNotFoundException {
        if (INSTANCE == null) {
            System.setProperty("derby.stream.error.method", String.valueOf(OutputStreamFactory.class.getName()) + ".getNoopOutputStream");
            INSTANCE = new DerbyEmbeddedDatabaseConfigurer();
        }
        return INSTANCE;
    }

    private DerbyEmbeddedDatabaseConfigurer() {
    }

    public void configureConnectionProperties(ConnectionProperties properties, String databaseName) {
        properties.setDriverClass(EmbeddedDriver.class);
        properties.setUrl(String.format(URL_TEMPLATE, databaseName, "create=true"));
        properties.setUsername("sa");
        properties.setPassword("");
    }

    public void shutdown(DataSource dataSource, String databaseName) {
        block5: {
            try {
                new EmbeddedDriver().connect(String.format(URL_TEMPLATE, databaseName, SHUTDOWN_COMMAND), new Properties());
            }
            catch (SQLException ex) {
                if (!SHUTDOWN_CODE.equals(ex.getSQLState())) {
                    logger.warn("Could not shutdown in-memory Derby database", ex);
                    return;
                }
                if (IS_AT_LEAST_DOT_SIX) break block5;
                try {
                    VFMemoryStorageFactory.purgeDatabase((String)new File(databaseName).getCanonicalPath());
                }
                catch (IOException ex2) {
                    logger.warn("Could not purge in-memory Derby database", ex2);
                }
            }
        }
    }
}

