/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.ColumnTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpStrategy;
import org.opennms.netmgt.snmp.SnmpTrapBuilder;
import org.opennms.netmgt.snmp.SnmpV1TrapBuilder;
import org.opennms.netmgt.snmp.SnmpV2TrapBuilder;
import org.opennms.netmgt.snmp.SnmpV3TrapBuilder;
import org.opennms.netmgt.snmp.SnmpV3User;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpValueFactory;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.netmgt.snmp.TrapNotificationListener;
import org.opennms.netmgt.snmp.TrapProcessorFactory;
import org.springframework.core.io.Resource;

public class SnmpUtils {
    public static final Pattern HEX_PATTERN = Pattern.compile("^[a-fA-F0-9 :]*$");
    public static final Pattern HEX_CHUNK_PATTERN = Pattern.compile("(..)[ :]?");
    private static Properties sm_config;
    static final byte[] HEX_CHAR_TABLE;

    public static SnmpWalker createWalker(SnmpAgentConfig agentConfig, String name, CollectionTracker ... trackers) {
        return SnmpUtils.getStrategy().createWalker(agentConfig, name, SnmpUtils.createTooBigTracker(agentConfig, trackers));
    }

    private static TooBigReportingAggregator createTooBigTracker(SnmpAgentConfig agentConfig, CollectionTracker ... trackers) {
        return new TooBigReportingAggregator(trackers, agentConfig.getAddress());
    }

    public static SnmpWalker createWalker(SnmpAgentConfig agentConfig, String name, CollectionTracker tracker) {
        return SnmpUtils.getStrategy().createWalker(agentConfig, name, SnmpUtils.createTooBigTracker(agentConfig, tracker));
    }

    private static TooBigReportingAggregator createTooBigTracker(SnmpAgentConfig agentConfig, CollectionTracker tracker) {
        return SnmpUtils.createTooBigTracker(agentConfig, new CollectionTracker[]{tracker});
    }

    public static SnmpValue get(SnmpAgentConfig agentConfig, SnmpObjId oid) {
        return SnmpUtils.getStrategy().get(agentConfig, oid);
    }

    public static SnmpValue[] get(SnmpAgentConfig agentConfig, SnmpObjId[] oids) {
        return SnmpUtils.getStrategy().get(agentConfig, oids);
    }

    public static SnmpValue getNext(SnmpAgentConfig agentConfig, SnmpObjId oid) {
        return SnmpUtils.getStrategy().getNext(agentConfig, oid);
    }

    public static SnmpValue[] getNext(SnmpAgentConfig agentConfig, SnmpObjId[] oids) {
        return SnmpUtils.getStrategy().getNext(agentConfig, oids);
    }

    public static SnmpValue[] getBulk(SnmpAgentConfig agentConfig, SnmpObjId[] oids) {
        return SnmpUtils.getStrategy().getBulk(agentConfig, oids);
    }

    public static SnmpValue set(SnmpAgentConfig agentConfig, SnmpObjId oid, SnmpValue value) {
        return SnmpUtils.getStrategy().set(agentConfig, oid, value);
    }

    public static SnmpValue[] set(SnmpAgentConfig agentConfig, SnmpObjId[] oids, SnmpValue[] values) {
        return SnmpUtils.getStrategy().set(agentConfig, oids, values);
    }

    public static Properties getConfig() {
        return sm_config == null ? System.getProperties() : sm_config;
    }

    public static List<SnmpValue> getColumns(SnmpAgentConfig agentConfig, String name, SnmpObjId oid) throws InterruptedException {
        final ArrayList<SnmpValue> results = new ArrayList<SnmpValue>();
        SnmpWalker walker = SnmpUtils.createWalker(agentConfig, name, (CollectionTracker)new ColumnTracker(oid){

            @Override
            protected void storeResult(SnmpResult res) {
                results.add(res.getValue());
            }
        });
        walker.start();
        walker.waitFor();
        return results;
    }

    public static Map<SnmpInstId, SnmpValue> getOidValues(SnmpAgentConfig agentConfig, String name, SnmpObjId oid) throws InterruptedException {
        final LinkedHashMap<SnmpInstId, SnmpValue> results = new LinkedHashMap<SnmpInstId, SnmpValue>();
        SnmpWalker walker = SnmpUtils.createWalker(agentConfig, name, (CollectionTracker)new ColumnTracker(oid){

            @Override
            protected void storeResult(SnmpResult res) {
                results.put(res.getInstance(), res.getValue());
            }
        });
        walker.start();
        walker.waitFor();
        return results;
    }

    public static void setConfig(Properties config) {
        sm_config = config;
    }

    public static SnmpStrategy getStrategy() {
        String strategyClass = SnmpUtils.getStrategyClassName();
        try {
            return (SnmpStrategy)Class.forName(strategyClass).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate class " + strategyClass, e);
        }
    }

    private static String getStrategyClassName() {
        return SnmpUtils.getConfig().getProperty("org.opennms.snmp.strategyClass", "org.opennms.netmgt.snmp.snmp4j.Snmp4JStrategy");
    }

    public static void registerForTraps(TrapNotificationListener listener, TrapProcessorFactory processorFactory, InetAddress address, int snmpTrapPort, List<SnmpV3User> snmpUsers) throws IOException {
        SnmpUtils.getStrategy().registerForTraps(listener, processorFactory, address, snmpTrapPort, snmpUsers);
    }

    public static void registerForTraps(TrapNotificationListener listener, TrapProcessorFactory processorFactory, InetAddress address, int snmpTrapPort) throws IOException {
        SnmpUtils.getStrategy().registerForTraps(listener, processorFactory, address, snmpTrapPort);
    }

    public static void unregisterForTraps(TrapNotificationListener listener, InetAddress address, int snmpTrapPort) throws IOException {
        SnmpUtils.getStrategy().unregisterForTraps(listener, snmpTrapPort);
    }

    public static SnmpValueFactory getValueFactory() {
        return SnmpUtils.getStrategy().getValueFactory();
    }

    public static SnmpV1TrapBuilder getV1TrapBuilder() {
        return SnmpUtils.getStrategy().getV1TrapBuilder();
    }

    public static SnmpTrapBuilder getV2TrapBuilder() {
        return SnmpUtils.getStrategy().getV2TrapBuilder();
    }

    public static SnmpV3TrapBuilder getV3TrapBuilder() {
        return SnmpUtils.getStrategy().getV3TrapBuilder();
    }

    public static SnmpV2TrapBuilder getV2InformBuilder() {
        return SnmpUtils.getStrategy().getV2InformBuilder();
    }

    public static SnmpV3TrapBuilder getV3InformBuilder() {
        return SnmpUtils.getStrategy().getV3InformBuilder();
    }

    public static String getLocalEngineID() {
        return SnmpUtils.getHexString(SnmpUtils.getStrategy().getLocalEngineID());
    }

    public static String getHexString(byte[] raw) {
        byte[] hex = new byte[2 * raw.length];
        int index = 0;
        for (byte b : raw) {
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
        }
        try {
            return new String(hex, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean allBytesDisplayable(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 0) {
                if (i == bytes.length - 1) continue;
                return false;
            }
            if (b < 32 && b != 9 && b != 10 && b != 13) {
                return false;
            }
            if (b != 127) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(Resource propertiesFile) {
        Properties moProps = new Properties();
        InputStream inStream = null;
        try {
            inStream = propertiesFile.getInputStream();
            moProps.load(inStream);
        }
        catch (Exception ex) {
            LogUtils.warnf(SnmpUtils.class, ex, "Unable to read property file %s", propertiesFile);
            Properties properties = null;
            return properties;
        }
        finally {
            IOUtils.closeQuietly(inStream);
        }
        return moProps;
    }

    public static SnmpValue parseMibValue(String mibVal) {
        if (mibVal.startsWith("OID:")) {
            return SnmpUtils.getValueFactory().getObjectId(SnmpObjId.get(mibVal.substring("OID:".length()).trim()));
        }
        if (mibVal.startsWith("Timeticks:")) {
            String timeticks = mibVal.substring("Timeticks:".length()).trim();
            if (timeticks.contains("(")) {
                timeticks = timeticks.replaceAll("^.*\\((\\d*?)\\).*$", "$1");
            }
            return SnmpUtils.getValueFactory().getTimeTicks(Long.valueOf(timeticks));
        }
        if (mibVal.startsWith("STRING:")) {
            return SnmpUtils.getValueFactory().getOctetString(mibVal.substring("STRING:".length()).trim().getBytes());
        }
        if (mibVal.startsWith("INTEGER:")) {
            return SnmpUtils.getValueFactory().getInt32(Integer.valueOf(mibVal.substring("INTEGER:".length()).trim().replaceAll(" *.[Bb]ytes$", "")));
        }
        if (mibVal.startsWith("Gauge32:")) {
            return SnmpUtils.getValueFactory().getGauge32(Long.valueOf(mibVal.substring("Gauge32:".length()).trim()));
        }
        if (mibVal.startsWith("Counter32:")) {
            return SnmpUtils.getValueFactory().getCounter32(Long.valueOf(mibVal.substring("Counter32:".length()).trim()));
        }
        if (mibVal.startsWith("Counter64:")) {
            return SnmpUtils.getValueFactory().getCounter64(BigInteger.valueOf(Long.valueOf(mibVal.substring("Counter64:".length()).trim())));
        }
        if (mibVal.startsWith("IpAddress:")) {
            return SnmpUtils.getValueFactory().getIpAddress(InetAddressUtils.addr(mibVal.substring("IpAddress:".length()).trim()));
        }
        if (mibVal.startsWith("Hex-STRING:")) {
            String trimmed = mibVal.substring("Hex-STRING:".length()).trim();
            ByteBuffer bb = ByteBuffer.allocate(trimmed.length());
            if (trimmed.matches("^.*[ :].*$")) {
                for (String chunk : trimmed.split("[ :]")) {
                    short s = Short.valueOf(chunk, 16);
                    bb.put((byte)(s & 0xFF));
                }
            } else {
                if (trimmed.length() % 2 != 0) {
                    LogUtils.warnf(SnmpUtils.class, "Hex-STRING %s does not have ' ' or ':' separators, but it is an uneven number of characters.", trimmed);
                }
                Matcher m = HEX_CHUNK_PATTERN.matcher(trimmed);
                while (m.find()) {
                    short s = Short.valueOf(m.group(1), 16);
                    bb.put((byte)(s & 0xFF));
                }
            }
            byte[] parsed = new byte[bb.position()];
            bb.flip();
            bb.get(parsed);
            return SnmpUtils.getValueFactory().getOctetString(parsed);
        }
        if (mibVal.startsWith("Network Address:")) {
            return SnmpUtils.getValueFactory().getOctetString(mibVal.substring("Network Address:".length()).trim().getBytes());
        }
        if (mibVal.startsWith("BITS:")) {
            return SnmpUtils.getValueFactory().getOctetString(mibVal.substring("BITS:".length()).trim().getBytes());
        }
        if (mibVal.equals("\"\"")) {
            return SnmpUtils.getValueFactory().getNull();
        }
        throw new IllegalArgumentException("Unknown Snmp Type: " + mibVal);
    }

    static {
        HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    }

    private static final class TooBigReportingAggregator
    extends AggregateTracker {
        private final InetAddress address;

        private TooBigReportingAggregator(CollectionTracker[] children, InetAddress address) {
            super(children);
            this.address = address;
        }

        @Override
        protected void reportTooBigErr(String msg) {
            ThreadCategory.getInstance(SnmpWalker.class).info("Received tooBig response from " + this.address + ". " + msg);
        }
    }
}

