/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.net.InetAddress;
import java.net.UnknownHostException;
import junit.framework.TestCase;
import org.xbill.DNS.Name;
import org.xbill.DNS.ReverseMap;
import org.xbill.DNS.TextParseException;

public class ReverseMapTest
extends TestCase {
    public void test_fromAddress_ipv4() throws UnknownHostException, TextParseException {
        Name exp = Name.fromString("1.0.168.192.in-addr.arpa.");
        String addr = "192.168.0.1";
        ReverseMapTest.assertEquals(exp, ReverseMap.fromAddress(addr));
        ReverseMapTest.assertEquals(exp, ReverseMap.fromAddress(addr, 1));
        ReverseMapTest.assertEquals(exp, ReverseMap.fromAddress(InetAddress.getByName(addr)));
        ReverseMapTest.assertEquals(exp, ReverseMap.fromAddress(new byte[]{-64, -88, 0, 1}));
        ReverseMapTest.assertEquals(exp, ReverseMap.fromAddress(new int[]{192, 168, 0, 1}));
    }

    public void test_fromAddress_ipv6() throws UnknownHostException, TextParseException {
        Name exp = Name.fromString("4.3.3.7.0.7.3.0.E.2.A.8.9.1.3.1.3.D.8.0.3.A.5.8.8.B.D.0.1.0.0.2.ip6.arpa.");
        String addr = "2001:0db8:85a3:08d3:1319:8a2e:0370:7334";
        byte[] dat = new byte[]{32, 1, 13, -72, -123, -93, 8, -45, 19, 25, -118, 46, 3, 112, 115, 52};
        int[] idat = new int[]{32, 1, 13, 184, 133, 163, 8, 211, 19, 25, 138, 46, 3, 112, 115, 52};
        ReverseMapTest.assertEquals(exp, ReverseMap.fromAddress(addr, 2));
        ReverseMapTest.assertEquals(exp, ReverseMap.fromAddress(InetAddress.getByName(addr)));
        ReverseMapTest.assertEquals(exp, ReverseMap.fromAddress(dat));
        ReverseMapTest.assertEquals(exp, ReverseMap.fromAddress(idat));
    }

    public void test_fromAddress_invalid() {
        try {
            ReverseMap.fromAddress("A.B.C.D", 1);
            ReverseMapTest.fail("UnknownHostException not thrown");
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        try {
            ReverseMap.fromAddress(new byte[0]);
            ReverseMapTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ReverseMap.fromAddress(new byte[3]);
            ReverseMapTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ReverseMap.fromAddress(new byte[5]);
            ReverseMapTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ReverseMap.fromAddress(new byte[15]);
            ReverseMapTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ReverseMap.fromAddress(new byte[17]);
            ReverseMapTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            int[] dat = new int[]{0, 1, 2, 256};
            ReverseMap.fromAddress(dat);
            ReverseMapTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

