/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Iterator;
import junit.framework.TestCase;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;

public class RRsetTest
extends TestCase {
    private RRset m_rs;
    Name m_name;
    Name m_name2;
    long m_ttl;
    ARecord m_a1;
    ARecord m_a2;
    RRSIGRecord m_s1;
    RRSIGRecord m_s2;

    public void setUp() throws TextParseException, UnknownHostException {
        this.m_rs = new RRset();
        this.m_name = Name.fromString("this.is.a.test.");
        this.m_name2 = Name.fromString("this.is.another.test.");
        this.m_ttl = 43981L;
        this.m_a1 = new ARecord(this.m_name, 1, this.m_ttl, InetAddress.getByName("192.169.232.11"));
        this.m_a2 = new ARecord(this.m_name, 1, this.m_ttl + 1L, InetAddress.getByName("192.169.232.12"));
        this.m_s1 = new RRSIGRecord(this.m_name, 1, this.m_ttl, 1, 15, 703710L, new Date(), new Date(), 10, this.m_name, new byte[0]);
        this.m_s2 = new RRSIGRecord(this.m_name, 1, this.m_ttl, 1, 15, 703710L, new Date(), new Date(), 10, this.m_name2, new byte[0]);
    }

    public void test_ctor_0arg() {
        RRsetTest.assertEquals(0, this.m_rs.size());
        try {
            this.m_rs.getDClass();
            RRsetTest.fail("IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            this.m_rs.getType();
            RRsetTest.fail("IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            this.m_rs.getTTL();
            RRsetTest.fail("IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            this.m_rs.getName();
            RRsetTest.fail("IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            this.m_rs.first();
            RRsetTest.fail("IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            this.m_rs.toString();
            RRsetTest.fail("IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        Iterator itr = this.m_rs.rrs();
        RRsetTest.assertNotNull(itr);
        RRsetTest.assertFalse(itr.hasNext());
        itr = this.m_rs.sigs();
        RRsetTest.assertNotNull(itr);
        RRsetTest.assertFalse(itr.hasNext());
    }

    public void test_basics() throws TextParseException, UnknownHostException {
        this.m_rs.addRR(this.m_a1);
        RRsetTest.assertEquals(1, this.m_rs.size());
        RRsetTest.assertEquals(1, this.m_rs.getDClass());
        RRsetTest.assertEquals(this.m_a1, this.m_rs.first());
        RRsetTest.assertEquals(this.m_name, this.m_rs.getName());
        RRsetTest.assertEquals(this.m_ttl, this.m_rs.getTTL());
        RRsetTest.assertEquals(1, this.m_rs.getType());
        this.m_rs.addRR(this.m_a1);
        RRsetTest.assertEquals(1, this.m_rs.size());
        RRsetTest.assertEquals(1, this.m_rs.getDClass());
        RRsetTest.assertEquals(this.m_a1, this.m_rs.first());
        RRsetTest.assertEquals(this.m_name, this.m_rs.getName());
        RRsetTest.assertEquals(this.m_ttl, this.m_rs.getTTL());
        RRsetTest.assertEquals(1, this.m_rs.getType());
        this.m_rs.addRR(this.m_a2);
        RRsetTest.assertEquals(2, this.m_rs.size());
        RRsetTest.assertEquals(1, this.m_rs.getDClass());
        Record r = this.m_rs.first();
        RRsetTest.assertEquals(this.m_a1, r);
        RRsetTest.assertEquals(this.m_name, this.m_rs.getName());
        RRsetTest.assertEquals(this.m_ttl, this.m_rs.getTTL());
        RRsetTest.assertEquals(1, this.m_rs.getType());
        Iterator itr = this.m_rs.rrs();
        RRsetTest.assertEquals(this.m_a1, itr.next());
        RRsetTest.assertEquals(this.m_a2, itr.next());
        itr = this.m_rs.rrs();
        RRsetTest.assertEquals(this.m_a2, itr.next());
        RRsetTest.assertEquals(this.m_a1, itr.next());
        itr = this.m_rs.rrs();
        RRsetTest.assertEquals(this.m_a1, itr.next());
        RRsetTest.assertEquals(this.m_a2, itr.next());
        this.m_rs.deleteRR(this.m_a1);
        RRsetTest.assertEquals(1, this.m_rs.size());
        RRsetTest.assertEquals(1, this.m_rs.getDClass());
        RRsetTest.assertEquals(this.m_a2, this.m_rs.first());
        RRsetTest.assertEquals(this.m_name, this.m_rs.getName());
        RRsetTest.assertEquals(this.m_ttl, this.m_rs.getTTL());
        RRsetTest.assertEquals(1, this.m_rs.getType());
        this.m_rs.addRR(this.m_s1);
        RRsetTest.assertEquals(1, this.m_rs.size());
        itr = this.m_rs.sigs();
        RRsetTest.assertEquals(this.m_s1, itr.next());
        RRsetTest.assertFalse(itr.hasNext());
        this.m_rs.addRR(this.m_s1);
        itr = this.m_rs.sigs();
        RRsetTest.assertEquals(this.m_s1, itr.next());
        RRsetTest.assertFalse(itr.hasNext());
        this.m_rs.addRR(this.m_s2);
        itr = this.m_rs.sigs();
        RRsetTest.assertEquals(this.m_s1, itr.next());
        RRsetTest.assertEquals(this.m_s2, itr.next());
        RRsetTest.assertFalse(itr.hasNext());
        this.m_rs.deleteRR(this.m_s1);
        itr = this.m_rs.sigs();
        RRsetTest.assertEquals(this.m_s2, itr.next());
        RRsetTest.assertFalse(itr.hasNext());
        this.m_rs.clear();
        RRsetTest.assertEquals(0, this.m_rs.size());
        RRsetTest.assertFalse(this.m_rs.rrs().hasNext());
        RRsetTest.assertFalse(this.m_rs.sigs().hasNext());
    }

    public void test_ctor_1arg() {
        this.m_rs.addRR(this.m_a1);
        this.m_rs.addRR(this.m_a2);
        this.m_rs.addRR(this.m_s1);
        this.m_rs.addRR(this.m_s2);
        RRset rs2 = new RRset(this.m_rs);
        RRsetTest.assertEquals(2, rs2.size());
        RRsetTest.assertEquals(this.m_a1, rs2.first());
        Iterator itr = rs2.rrs();
        RRsetTest.assertEquals(this.m_a1, itr.next());
        RRsetTest.assertEquals(this.m_a2, itr.next());
        RRsetTest.assertFalse(itr.hasNext());
        itr = rs2.sigs();
        RRsetTest.assertTrue(itr.hasNext());
        RRsetTest.assertEquals(this.m_s1, itr.next());
        RRsetTest.assertTrue(itr.hasNext());
        RRsetTest.assertEquals(this.m_s2, itr.next());
        RRsetTest.assertFalse(itr.hasNext());
    }

    public void test_toString() {
        this.m_rs.addRR(this.m_a1);
        this.m_rs.addRR(this.m_a2);
        this.m_rs.addRR(this.m_s1);
        this.m_rs.addRR(this.m_s2);
        String out = this.m_rs.toString();
        RRsetTest.assertTrue(out.indexOf(this.m_name.toString()) != -1);
        RRsetTest.assertTrue(out.indexOf(" IN A ") != -1);
        RRsetTest.assertTrue(out.indexOf("[192.169.232.11]") != -1);
        RRsetTest.assertTrue(out.indexOf("[192.169.232.12]") != -1);
    }

    public void test_addRR_invalidType() throws TextParseException {
        this.m_rs.addRR(this.m_a1);
        CNAMERecord c = new CNAMERecord(this.m_name, 1, this.m_ttl, Name.fromString("an.alias."));
        try {
            this.m_rs.addRR(c);
            RRsetTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_addRR_invalidName() throws TextParseException, UnknownHostException {
        this.m_rs.addRR(this.m_a1);
        this.m_a2 = new ARecord(this.m_name2, 1, this.m_ttl, InetAddress.getByName("192.169.232.11"));
        try {
            this.m_rs.addRR(this.m_a2);
            RRsetTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_addRR_invalidDClass() throws TextParseException, UnknownHostException {
        this.m_rs.addRR(this.m_a1);
        this.m_a2 = new ARecord(this.m_name, 3, this.m_ttl, InetAddress.getByName("192.169.232.11"));
        try {
            this.m_rs.addRR(this.m_a2);
            RRsetTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_TTLcalculation() {
        this.m_rs.addRR(this.m_a2);
        RRsetTest.assertEquals(this.m_a2.getTTL(), this.m_rs.getTTL());
        this.m_rs.addRR(this.m_a1);
        RRsetTest.assertEquals(this.m_a1.getTTL(), this.m_rs.getTTL());
        Iterator itr = this.m_rs.rrs();
        while (itr.hasNext()) {
            Record r = (Record)itr.next();
            RRsetTest.assertEquals(this.m_a1.getTTL(), r.getTTL());
        }
    }

    public void test_Record_placement() {
        this.m_rs.addRR(this.m_a1);
        this.m_rs.addRR(this.m_s1);
        this.m_rs.addRR(this.m_a2);
        Iterator itr = this.m_rs.rrs();
        RRsetTest.assertTrue(itr.hasNext());
        RRsetTest.assertEquals(this.m_a1, itr.next());
        RRsetTest.assertTrue(itr.hasNext());
        RRsetTest.assertEquals(this.m_a2, itr.next());
        RRsetTest.assertFalse(itr.hasNext());
        itr = this.m_rs.sigs();
        RRsetTest.assertTrue(itr.hasNext());
        RRsetTest.assertEquals(this.m_s1, itr.next());
        RRsetTest.assertFalse(itr.hasNext());
    }

    public void test_noncycling_iterator() {
        this.m_rs.addRR(this.m_a1);
        this.m_rs.addRR(this.m_a2);
        Iterator itr = this.m_rs.rrs(false);
        RRsetTest.assertTrue(itr.hasNext());
        RRsetTest.assertEquals(this.m_a1, itr.next());
        RRsetTest.assertTrue(itr.hasNext());
        RRsetTest.assertEquals(this.m_a2, itr.next());
        itr = this.m_rs.rrs(false);
        RRsetTest.assertTrue(itr.hasNext());
        RRsetTest.assertEquals(this.m_a1, itr.next());
        RRsetTest.assertTrue(itr.hasNext());
        RRsetTest.assertEquals(this.m_a2, itr.next());
    }
}

