/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.Arrays;
import junit.framework.TestCase;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;

public class MXRecordTest
extends TestCase {
    public void test_getObject() {
        MXRecord d = new MXRecord();
        Record r = d.getObject();
        MXRecordTest.assertTrue(r instanceof MXRecord);
    }

    public void test_ctor_5arg() throws TextParseException {
        Name n = Name.fromString("My.Name.");
        Name m = Name.fromString("My.OtherName.");
        MXRecord d = new MXRecord(n, 1, 703710L, 241, m);
        MXRecordTest.assertEquals(n, d.getName());
        MXRecordTest.assertEquals(15, d.getType());
        MXRecordTest.assertEquals(1, d.getDClass());
        MXRecordTest.assertEquals(703710L, d.getTTL());
        MXRecordTest.assertEquals(241, d.getPriority());
        MXRecordTest.assertEquals(m, d.getTarget());
        MXRecordTest.assertEquals(m, d.getAdditionalName());
    }

    public void test_rrToWire() throws TextParseException {
        Name n = Name.fromString("My.Name.");
        Name m = Name.fromString("M.O.n.");
        MXRecord mr = new MXRecord(n, 1, 45359L, 7979, m);
        DNSOutput dout = new DNSOutput();
        mr.rrToWire(dout, null, true);
        byte[] out = dout.toByteArray();
        byte[] exp = new byte[]{31, 43, 1, 109, 1, 111, 1, 110, 0};
        MXRecordTest.assertTrue(Arrays.equals(exp, out));
        dout = new DNSOutput();
        mr.rrToWire(dout, null, false);
        out = dout.toByteArray();
        exp = new byte[]{31, 43, 1, 77, 1, 79, 1, 110, 0};
        MXRecordTest.assertTrue(Arrays.equals(exp, out));
    }
}

