/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.xbill.DNS.KEYRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;

public class KEYRecordTest
extends TestCase {
    public void test_ctor_0arg() throws UnknownHostException {
        KEYRecord ar = new KEYRecord();
        KEYRecordTest.assertNull(ar.getName());
        KEYRecordTest.assertEquals(0, ar.getType());
        KEYRecordTest.assertEquals(0, ar.getDClass());
        KEYRecordTest.assertEquals(0L, ar.getTTL());
        KEYRecordTest.assertEquals(0, ar.getAlgorithm());
        KEYRecordTest.assertEquals(0, ar.getFlags());
        KEYRecordTest.assertEquals(0, ar.getFootprint());
        KEYRecordTest.assertEquals(0, ar.getProtocol());
        KEYRecordTest.assertNull(ar.getKey());
    }

    public void test_getObject() {
        KEYRecord ar = new KEYRecord();
        Record r = ar.getObject();
        KEYRecordTest.assertTrue(r instanceof KEYRecord);
    }

    public void test_ctor_7arg() throws TextParseException {
        Name n = Name.fromString("My.Absolute.Name.");
        Name r = Name.fromString("My.Relative.Name");
        byte[] key = new byte[]{0, 1, 3, 5, 7, 9};
        KEYRecord kr = new KEYRecord(n, 1, 9388L, 38962, 18, 103, key);
        KEYRecordTest.assertEquals(n, kr.getName());
        KEYRecordTest.assertEquals(25, kr.getType());
        KEYRecordTest.assertEquals(1, kr.getDClass());
        KEYRecordTest.assertEquals(9388L, kr.getTTL());
        KEYRecordTest.assertEquals(38962, kr.getFlags());
        KEYRecordTest.assertEquals(18, kr.getProtocol());
        KEYRecordTest.assertEquals(103, kr.getAlgorithm());
        KEYRecordTest.assertTrue(Arrays.equals(key, kr.getKey()));
        try {
            new KEYRecord(r, 1, 9388L, 38962, 18, 103, key);
            KEYRecordTest.fail("RelativeNameException not thrown");
        }
        catch (RelativeNameException e) {
            // empty catch block
        }
    }

    public void test_Protocol_string() {
        KEYRecordTest.assertEquals("DNSSEC", KEYRecord.Protocol.string(3));
        KEYRecordTest.assertEquals("254", KEYRecord.Protocol.string(254));
        try {
            KEYRecord.Protocol.string(-1);
            KEYRecordTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            KEYRecord.Protocol.string(256);
            KEYRecordTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_Protocol_value() {
        KEYRecordTest.assertEquals(4, KEYRecord.Protocol.value("IPSEC"));
        KEYRecordTest.assertEquals(254, KEYRecord.Protocol.value("254"));
        KEYRecordTest.assertEquals(-1, KEYRecord.Protocol.value("-2"));
        KEYRecordTest.assertEquals(-1, KEYRecord.Protocol.value("256"));
    }

    public void test_Flags_value() {
        KEYRecordTest.assertEquals(-1, KEYRecord.Flags.value("-2"));
        KEYRecordTest.assertEquals(0, KEYRecord.Flags.value("0"));
        KEYRecordTest.assertEquals(43829, KEYRecord.Flags.value("43829"));
        KEYRecordTest.assertEquals(65535, KEYRecord.Flags.value("65535"));
        KEYRecordTest.assertEquals(-1, KEYRecord.Flags.value("65536"));
        KEYRecordTest.assertEquals(4096, KEYRecord.Flags.value("EXTEND"));
        KEYRecordTest.assertEquals(-1, KEYRecord.Flags.value("NOT_A_VALID_NAME"));
        KEYRecordTest.assertEquals(33056, KEYRecord.Flags.value("NOAUTH|ZONE|FLAG10"));
        KEYRecordTest.assertEquals(-1, KEYRecord.Flags.value("NOAUTH|INVALID_NAME|FLAG10"));
        KEYRecordTest.assertEquals(0, KEYRecord.Flags.value("|"));
    }

    public void test_rdataFromString() throws IOException, TextParseException {
        KEYRecord kr = new KEYRecord();
        Tokenizer st = new Tokenizer("NOAUTH|ZONE|FLAG10 EMAIL RSASHA1 AQIDBAUGBwgJ");
        kr.rdataFromString(st, null);
        KEYRecordTest.assertEquals(33056, kr.getFlags());
        KEYRecordTest.assertEquals(2, kr.getProtocol());
        KEYRecordTest.assertEquals(5, kr.getAlgorithm());
        KEYRecordTest.assertTrue(Arrays.equals(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}, kr.getKey()));
        kr = new KEYRecord();
        st = new Tokenizer("NOAUTH|NOKEY|FLAG10 TLS ECC");
        kr.rdataFromString(st, null);
        KEYRecordTest.assertEquals(49184, kr.getFlags());
        KEYRecordTest.assertEquals(1, kr.getProtocol());
        KEYRecordTest.assertEquals(4, kr.getAlgorithm());
        KEYRecordTest.assertNull(kr.getKey());
        kr = new KEYRecord();
        st = new Tokenizer("NOAUTH|ZONE|JUNK EMAIL RSASHA1 AQIDBAUGBwgJ");
        try {
            kr.rdataFromString(st, null);
            KEYRecordTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        kr = new KEYRecord();
        st = new Tokenizer("NOAUTH|ZONE RSASHA1 ECC AQIDBAUGBwgJ");
        try {
            kr.rdataFromString(st, null);
            KEYRecordTest.fail("TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        kr = new KEYRecord();
        st = new Tokenizer("NOAUTH|ZONE EMAIL ZONE AQIDBAUGBwgJ");
        try {
            kr.rdataFromString(st, null);
            KEYRecordTest.fail("TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }
}

