/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.Arrays;
import junit.framework.TestCase;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.WireParseException;

public class DNSInputTest
extends TestCase {
    private byte[] m_raw;
    private DNSInput m_di;

    private void assertEquals(byte[] exp, byte[] act) {
        DNSInputTest.assertTrue(Arrays.equals(exp, act));
    }

    public void setUp() {
        this.m_raw = new byte[]{0, 1, 2, 3, 4, 5, -1, -1, -1, -1};
        this.m_di = new DNSInput(this.m_raw);
    }

    public void test_initial_state() {
        DNSInputTest.assertEquals(0, this.m_di.current());
        DNSInputTest.assertEquals(10, this.m_di.remaining());
    }

    public void test_jump1() {
        this.m_di.jump(1);
        DNSInputTest.assertEquals(1, this.m_di.current());
        DNSInputTest.assertEquals(9, this.m_di.remaining());
    }

    public void test_jump2() {
        this.m_di.jump(9);
        DNSInputTest.assertEquals(9, this.m_di.current());
        DNSInputTest.assertEquals(1, this.m_di.remaining());
    }

    public void test_jump_invalid() {
        try {
            this.m_di.jump(10);
            DNSInputTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_setActive() {
        this.m_di.setActive(5);
        DNSInputTest.assertEquals(0, this.m_di.current());
        DNSInputTest.assertEquals(5, this.m_di.remaining());
    }

    public void test_setActive_boundary1() {
        this.m_di.setActive(10);
        DNSInputTest.assertEquals(0, this.m_di.current());
        DNSInputTest.assertEquals(10, this.m_di.remaining());
    }

    public void test_setActive_boundary2() {
        this.m_di.setActive(0);
        DNSInputTest.assertEquals(0, this.m_di.current());
        DNSInputTest.assertEquals(0, this.m_di.remaining());
    }

    public void test_setActive_invalid() {
        try {
            this.m_di.setActive(11);
            DNSInputTest.fail("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_clearActive() {
        this.m_di.clearActive();
        DNSInputTest.assertEquals(0, this.m_di.current());
        DNSInputTest.assertEquals(10, this.m_di.remaining());
        this.m_di.setActive(5);
        this.m_di.clearActive();
        DNSInputTest.assertEquals(0, this.m_di.current());
        DNSInputTest.assertEquals(10, this.m_di.remaining());
    }

    public void test_restore_invalid() {
        try {
            this.m_di.restore();
            DNSInputTest.fail("IllegalStateException not thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void test_save_restore() {
        this.m_di.jump(4);
        DNSInputTest.assertEquals(4, this.m_di.current());
        DNSInputTest.assertEquals(6, this.m_di.remaining());
        this.m_di.save();
        this.m_di.jump(0);
        DNSInputTest.assertEquals(0, this.m_di.current());
        DNSInputTest.assertEquals(10, this.m_di.remaining());
        this.m_di.restore();
        DNSInputTest.assertEquals(4, this.m_di.current());
        DNSInputTest.assertEquals(6, this.m_di.remaining());
    }

    public void test_readU8_basic() throws WireParseException {
        int v1 = this.m_di.readU8();
        DNSInputTest.assertEquals(1, this.m_di.current());
        DNSInputTest.assertEquals(9, this.m_di.remaining());
        DNSInputTest.assertEquals(0, v1);
    }

    public void test_readU8_maxval() throws WireParseException {
        this.m_di.jump(9);
        int v1 = this.m_di.readU8();
        DNSInputTest.assertEquals(10, this.m_di.current());
        DNSInputTest.assertEquals(0, this.m_di.remaining());
        DNSInputTest.assertEquals(255, v1);
        try {
            v1 = this.m_di.readU8();
            DNSInputTest.fail("WireParseException not thrown");
        }
        catch (WireParseException wireParseException) {
            // empty catch block
        }
    }

    public void test_readU16_basic() throws WireParseException {
        int v1 = this.m_di.readU16();
        DNSInputTest.assertEquals(2, this.m_di.current());
        DNSInputTest.assertEquals(8, this.m_di.remaining());
        DNSInputTest.assertEquals(1, v1);
        this.m_di.jump(1);
        v1 = this.m_di.readU16();
        DNSInputTest.assertEquals(258, v1);
    }

    public void test_readU16_maxval() throws WireParseException {
        this.m_di.jump(8);
        int v = this.m_di.readU16();
        DNSInputTest.assertEquals(10, this.m_di.current());
        DNSInputTest.assertEquals(0, this.m_di.remaining());
        DNSInputTest.assertEquals(65535, v);
        try {
            this.m_di.jump(9);
            this.m_di.readU16();
            DNSInputTest.fail("WireParseException not thrown");
        }
        catch (WireParseException wireParseException) {
            // empty catch block
        }
    }

    public void test_readU32_basic() throws WireParseException {
        long v1 = this.m_di.readU32();
        DNSInputTest.assertEquals(4, this.m_di.current());
        DNSInputTest.assertEquals(6, this.m_di.remaining());
        DNSInputTest.assertEquals(66051L, v1);
    }

    public void test_readU32_maxval() throws WireParseException {
        this.m_di.jump(6);
        long v = this.m_di.readU32();
        DNSInputTest.assertEquals(10, this.m_di.current());
        DNSInputTest.assertEquals(0, this.m_di.remaining());
        DNSInputTest.assertEquals(0xFFFFFFFFL, v);
        try {
            this.m_di.jump(7);
            this.m_di.readU32();
            DNSInputTest.fail("WireParseException not thrown");
        }
        catch (WireParseException wireParseException) {
            // empty catch block
        }
    }

    public void test_readByteArray_0arg() throws WireParseException {
        this.m_di.jump(1);
        byte[] out = this.m_di.readByteArray();
        DNSInputTest.assertEquals(10, this.m_di.current());
        DNSInputTest.assertEquals(0, this.m_di.remaining());
        DNSInputTest.assertEquals(9, out.length);
        for (int i = 0; i < 9; ++i) {
            DNSInputTest.assertEquals(this.m_raw[i + 1], out[i]);
        }
    }

    public void test_readByteArray_0arg_boundary() throws WireParseException {
        this.m_di.jump(9);
        this.m_di.readU8();
        byte[] out = this.m_di.readByteArray();
        DNSInputTest.assertEquals(0, out.length);
    }

    public void test_readByteArray_1arg() throws WireParseException {
        byte[] out = this.m_di.readByteArray(2);
        DNSInputTest.assertEquals(2, this.m_di.current());
        DNSInputTest.assertEquals(8, this.m_di.remaining());
        DNSInputTest.assertEquals(2, out.length);
        DNSInputTest.assertEquals(0, (int)out[0]);
        DNSInputTest.assertEquals(1, (int)out[1]);
    }

    public void test_readByteArray_1arg_boundary() throws WireParseException {
        byte[] out = this.m_di.readByteArray(10);
        DNSInputTest.assertEquals(10, this.m_di.current());
        DNSInputTest.assertEquals(0, this.m_di.remaining());
        this.assertEquals(this.m_raw, out);
    }

    public void test_readByteArray_1arg_invalid() {
        try {
            this.m_di.readByteArray(11);
            DNSInputTest.fail("WireParseException not thrown");
        }
        catch (WireParseException wireParseException) {
            // empty catch block
        }
    }

    public void test_readByteArray_3arg() throws WireParseException {
        byte[] data = new byte[5];
        this.m_di.jump(4);
        this.m_di.readByteArray(data, 1, 4);
        DNSInputTest.assertEquals(8, this.m_di.current());
        DNSInputTest.assertEquals(0, (int)data[0]);
        for (int i = 0; i < 4; ++i) {
            DNSInputTest.assertEquals(this.m_raw[i + 4], data[i + 1]);
        }
    }

    public void test_readCountedSting() throws WireParseException {
        this.m_di.jump(1);
        byte[] out = this.m_di.readCountedString();
        DNSInputTest.assertEquals(1, out.length);
        DNSInputTest.assertEquals(3, this.m_di.current());
        DNSInputTest.assertEquals((int)out[0], 2);
    }
}

